/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceImageMetadataResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeInstanceImageMetadataResponse.Builder, DescribeInstanceImageMetadataResponse> {
    private static final SdkField<List<InstanceImageMetadata>> INSTANCE_IMAGE_METADATA_FIELD = SdkField
            .<List<InstanceImageMetadata>> builder(MarshallingType.LIST)
            .memberName("InstanceImageMetadata")
            .getter(getter(DescribeInstanceImageMetadataResponse::instanceImageMetadata))
            .setter(setter(Builder::instanceImageMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceImageMetadataSet")
                    .unmarshallLocationName("instanceImageMetadataSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceImageMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceImageMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeInstanceImageMetadataResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IMAGE_METADATA_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceImageMetadata> instanceImageMetadata;

    private final String nextToken;

    private DescribeInstanceImageMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.instanceImageMetadata = builder.instanceImageMetadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceImageMetadata property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstanceImageMetadata() {
        return instanceImageMetadata != null && !(instanceImageMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instance and the AMI used to launch the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceImageMetadata} method.
     * </p>
     * 
     * @return Information about the instance and the AMI used to launch the instance.
     */
    public final List<InstanceImageMetadata> instanceImageMetadata() {
        return instanceImageMetadata;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceImageMetadata() ? instanceImageMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceImageMetadataResponse)) {
            return false;
        }
        DescribeInstanceImageMetadataResponse other = (DescribeInstanceImageMetadataResponse) obj;
        return hasInstanceImageMetadata() == other.hasInstanceImageMetadata()
                && Objects.equals(instanceImageMetadata(), other.instanceImageMetadata())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceImageMetadataResponse")
                .add("InstanceImageMetadata", hasInstanceImageMetadata() ? instanceImageMetadata() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceImageMetadata":
            return Optional.ofNullable(clazz.cast(instanceImageMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceImageMetadataSet", INSTANCE_IMAGE_METADATA_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceImageMetadataResponse, T> g) {
        return obj -> g.apply((DescribeInstanceImageMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceImageMetadataResponse> {
        /**
         * <p>
         * Information about the instance and the AMI used to launch the instance.
         * </p>
         * 
         * @param instanceImageMetadata
         *        Information about the instance and the AMI used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceImageMetadata(Collection<InstanceImageMetadata> instanceImageMetadata);

        /**
         * <p>
         * Information about the instance and the AMI used to launch the instance.
         * </p>
         * 
         * @param instanceImageMetadata
         *        Information about the instance and the AMI used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceImageMetadata(InstanceImageMetadata... instanceImageMetadata);

        /**
         * <p>
         * Information about the instance and the AMI used to launch the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceImageMetadata.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.InstanceImageMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceImageMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceImageMetadata(List<InstanceImageMetadata>)}.
         * 
         * @param instanceImageMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceImageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceImageMetadata(java.util.Collection<InstanceImageMetadata>)
         */
        Builder instanceImageMetadata(Consumer<InstanceImageMetadata.Builder>... instanceImageMetadata);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceImageMetadata> instanceImageMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceImageMetadataResponse model) {
            super(model);
            instanceImageMetadata(model.instanceImageMetadata);
            nextToken(model.nextToken);
        }

        public final List<InstanceImageMetadata.Builder> getInstanceImageMetadata() {
            List<InstanceImageMetadata.Builder> result = InstanceImageMetadataListCopier
                    .copyToBuilder(this.instanceImageMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceImageMetadata(Collection<InstanceImageMetadata.BuilderImpl> instanceImageMetadata) {
            this.instanceImageMetadata = InstanceImageMetadataListCopier.copyFromBuilder(instanceImageMetadata);
        }

        @Override
        public final Builder instanceImageMetadata(Collection<InstanceImageMetadata> instanceImageMetadata) {
            this.instanceImageMetadata = InstanceImageMetadataListCopier.copy(instanceImageMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceImageMetadata(InstanceImageMetadata... instanceImageMetadata) {
            instanceImageMetadata(Arrays.asList(instanceImageMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceImageMetadata(Consumer<InstanceImageMetadata.Builder>... instanceImageMetadata) {
            instanceImageMetadata(Stream.of(instanceImageMetadata)
                    .map(c -> InstanceImageMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstanceImageMetadataResponse build() {
            return new DescribeInstanceImageMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
