/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instance and the AMI used to launch the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceImageMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceImageMetadata.Builder, InstanceImageMetadata> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(InstanceImageMetadata::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(InstanceImageMetadata::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LaunchTime")
            .getter(getter(InstanceImageMetadata::launchTime))
            .setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime")
                    .unmarshallLocationName("launchTime").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(InstanceImageMetadata::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ZoneId")
            .getter(getter(InstanceImageMetadata::zoneId))
            .setter(setter(Builder::zoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneId")
                    .unmarshallLocationName("zoneId").build()).build();

    private static final SdkField<InstanceState> STATE_FIELD = SdkField
            .<InstanceState> builder(MarshallingType.SDK_POJO)
            .memberName("State")
            .getter(getter(InstanceImageMetadata::state))
            .setter(setter(Builder::state))
            .constructor(InstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState")
                    .unmarshallLocationName("instanceState").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(InstanceImageMetadata::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwnerId")
                    .unmarshallLocationName("instanceOwnerId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(InstanceImageMetadata::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<ImageMetadata> IMAGE_METADATA_FIELD = SdkField
            .<ImageMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("ImageMetadata")
            .getter(getter(InstanceImageMetadata::imageMetadata))
            .setter(setter(Builder::imageMetadata))
            .constructor(ImageMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageMetadata")
                    .unmarshallLocationName("imageMetadata").build()).build();

    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField
            .<OperatorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Operator")
            .getter(getter(InstanceImageMetadata::operator))
            .setter(setter(Builder::operator))
            .constructor(OperatorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator")
                    .unmarshallLocationName("operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INSTANCE_TYPE_FIELD, LAUNCH_TIME_FIELD, AVAILABILITY_ZONE_FIELD, ZONE_ID_FIELD, STATE_FIELD, OWNER_ID_FIELD,
            TAGS_FIELD, IMAGE_METADATA_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String instanceType;

    private final Instant launchTime;

    private final String availabilityZone;

    private final String zoneId;

    private final InstanceState state;

    private final String ownerId;

    private final List<Tag> tags;

    private final ImageMetadata imageMetadata;

    private final OperatorResponse operator;

    private InstanceImageMetadata(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.launchTime = builder.launchTime;
        this.availabilityZone = builder.availabilityZone;
        this.zoneId = builder.zoneId;
        this.state = builder.state;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
        this.imageMetadata = builder.imageMetadata;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The time the instance was launched.
     * </p>
     * 
     * @return The time the instance was launched.
     */
    public final Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The Availability Zone or Local Zone of the instance.
     * </p>
     * 
     * @return The Availability Zone or Local Zone of the instance.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the Availability Zone or Local Zone of the instance.
     * </p>
     * 
     * @return The ID of the Availability Zone or Local Zone of the instance.
     */
    public final String zoneId() {
        return zoneId;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * 
     * @return The current state of the instance.
     */
    public final InstanceState state() {
        return state;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the instance.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the instance.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the instance.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Information about the AMI used to launch the instance.
     * </p>
     * 
     * @return Information about the AMI used to launch the instance.
     */
    public final ImageMetadata imageMetadata() {
        return imageMetadata;
    }

    /**
     * <p>
     * The entity that manages the instance.
     * </p>
     * 
     * @return The entity that manages the instance.
     */
    public final OperatorResponse operator() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(zoneId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceImageMetadata)) {
            return false;
        }
        InstanceImageMetadata other = (InstanceImageMetadata) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(launchTime(), other.launchTime())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(zoneId(), other.zoneId())
                && Objects.equals(state(), other.state()) && Objects.equals(ownerId(), other.ownerId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(imageMetadata(), other.imageMetadata()) && Objects.equals(operator(), other.operator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceImageMetadata").add("InstanceId", instanceId())
                .add("InstanceType", instanceTypeAsString()).add("LaunchTime", launchTime())
                .add("AvailabilityZone", availabilityZone()).add("ZoneId", zoneId()).add("State", state())
                .add("OwnerId", ownerId()).add("Tags", hasTags() ? tags() : null).add("ImageMetadata", imageMetadata())
                .add("Operator", operator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ZoneId":
            return Optional.ofNullable(clazz.cast(zoneId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ImageMetadata":
            return Optional.ofNullable(clazz.cast(imageMetadata()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("LaunchTime", LAUNCH_TIME_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("ZoneId", ZONE_ID_FIELD);
        map.put("InstanceState", STATE_FIELD);
        map.put("InstanceOwnerId", OWNER_ID_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("ImageMetadata", IMAGE_METADATA_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceImageMetadata, T> g) {
        return obj -> g.apply((InstanceImageMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceImageMetadata> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The time the instance was launched.
         * </p>
         * 
         * @param launchTime
         *        The time the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The Availability Zone or Local Zone of the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone or Local Zone of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the Availability Zone or Local Zone of the instance.
         * </p>
         * 
         * @param zoneId
         *        The ID of the Availability Zone or Local Zone of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneId(String zoneId);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param state
         *        The current state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceState.Builder} avoiding the need
         * to create one manually via {@link InstanceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(InstanceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(InstanceState)
         */
        default Builder state(Consumer<InstanceState.Builder> state) {
            return state(InstanceState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the instance.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Information about the AMI used to launch the instance.
         * </p>
         * 
         * @param imageMetadata
         *        Information about the AMI used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageMetadata(ImageMetadata imageMetadata);

        /**
         * <p>
         * Information about the AMI used to launch the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageMetadata.Builder} avoiding the need
         * to create one manually via {@link ImageMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #imageMetadata(ImageMetadata)}.
         * 
         * @param imageMetadata
         *        a consumer that will call methods on {@link ImageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageMetadata(ImageMetadata)
         */
        default Builder imageMetadata(Consumer<ImageMetadata.Builder> imageMetadata) {
            return imageMetadata(ImageMetadata.builder().applyMutation(imageMetadata).build());
        }

        /**
         * <p>
         * The entity that manages the instance.
         * </p>
         * 
         * @param operator
         *        The entity that manages the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(OperatorResponse operator);

        /**
         * <p>
         * The entity that manages the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperatorResponse.Builder} avoiding the
         * need to create one manually via {@link OperatorResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperatorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #operator(OperatorResponse)}.
         * 
         * @param operator
         *        a consumer that will call methods on {@link OperatorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operator(OperatorResponse)
         */
        default Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return operator(OperatorResponse.builder().applyMutation(operator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String instanceType;

        private Instant launchTime;

        private String availabilityZone;

        private String zoneId;

        private InstanceState state;

        private String ownerId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ImageMetadata imageMetadata;

        private OperatorResponse operator;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceImageMetadata model) {
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            launchTime(model.launchTime);
            availabilityZone(model.availabilityZone);
            zoneId(model.zoneId);
            state(model.state);
            ownerId(model.ownerId);
            tags(model.tags);
            imageMetadata(model.imageMetadata);
            operator(model.operator);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getZoneId() {
            return zoneId;
        }

        public final void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public final InstanceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ImageMetadata.Builder getImageMetadata() {
            return imageMetadata != null ? imageMetadata.toBuilder() : null;
        }

        public final void setImageMetadata(ImageMetadata.BuilderImpl imageMetadata) {
            this.imageMetadata = imageMetadata != null ? imageMetadata.build() : null;
        }

        @Override
        public final Builder imageMetadata(ImageMetadata imageMetadata) {
            this.imageMetadata = imageMetadata;
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return operator != null ? operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public InstanceImageMetadata build() {
            return new InstanceImageMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
