/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceNetworkPerformanceOptionsResponse extends Ec2Response
        implements
        ToCopyableBuilder<ModifyInstanceNetworkPerformanceOptionsResponse.Builder, ModifyInstanceNetworkPerformanceOptionsResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyInstanceNetworkPerformanceOptionsResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> BANDWIDTH_WEIGHTING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BandwidthWeighting")
            .getter(getter(ModifyInstanceNetworkPerformanceOptionsResponse::bandwidthWeightingAsString))
            .setter(setter(Builder::bandwidthWeighting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandwidthWeighting")
                    .unmarshallLocationName("bandwidthWeighting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            BANDWIDTH_WEIGHTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String bandwidthWeighting;

    private ModifyInstanceNetworkPerformanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.bandwidthWeighting = builder.bandwidthWeighting;
    }

    /**
     * <p>
     * The instance ID that was updated.
     * </p>
     * 
     * @return The instance ID that was updated.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Contains the updated configuration for bandwidth weighting on the specified instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #bandwidthWeighting} will return {@link InstanceBandwidthWeighting#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #bandwidthWeightingAsString}.
     * </p>
     * 
     * @return Contains the updated configuration for bandwidth weighting on the specified instance.
     * @see InstanceBandwidthWeighting
     */
    public final InstanceBandwidthWeighting bandwidthWeighting() {
        return InstanceBandwidthWeighting.fromValue(bandwidthWeighting);
    }

    /**
     * <p>
     * Contains the updated configuration for bandwidth weighting on the specified instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #bandwidthWeighting} will return {@link InstanceBandwidthWeighting#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #bandwidthWeightingAsString}.
     * </p>
     * 
     * @return Contains the updated configuration for bandwidth weighting on the specified instance.
     * @see InstanceBandwidthWeighting
     */
    public final String bandwidthWeightingAsString() {
        return bandwidthWeighting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthWeightingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceNetworkPerformanceOptionsResponse)) {
            return false;
        }
        ModifyInstanceNetworkPerformanceOptionsResponse other = (ModifyInstanceNetworkPerformanceOptionsResponse) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(bandwidthWeightingAsString(), other.bandwidthWeightingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceNetworkPerformanceOptionsResponse").add("InstanceId", instanceId())
                .add("BandwidthWeighting", bandwidthWeightingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "BandwidthWeighting":
            return Optional.ofNullable(clazz.cast(bandwidthWeightingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("BandwidthWeighting", BANDWIDTH_WEIGHTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceNetworkPerformanceOptionsResponse, T> g) {
        return obj -> g.apply((ModifyInstanceNetworkPerformanceOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyInstanceNetworkPerformanceOptionsResponse> {
        /**
         * <p>
         * The instance ID that was updated.
         * </p>
         * 
         * @param instanceId
         *        The instance ID that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Contains the updated configuration for bandwidth weighting on the specified instance.
         * </p>
         * 
         * @param bandwidthWeighting
         *        Contains the updated configuration for bandwidth weighting on the specified instance.
         * @see InstanceBandwidthWeighting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceBandwidthWeighting
         */
        Builder bandwidthWeighting(String bandwidthWeighting);

        /**
         * <p>
         * Contains the updated configuration for bandwidth weighting on the specified instance.
         * </p>
         * 
         * @param bandwidthWeighting
         *        Contains the updated configuration for bandwidth weighting on the specified instance.
         * @see InstanceBandwidthWeighting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceBandwidthWeighting
         */
        Builder bandwidthWeighting(InstanceBandwidthWeighting bandwidthWeighting);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String instanceId;

        private String bandwidthWeighting;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceNetworkPerformanceOptionsResponse model) {
            super(model);
            instanceId(model.instanceId);
            bandwidthWeighting(model.bandwidthWeighting);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getBandwidthWeighting() {
            return bandwidthWeighting;
        }

        public final void setBandwidthWeighting(String bandwidthWeighting) {
            this.bandwidthWeighting = bandwidthWeighting;
        }

        @Override
        public final Builder bandwidthWeighting(String bandwidthWeighting) {
            this.bandwidthWeighting = bandwidthWeighting;
            return this;
        }

        @Override
        public final Builder bandwidthWeighting(InstanceBandwidthWeighting bandwidthWeighting) {
            this.bandwidthWeighting(bandwidthWeighting == null ? null : bandwidthWeighting.toString());
            return this;
        }

        @Override
        public ModifyInstanceNetworkPerformanceOptionsResponse build() {
            return new ModifyInstanceNetworkPerformanceOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
