/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a set of routes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessInstanceOpenVpnClientConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder, VerifiedAccessInstanceOpenVpnClientConfiguration> {
    private static final SdkField<String> CONFIG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Config")
            .getter(getter(VerifiedAccessInstanceOpenVpnClientConfiguration::config))
            .setter(setter(Builder::config))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config")
                    .unmarshallLocationName("config").build()).build();

    private static final SdkField<List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute>> ROUTES_FIELD = SdkField
            .<List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(VerifiedAccessInstanceOpenVpnClientConfiguration::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet")
                    .unmarshallLocationName("routeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(VerifiedAccessInstanceOpenVpnClientConfigurationRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_FIELD, ROUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String config;

    private final List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes;

    private VerifiedAccessInstanceOpenVpnClientConfiguration(BuilderImpl builder) {
        this.config = builder.config;
        this.routes = builder.routes;
    }

    /**
     * <p>
     * The base64-encoded Open VPN client configuration.
     * </p>
     * 
     * @return The base64-encoded Open VPN client configuration.
     */
    public final String config() {
        return config;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return The routes.
     */
    public final List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes() {
        return routes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(config());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstanceOpenVpnClientConfiguration)) {
            return false;
        }
        VerifiedAccessInstanceOpenVpnClientConfiguration other = (VerifiedAccessInstanceOpenVpnClientConfiguration) obj;
        return Objects.equals(config(), other.config()) && hasRoutes() == other.hasRoutes()
                && Objects.equals(routes(), other.routes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessInstanceOpenVpnClientConfiguration").add("Config", config())
                .add("Routes", hasRoutes() ? routes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Config", CONFIG_FIELD);
        map.put("RouteSet", ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstanceOpenVpnClientConfiguration, T> g) {
        return obj -> g.apply((VerifiedAccessInstanceOpenVpnClientConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessInstanceOpenVpnClientConfiguration> {
        /**
         * <p>
         * The base64-encoded Open VPN client configuration.
         * </p>
         * 
         * @param config
         *        The base64-encoded Open VPN client configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(String config);

        /**
         * <p>
         * The routes.
         * </p>
         * 
         * @param routes
         *        The routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes);

        /**
         * <p>
         * The routes.
         * </p>
         * 
         * @param routes
         *        The routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(VerifiedAccessInstanceOpenVpnClientConfigurationRoute... routes);

        /**
         * <p>
         * The routes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfigurationRoute#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #routes(List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<VerifiedAccessInstanceOpenVpnClientConfigurationRoute>)
         */
        Builder routes(Consumer<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder>... routes);
    }

    static final class BuilderImpl implements Builder {
        private String config;

        private List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstanceOpenVpnClientConfiguration model) {
            config(model.config);
            routes(model.routes);
        }

        public final String getConfig() {
            return config;
        }

        public final void setConfig(String config) {
            this.config = config;
        }

        @Override
        public final Builder config(String config) {
            this.config = config;
            return this;
        }

        public final List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder> getRoutes() {
            List<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder> result = VerifiedAccessInstanceOpenVpnClientConfigurationRouteListCopier
                    .copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.BuilderImpl> routes) {
            this.routes = VerifiedAccessInstanceOpenVpnClientConfigurationRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<VerifiedAccessInstanceOpenVpnClientConfigurationRoute> routes) {
            this.routes = VerifiedAccessInstanceOpenVpnClientConfigurationRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(VerifiedAccessInstanceOpenVpnClientConfigurationRoute... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<VerifiedAccessInstanceOpenVpnClientConfigurationRoute.Builder>... routes) {
            routes(Stream.of(routes)
                    .map(c -> VerifiedAccessInstanceOpenVpnClientConfigurationRoute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public VerifiedAccessInstanceOpenVpnClientConfiguration build() {
            return new VerifiedAccessInstanceOpenVpnClientConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
