/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityBlockOfferingsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeCapacityBlockOfferingsRequest.Builder, DescribeCapacityBlockOfferingsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeCapacityBlockOfferingsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(DescribeCapacityBlockOfferingsRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(DescribeCapacityBlockOfferingsRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final SdkField<Instant> START_DATE_RANGE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDateRange")
            .getter(getter(DescribeCapacityBlockOfferingsRequest::startDateRange))
            .setter(setter(Builder::startDateRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateRange")
                    .unmarshallLocationName("StartDateRange").build()).build();

    private static final SdkField<Instant> END_DATE_RANGE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDateRange")
            .getter(getter(DescribeCapacityBlockOfferingsRequest::endDateRange))
            .setter(setter(Builder::endDateRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateRange")
                    .unmarshallLocationName("EndDateRange").build()).build();

    private static final SdkField<Integer> CAPACITY_DURATION_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CapacityDurationHours")
            .getter(getter(DescribeCapacityBlockOfferingsRequest::capacityDurationHours))
            .setter(setter(Builder::capacityDurationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityDurationHours")
                    .unmarshallLocationName("CapacityDurationHours").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCapacityBlockOfferingsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeCapacityBlockOfferingsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, START_DATE_RANGE_FIELD, END_DATE_RANGE_FIELD,
            CAPACITY_DURATION_HOURS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String instanceType;

    private final Integer instanceCount;

    private final Instant startDateRange;

    private final Instant endDateRange;

    private final Integer capacityDurationHours;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeCapacityBlockOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.startDateRange = builder.startDateRange;
        this.endDateRange = builder.endDateRange;
        this.capacityDurationHours = builder.capacityDurationHours;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The type of instance for which the Capacity Block offering reserves capacity.
     * </p>
     * 
     * @return The type of instance for which the Capacity Block offering reserves capacity.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances for which to reserve capacity.
     * </p>
     * 
     * @return The number of instances for which to reserve capacity.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The earliest start date for the Capacity Block offering.
     * </p>
     * 
     * @return The earliest start date for the Capacity Block offering.
     */
    public final Instant startDateRange() {
        return startDateRange;
    }

    /**
     * <p>
     * The latest end date for the Capacity Block offering.
     * </p>
     * 
     * @return The latest end date for the Capacity Block offering.
     */
    public final Instant endDateRange() {
        return endDateRange;
    }

    /**
     * <p>
     * The number of hours for which to reserve Capacity Block.
     * </p>
     * 
     * @return The number of hours for which to reserve Capacity Block.
     */
    public final Integer capacityDurationHours() {
        return capacityDurationHours;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(startDateRange());
        hashCode = 31 * hashCode + Objects.hashCode(endDateRange());
        hashCode = 31 * hashCode + Objects.hashCode(capacityDurationHours());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlockOfferingsRequest)) {
            return false;
        }
        DescribeCapacityBlockOfferingsRequest other = (DescribeCapacityBlockOfferingsRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(startDateRange(), other.startDateRange())
                && Objects.equals(endDateRange(), other.endDateRange())
                && Objects.equals(capacityDurationHours(), other.capacityDurationHours())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapacityBlockOfferingsRequest").add("DryRun", dryRun())
                .add("InstanceType", instanceType()).add("InstanceCount", instanceCount())
                .add("StartDateRange", startDateRange()).add("EndDateRange", endDateRange())
                .add("CapacityDurationHours", capacityDurationHours()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "StartDateRange":
            return Optional.ofNullable(clazz.cast(startDateRange()));
        case "EndDateRange":
            return Optional.ofNullable(clazz.cast(endDateRange()));
        case "CapacityDurationHours":
            return Optional.ofNullable(clazz.cast(capacityDurationHours()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("StartDateRange", START_DATE_RANGE_FIELD);
        map.put("EndDateRange", END_DATE_RANGE_FIELD);
        map.put("CapacityDurationHours", CAPACITY_DURATION_HOURS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlockOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeCapacityBlockOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCapacityBlockOfferingsRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The type of instance for which the Capacity Block offering reserves capacity.
         * </p>
         * 
         * @param instanceType
         *        The type of instance for which the Capacity Block offering reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of instances for which to reserve capacity.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances for which to reserve capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The earliest start date for the Capacity Block offering.
         * </p>
         * 
         * @param startDateRange
         *        The earliest start date for the Capacity Block offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateRange(Instant startDateRange);

        /**
         * <p>
         * The latest end date for the Capacity Block offering.
         * </p>
         * 
         * @param endDateRange
         *        The latest end date for the Capacity Block offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateRange(Instant endDateRange);

        /**
         * <p>
         * The number of hours for which to reserve Capacity Block.
         * </p>
         * 
         * @param capacityDurationHours
         *        The number of hours for which to reserve Capacity Block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityDurationHours(Integer capacityDurationHours);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String instanceType;

        private Integer instanceCount;

        private Instant startDateRange;

        private Instant endDateRange;

        private Integer capacityDurationHours;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlockOfferingsRequest model) {
            super(model);
            dryRun(model.dryRun);
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            startDateRange(model.startDateRange);
            endDateRange(model.endDateRange);
            capacityDurationHours(model.capacityDurationHours);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Instant getStartDateRange() {
            return startDateRange;
        }

        public final void setStartDateRange(Instant startDateRange) {
            this.startDateRange = startDateRange;
        }

        @Override
        public final Builder startDateRange(Instant startDateRange) {
            this.startDateRange = startDateRange;
            return this;
        }

        public final Instant getEndDateRange() {
            return endDateRange;
        }

        public final void setEndDateRange(Instant endDateRange) {
            this.endDateRange = endDateRange;
        }

        @Override
        public final Builder endDateRange(Instant endDateRange) {
            this.endDateRange = endDateRange;
            return this;
        }

        public final Integer getCapacityDurationHours() {
            return capacityDurationHours;
        }

        public final void setCapacityDurationHours(Integer capacityDurationHours) {
            this.capacityDurationHours = capacityDurationHours;
        }

        @Override
        public final Builder capacityDurationHours(Integer capacityDurationHours) {
            this.capacityDurationHours = capacityDurationHours;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCapacityBlockOfferingsRequest build() {
            return new DescribeCapacityBlockOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
