/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableFastSnapshotRestoresResponse extends Ec2Response implements
        ToCopyableBuilder<DisableFastSnapshotRestoresResponse.Builder, DisableFastSnapshotRestoresResponse> {
    private static final SdkField<List<DisableFastSnapshotRestoreSuccessItem>> SUCCESSFUL_FIELD = SdkField
            .<List<DisableFastSnapshotRestoreSuccessItem>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(DisableFastSnapshotRestoresResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful")
                    .unmarshallLocationName("successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DisableFastSnapshotRestoreSuccessItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisableFastSnapshotRestoreSuccessItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<DisableFastSnapshotRestoreErrorItem>> UNSUCCESSFUL_FIELD = SdkField
            .<List<DisableFastSnapshotRestoreErrorItem>> builder(MarshallingType.LIST)
            .memberName("Unsuccessful")
            .getter(getter(DisableFastSnapshotRestoresResponse::unsuccessful))
            .setter(setter(Builder::unsuccessful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful")
                    .unmarshallLocationName("unsuccessful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DisableFastSnapshotRestoreErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisableFastSnapshotRestoreErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD,
            UNSUCCESSFUL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DisableFastSnapshotRestoreSuccessItem> successful;

    private final List<DisableFastSnapshotRestoreErrorItem> unsuccessful;

    private DisableFastSnapshotRestoresResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots for which fast snapshot restores were successfully disabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return Information about the snapshots for which fast snapshot restores were successfully disabled.
     */
    public final List<DisableFastSnapshotRestoreSuccessItem> successful() {
        return successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Unsuccessful property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnsuccessful() {
        return unsuccessful != null && !(unsuccessful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots for which fast snapshot restores could not be disabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsuccessful} method.
     * </p>
     * 
     * @return Information about the snapshots for which fast snapshot restores could not be disabled.
     */
    public final List<DisableFastSnapshotRestoreErrorItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsuccessful() ? unsuccessful() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableFastSnapshotRestoresResponse)) {
            return false;
        }
        DisableFastSnapshotRestoresResponse other = (DisableFastSnapshotRestoresResponse) obj;
        return hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful())
                && hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableFastSnapshotRestoresResponse").add("Successful", hasSuccessful() ? successful() : null)
                .add("Unsuccessful", hasUnsuccessful() ? unsuccessful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Unsuccessful":
            return Optional.ofNullable(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Successful", SUCCESSFUL_FIELD);
        map.put("Unsuccessful", UNSUCCESSFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableFastSnapshotRestoresResponse, T> g) {
        return obj -> g.apply((DisableFastSnapshotRestoresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DisableFastSnapshotRestoresResponse> {
        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully disabled.
         * </p>
         * 
         * @param successful
         *        Information about the snapshots for which fast snapshot restores were successfully disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<DisableFastSnapshotRestoreSuccessItem> successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully disabled.
         * </p>
         * 
         * @param successful
         *        Information about the snapshots for which fast snapshot restores were successfully disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(DisableFastSnapshotRestoreSuccessItem... successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully disabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreSuccessItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreSuccessItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreSuccessItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successful(List<DisableFastSnapshotRestoreSuccessItem>)}.
         * 
         * @param successful
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreSuccessItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(java.util.Collection<DisableFastSnapshotRestoreSuccessItem>)
         */
        Builder successful(Consumer<DisableFastSnapshotRestoreSuccessItem.Builder>... successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be disabled.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the snapshots for which fast snapshot restores could not be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<DisableFastSnapshotRestoreErrorItem> unsuccessful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be disabled.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the snapshots for which fast snapshot restores could not be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(DisableFastSnapshotRestoreErrorItem... unsuccessful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be disabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #unsuccessful(List<DisableFastSnapshotRestoreErrorItem>)}.
         * 
         * @param unsuccessful
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessful(java.util.Collection<DisableFastSnapshotRestoreErrorItem>)
         */
        Builder unsuccessful(Consumer<DisableFastSnapshotRestoreErrorItem.Builder>... unsuccessful);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<DisableFastSnapshotRestoreSuccessItem> successful = DefaultSdkAutoConstructList.getInstance();

        private List<DisableFastSnapshotRestoreErrorItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableFastSnapshotRestoresResponse model) {
            super(model);
            successful(model.successful);
            unsuccessful(model.unsuccessful);
        }

        public final List<DisableFastSnapshotRestoreSuccessItem.Builder> getSuccessful() {
            List<DisableFastSnapshotRestoreSuccessItem.Builder> result = DisableFastSnapshotRestoreSuccessSetCopier
                    .copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<DisableFastSnapshotRestoreSuccessItem.BuilderImpl> successful) {
            this.successful = DisableFastSnapshotRestoreSuccessSetCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<DisableFastSnapshotRestoreSuccessItem> successful) {
            this.successful = DisableFastSnapshotRestoreSuccessSetCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(DisableFastSnapshotRestoreSuccessItem... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<DisableFastSnapshotRestoreSuccessItem.Builder>... successful) {
            successful(Stream.of(successful).map(c -> DisableFastSnapshotRestoreSuccessItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DisableFastSnapshotRestoreErrorItem.Builder> getUnsuccessful() {
            List<DisableFastSnapshotRestoreErrorItem.Builder> result = DisableFastSnapshotRestoreErrorSetCopier
                    .copyToBuilder(this.unsuccessful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessful(Collection<DisableFastSnapshotRestoreErrorItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = DisableFastSnapshotRestoreErrorSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public final Builder unsuccessful(Collection<DisableFastSnapshotRestoreErrorItem> unsuccessful) {
            this.unsuccessful = DisableFastSnapshotRestoreErrorSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(DisableFastSnapshotRestoreErrorItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<DisableFastSnapshotRestoreErrorItem.Builder>... unsuccessful) {
            unsuccessful(Stream.of(unsuccessful).map(c -> DisableFastSnapshotRestoreErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DisableFastSnapshotRestoresResponse build() {
            return new DisableFastSnapshotRestoresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
