/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IAM SAML identity provider used for federated authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FederatedAuthenticationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FederatedAuthenticationRequest.Builder, FederatedAuthenticationRequest> {
    private static final SdkField<String> SAML_PROVIDER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SAMLProviderArn")
            .getter(getter(FederatedAuthenticationRequest::samlProviderArn))
            .setter(setter(Builder::samlProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLProviderArn")
                    .unmarshallLocationName("SAMLProviderArn").build()).build();

    private static final SdkField<String> SELF_SERVICE_SAML_PROVIDER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SelfServiceSAMLProviderArn")
            .getter(getter(FederatedAuthenticationRequest::selfServiceSAMLProviderArn))
            .setter(setter(Builder::selfServiceSAMLProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfServiceSAMLProviderArn")
                    .unmarshallLocationName("SelfServiceSAMLProviderArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_PROVIDER_ARN_FIELD,
            SELF_SERVICE_SAML_PROVIDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String samlProviderArn;

    private final String selfServiceSAMLProviderArn;

    private FederatedAuthenticationRequest(BuilderImpl builder) {
        this.samlProviderArn = builder.samlProviderArn;
        this.selfServiceSAMLProviderArn = builder.selfServiceSAMLProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM SAML identity provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM SAML identity provider.
     */
    public final String samlProviderArn() {
        return samlProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
     */
    public final String selfServiceSAMLProviderArn() {
        return selfServiceSAMLProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samlProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(selfServiceSAMLProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FederatedAuthenticationRequest)) {
            return false;
        }
        FederatedAuthenticationRequest other = (FederatedAuthenticationRequest) obj;
        return Objects.equals(samlProviderArn(), other.samlProviderArn())
                && Objects.equals(selfServiceSAMLProviderArn(), other.selfServiceSAMLProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FederatedAuthenticationRequest").add("SAMLProviderArn", samlProviderArn())
                .add("SelfServiceSAMLProviderArn", selfServiceSAMLProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SAMLProviderArn":
            return Optional.ofNullable(clazz.cast(samlProviderArn()));
        case "SelfServiceSAMLProviderArn":
            return Optional.ofNullable(clazz.cast(selfServiceSAMLProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SAMLProviderArn", SAML_PROVIDER_ARN_FIELD);
        map.put("SelfServiceSAMLProviderArn", SELF_SERVICE_SAML_PROVIDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FederatedAuthenticationRequest, T> g) {
        return obj -> g.apply((FederatedAuthenticationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FederatedAuthenticationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM SAML identity provider.
         * </p>
         * 
         * @param samlProviderArn
         *        The Amazon Resource Name (ARN) of the IAM SAML identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderArn(String samlProviderArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
         * </p>
         * 
         * @param selfServiceSAMLProviderArn
         *        The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServiceSAMLProviderArn(String selfServiceSAMLProviderArn);
    }

    static final class BuilderImpl implements Builder {
        private String samlProviderArn;

        private String selfServiceSAMLProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FederatedAuthenticationRequest model) {
            samlProviderArn(model.samlProviderArn);
            selfServiceSAMLProviderArn(model.selfServiceSAMLProviderArn);
        }

        public final String getSamlProviderArn() {
            return samlProviderArn;
        }

        public final void setSamlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        public final String getSelfServiceSAMLProviderArn() {
            return selfServiceSAMLProviderArn;
        }

        public final void setSelfServiceSAMLProviderArn(String selfServiceSAMLProviderArn) {
            this.selfServiceSAMLProviderArn = selfServiceSAMLProviderArn;
        }

        @Override
        public final Builder selfServiceSAMLProviderArn(String selfServiceSAMLProviderArn) {
            this.selfServiceSAMLProviderArn = selfServiceSAMLProviderArn;
            return this;
        }

        @Override
        public FederatedAuthenticationRequest build() {
            return new FederatedAuthenticationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
