/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyPrivateDnsNameOptionsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyPrivateDnsNameOptionsRequest.Builder, ModifyPrivateDnsNameOptionsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyPrivateDnsNameOptionsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyPrivateDnsNameOptionsRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> PRIVATE_DNS_HOSTNAME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsHostnameType")
            .getter(getter(ModifyPrivateDnsNameOptionsRequest::privateDnsHostnameTypeAsString))
            .setter(setter(Builder::privateDnsHostnameType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsHostnameType")
                    .unmarshallLocationName("PrivateDnsHostnameType").build()).build();

    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableResourceNameDnsARecord")
            .getter(getter(ModifyPrivateDnsNameOptionsRequest::enableResourceNameDnsARecord))
            .setter(setter(Builder::enableResourceNameDnsARecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsARecord")
                    .unmarshallLocationName("EnableResourceNameDnsARecord").build()).build();

    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableResourceNameDnsAAAARecord")
            .getter(getter(ModifyPrivateDnsNameOptionsRequest::enableResourceNameDnsAAAARecord))
            .setter(setter(Builder::enableResourceNameDnsAAAARecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsAAAARecord")
                    .unmarshallLocationName("EnableResourceNameDnsAAAARecord").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            INSTANCE_ID_FIELD, PRIVATE_DNS_HOSTNAME_TYPE_FIELD, ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD,
            ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String instanceId;

    private final String privateDnsHostnameType;

    private final Boolean enableResourceNameDnsARecord;

    private final Boolean enableResourceNameDnsAAAARecord;

    private ModifyPrivateDnsNameOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.instanceId = builder.instanceId;
        this.privateDnsHostnameType = builder.privateDnsHostnameType;
        this.enableResourceNameDnsARecord = builder.enableResourceNameDnsARecord;
        this.enableResourceNameDnsAAAARecord = builder.enableResourceNameDnsAAAARecord;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance
     * IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack
     * subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #privateDnsHostnameType} will return {@link HostnameType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #privateDnsHostnameTypeAsString}.
     * </p>
     * 
     * @return The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the
     *         instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For
     *         dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
     * @see HostnameType
     */
    public final HostnameType privateDnsHostnameType() {
        return HostnameType.fromValue(privateDnsHostnameType);
    }

    /**
     * <p>
     * The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance
     * IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack
     * subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #privateDnsHostnameType} will return {@link HostnameType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #privateDnsHostnameTypeAsString}.
     * </p>
     * 
     * @return The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the
     *         instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For
     *         dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
     * @see HostnameType
     */
    public final String privateDnsHostnameTypeAsString() {
        return privateDnsHostnameType;
    }

    /**
     * <p>
     * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     * </p>
     * 
     * @return Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     */
    public final Boolean enableResourceNameDnsARecord() {
        return enableResourceNameDnsARecord;
    }

    /**
     * <p>
     * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     * </p>
     * 
     * @return Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     */
    public final Boolean enableResourceNameDnsAAAARecord() {
        return enableResourceNameDnsAAAARecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsHostnameTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsARecord());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsAAAARecord());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyPrivateDnsNameOptionsRequest)) {
            return false;
        }
        ModifyPrivateDnsNameOptionsRequest other = (ModifyPrivateDnsNameOptionsRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(privateDnsHostnameTypeAsString(), other.privateDnsHostnameTypeAsString())
                && Objects.equals(enableResourceNameDnsARecord(), other.enableResourceNameDnsARecord())
                && Objects.equals(enableResourceNameDnsAAAARecord(), other.enableResourceNameDnsAAAARecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyPrivateDnsNameOptionsRequest").add("DryRun", dryRun()).add("InstanceId", instanceId())
                .add("PrivateDnsHostnameType", privateDnsHostnameTypeAsString())
                .add("EnableResourceNameDnsARecord", enableResourceNameDnsARecord())
                .add("EnableResourceNameDnsAAAARecord", enableResourceNameDnsAAAARecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PrivateDnsHostnameType":
            return Optional.ofNullable(clazz.cast(privateDnsHostnameTypeAsString()));
        case "EnableResourceNameDnsARecord":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsARecord()));
        case "EnableResourceNameDnsAAAARecord":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsAAAARecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("PrivateDnsHostnameType", PRIVATE_DNS_HOSTNAME_TYPE_FIELD);
        map.put("EnableResourceNameDnsARecord", ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD);
        map.put("EnableResourceNameDnsAAAARecord", ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyPrivateDnsNameOptionsRequest, T> g) {
        return obj -> g.apply((ModifyPrivateDnsNameOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyPrivateDnsNameOptionsRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the
         * instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For
         * dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
         * </p>
         * 
         * @param privateDnsHostnameType
         *        The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on
         *        the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance
         *        ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the
         *        instance ID.
         * @see HostnameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostnameType
         */
        Builder privateDnsHostnameType(String privateDnsHostnameType);

        /**
         * <p>
         * The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the
         * instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For
         * dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
         * </p>
         * 
         * @param privateDnsHostnameType
         *        The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on
         *        the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance
         *        ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the
         *        instance ID.
         * @see HostnameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostnameType
         */
        Builder privateDnsHostnameType(HostnameType privateDnsHostnameType);

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * 
         * @param enableResourceNameDnsARecord
         *        Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord);

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * 
         * @param enableResourceNameDnsAAAARecord
         *        Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String instanceId;

        private String privateDnsHostnameType;

        private Boolean enableResourceNameDnsARecord;

        private Boolean enableResourceNameDnsAAAARecord;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyPrivateDnsNameOptionsRequest model) {
            super(model);
            dryRun(model.dryRun);
            instanceId(model.instanceId);
            privateDnsHostnameType(model.privateDnsHostnameType);
            enableResourceNameDnsARecord(model.enableResourceNameDnsARecord);
            enableResourceNameDnsAAAARecord(model.enableResourceNameDnsAAAARecord);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPrivateDnsHostnameType() {
            return privateDnsHostnameType;
        }

        public final void setPrivateDnsHostnameType(String privateDnsHostnameType) {
            this.privateDnsHostnameType = privateDnsHostnameType;
        }

        @Override
        public final Builder privateDnsHostnameType(String privateDnsHostnameType) {
            this.privateDnsHostnameType = privateDnsHostnameType;
            return this;
        }

        @Override
        public final Builder privateDnsHostnameType(HostnameType privateDnsHostnameType) {
            this.privateDnsHostnameType(privateDnsHostnameType == null ? null : privateDnsHostnameType.toString());
            return this;
        }

        public final Boolean getEnableResourceNameDnsARecord() {
            return enableResourceNameDnsARecord;
        }

        public final void setEnableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
        }

        @Override
        public final Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
            return this;
        }

        public final Boolean getEnableResourceNameDnsAAAARecord() {
            return enableResourceNameDnsAAAARecord;
        }

        public final void setEnableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
        }

        @Override
        public final Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyPrivateDnsNameOptionsRequest build() {
            return new ModifyPrivateDnsNameOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
