/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVolumeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVolumeRequest.Builder, ModifyVolumeRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyVolumeRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(ModifyVolumeRequest::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("VolumeId").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Size")
            .getter(getter(ModifyVolumeRequest::size))
            .setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size")
                    .unmarshallLocationName("Size").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeType")
            .getter(getter(ModifyVolumeRequest::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType")
                    .unmarshallLocationName("VolumeType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Iops")
            .getter(getter(ModifyVolumeRequest::iops))
            .setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops")
                    .unmarshallLocationName("Iops").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput")
            .getter(getter(ModifyVolumeRequest::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput")
                    .unmarshallLocationName("Throughput").build()).build();

    private static final SdkField<Boolean> MULTI_ATTACH_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAttachEnabled")
            .getter(getter(ModifyVolumeRequest::multiAttachEnabled))
            .setter(setter(Builder::multiAttachEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAttachEnabled")
                    .unmarshallLocationName("MultiAttachEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            VOLUME_ID_FIELD, SIZE_FIELD, VOLUME_TYPE_FIELD, IOPS_FIELD, THROUGHPUT_FIELD, MULTI_ATTACH_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String volumeId;

    private final Integer size;

    private final String volumeType;

    private final Integer iops;

    private final Integer throughput;

    private final Boolean multiAttachEnabled;

    private ModifyVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.volumeId = builder.volumeId;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.multiAttachEnabled = builder.multiAttachEnabled;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The target size of the volume, in GiB. The target volume size must be greater than or equal to the existing size
     * of the volume.
     * </p>
     * <p>
     * The following are the supported volumes sizes for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>: 4 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io2</code>: 4 - 65,536 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>standard</code>: 1 - 1024 GiB
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: The existing size is retained.
     * </p>
     * 
     * @return The target size of the volume, in GiB. The target volume size must be greater than or equal to the
     *         existing size of the volume.</p>
     *         <p>
     *         The following are the supported volumes sizes for each volume type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>: 4 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io2</code>: 4 - 65,536 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>standard</code>: 1 - 1024 GiB
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: The existing size is retained.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The target EBS volume type of the volume. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Default: The existing type is retained.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The target EBS volume type of the volume. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a>
     *         in the <i>Amazon EBS User Guide</i>.</p>
     *         <p>
     *         Default: The existing type is retained.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The target EBS volume type of the volume. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Default: The existing type is retained.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The target EBS volume type of the volume. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a>
     *         in the <i>Amazon EBS User Guide</i>.</p>
     *         <p>
     *         Default: The existing type is retained.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * The target IOPS rate of the volume. This parameter is valid only for <code>gp3</code>, <code>io1</code>, and
     * <code>io2</code> volumes.
     * </p>
     * <p>
     * The following are the supported values for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp3</code>: 3,000 - 16,000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>: 100 - 64,000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io2</code>: 100 - 256,000 IOPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
     * href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">instances built on the Nitro
     * System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
     * </p>
     * <p>
     * Default: The existing value is retained if you keep the same volume type. If you change the volume type to
     * <code>io1</code>, <code>io2</code>, or <code>gp3</code>, the default is 3,000.
     * </p>
     * 
     * @return The target IOPS rate of the volume. This parameter is valid only for <code>gp3</code>, <code>io1</code>,
     *         and <code>io2</code> volumes.</p>
     *         <p>
     *         The following are the supported values for each volume type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp3</code>: 3,000 - 16,000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>: 100 - 64,000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io2</code>: 100 - 256,000 IOPS
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
     *         href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">instances built on
     *         the Nitro System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
     *         </p>
     *         <p>
     *         Default: The existing value is retained if you keep the same volume type. If you change the volume type
     *         to <code>io1</code>, <code>io2</code>, or <code>gp3</code>, the default is 3,000.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The target throughput of the volume, in MiB/s. This parameter is valid only for <code>gp3</code> volumes. The
     * maximum value is 1,000.
     * </p>
     * <p>
     * Default: The existing value is retained if the source and target volume type is <code>gp3</code>. Otherwise, the
     * default value is 125.
     * </p>
     * <p>
     * Valid Range: Minimum value of 125. Maximum value of 1000.
     * </p>
     * 
     * @return The target throughput of the volume, in MiB/s. This parameter is valid only for <code>gp3</code> volumes.
     *         The maximum value is 1,000.</p>
     *         <p>
     *         Default: The existing value is retained if the source and target volume type is <code>gp3</code>.
     *         Otherwise, the default value is 125.
     *         </p>
     *         <p>
     *         Valid Range: Minimum value of 125. Maximum value of 1000.
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <p>
     * Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to up
     * to 16 <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Nitro-based
     * instances</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and
     * <code>io2</code> volumes only. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a> in
     * the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
     *         volume to up to 16 <a
     *         href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Nitro-based
     *         instances</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and
     *         <code>io2</code> volumes only. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS
     *         Multi-Attach</a> in the <i>Amazon EBS User Guide</i>.
     */
    public final Boolean multiAttachEnabled() {
        return multiAttachEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(multiAttachEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeRequest)) {
            return false;
        }
        ModifyVolumeRequest other = (ModifyVolumeRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(size(), other.size()) && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(iops(), other.iops()) && Objects.equals(throughput(), other.throughput())
                && Objects.equals(multiAttachEnabled(), other.multiAttachEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVolumeRequest").add("DryRun", dryRun()).add("VolumeId", volumeId()).add("Size", size())
                .add("VolumeType", volumeTypeAsString()).add("Iops", iops()).add("Throughput", throughput())
                .add("MultiAttachEnabled", multiAttachEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "MultiAttachEnabled":
            return Optional.ofNullable(clazz.cast(multiAttachEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("MultiAttachEnabled", MULTI_ATTACH_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVolumeRequest, T> g) {
        return obj -> g.apply((ModifyVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVolumeRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The target size of the volume, in GiB. The target volume size must be greater than or equal to the existing
         * size of the volume.
         * </p>
         * <p>
         * The following are the supported volumes sizes for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>: 4 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io2</code>: 4 - 65,536 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>standard</code>: 1 - 1024 GiB
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: The existing size is retained.
         * </p>
         * 
         * @param size
         *        The target size of the volume, in GiB. The target volume size must be greater than or equal to the
         *        existing size of the volume.</p>
         *        <p>
         *        The following are the supported volumes sizes for each volume type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>: 4 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io2</code>: 4 - 65,536 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>standard</code>: 1 - 1024 GiB
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: The existing size is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The target EBS volume type of the volume. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in
         * the <i>Amazon EBS User Guide</i>.
         * </p>
         * <p>
         * Default: The existing type is retained.
         * </p>
         * 
         * @param volumeType
         *        The target EBS volume type of the volume. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume
         *        types</a> in the <i>Amazon EBS User Guide</i>.</p>
         *        <p>
         *        Default: The existing type is retained.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The target EBS volume type of the volume. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in
         * the <i>Amazon EBS User Guide</i>.
         * </p>
         * <p>
         * Default: The existing type is retained.
         * </p>
         * 
         * @param volumeType
         *        The target EBS volume type of the volume. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume
         *        types</a> in the <i>Amazon EBS User Guide</i>.</p>
         *        <p>
         *        Default: The existing type is retained.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * The target IOPS rate of the volume. This parameter is valid only for <code>gp3</code>, <code>io1</code>, and
         * <code>io2</code> volumes.
         * </p>
         * <p>
         * The following are the supported values for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp3</code>: 3,000 - 16,000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>: 100 - 64,000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io2</code>: 100 - 256,000 IOPS
         * </p>
         * </li>
         * </ul>
         * <p>
         * For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
         * href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">instances built on the
         * Nitro System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
         * </p>
         * <p>
         * Default: The existing value is retained if you keep the same volume type. If you change the volume type to
         * <code>io1</code>, <code>io2</code>, or <code>gp3</code>, the default is 3,000.
         * </p>
         * 
         * @param iops
         *        The target IOPS rate of the volume. This parameter is valid only for <code>gp3</code>,
         *        <code>io1</code>, and <code>io2</code> volumes.</p>
         *        <p>
         *        The following are the supported values for each volume type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp3</code>: 3,000 - 16,000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>: 100 - 64,000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io2</code>: 100 - 256,000 IOPS
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
         *        href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">instances built
         *        on the Nitro System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
         *        </p>
         *        <p>
         *        Default: The existing value is retained if you keep the same volume type. If you change the volume
         *        type to <code>io1</code>, <code>io2</code>, or <code>gp3</code>, the default is 3,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The target throughput of the volume, in MiB/s. This parameter is valid only for <code>gp3</code> volumes. The
         * maximum value is 1,000.
         * </p>
         * <p>
         * Default: The existing value is retained if the source and target volume type is <code>gp3</code>. Otherwise,
         * the default value is 125.
         * </p>
         * <p>
         * Valid Range: Minimum value of 125. Maximum value of 1000.
         * </p>
         * 
         * @param throughput
         *        The target throughput of the volume, in MiB/s. This parameter is valid only for <code>gp3</code>
         *        volumes. The maximum value is 1,000.</p>
         *        <p>
         *        Default: The existing value is retained if the source and target volume type is <code>gp3</code>.
         *        Otherwise, the default value is 125.
         *        </p>
         *        <p>
         *        Valid Range: Minimum value of 125. Maximum value of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <p>
         * Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to
         * up to 16 <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Nitro-based
         * instances</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and
         * <code>io2</code> volumes only. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a>
         * in the <i>Amazon EBS User Guide</i>.
         * </p>
         * 
         * @param multiAttachEnabled
         *        Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
         *        volume to up to 16 <a
         *        href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Nitro-based
         *        instances</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and
         *        <code>io2</code> volumes only. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS
         *        Multi-Attach</a> in the <i>Amazon EBS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAttachEnabled(Boolean multiAttachEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String volumeId;

        private Integer size;

        private String volumeType;

        private Integer iops;

        private Integer throughput;

        private Boolean multiAttachEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeRequest model) {
            super(model);
            dryRun(model.dryRun);
            volumeId(model.volumeId);
            size(model.size);
            volumeType(model.volumeType);
            iops(model.iops);
            throughput(model.throughput);
            multiAttachEnabled(model.multiAttachEnabled);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final Boolean getMultiAttachEnabled() {
            return multiAttachEnabled;
        }

        public final void setMultiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
        }

        @Override
        public final Builder multiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVolumeRequest build() {
            return new ModifyVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
