/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreManagedPrefixListVersionRequest extends Ec2Request implements
        ToCopyableBuilder<RestoreManagedPrefixListVersionRequest.Builder, RestoreManagedPrefixListVersionRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(RestoreManagedPrefixListVersionRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(RestoreManagedPrefixListVersionRequest::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("PrefixListId").build()).build();

    private static final SdkField<Long> PREVIOUS_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PreviousVersion")
            .getter(getter(RestoreManagedPrefixListVersionRequest::previousVersion))
            .setter(setter(Builder::previousVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousVersion")
                    .unmarshallLocationName("PreviousVersion").build()).build();

    private static final SdkField<Long> CURRENT_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentVersion")
            .getter(getter(RestoreManagedPrefixListVersionRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion")
                    .unmarshallLocationName("CurrentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            PREFIX_LIST_ID_FIELD, PREVIOUS_VERSION_FIELD, CURRENT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String prefixListId;

    private final Long previousVersion;

    private final Long currentVersion;

    private RestoreManagedPrefixListVersionRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.prefixListId = builder.prefixListId;
        this.previousVersion = builder.previousVersion;
        this.currentVersion = builder.currentVersion;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The version to restore.
     * </p>
     * 
     * @return The version to restore.
     */
    public final Long previousVersion() {
        return previousVersion;
    }

    /**
     * <p>
     * The current version number for the prefix list.
     * </p>
     * 
     * @return The current version number for the prefix list.
     */
    public final Long currentVersion() {
        return currentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(previousVersion());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreManagedPrefixListVersionRequest)) {
            return false;
        }
        RestoreManagedPrefixListVersionRequest other = (RestoreManagedPrefixListVersionRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(previousVersion(), other.previousVersion())
                && Objects.equals(currentVersion(), other.currentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreManagedPrefixListVersionRequest").add("DryRun", dryRun())
                .add("PrefixListId", prefixListId()).add("PreviousVersion", previousVersion())
                .add("CurrentVersion", currentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "PreviousVersion":
            return Optional.ofNullable(clazz.cast(previousVersion()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("PreviousVersion", PREVIOUS_VERSION_FIELD);
        map.put("CurrentVersion", CURRENT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreManagedPrefixListVersionRequest, T> g) {
        return obj -> g.apply((RestoreManagedPrefixListVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreManagedPrefixListVersionRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The version to restore.
         * </p>
         * 
         * @param previousVersion
         *        The version to restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousVersion(Long previousVersion);

        /**
         * <p>
         * The current version number for the prefix list.
         * </p>
         * 
         * @param currentVersion
         *        The current version number for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(Long currentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String prefixListId;

        private Long previousVersion;

        private Long currentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreManagedPrefixListVersionRequest model) {
            super(model);
            dryRun(model.dryRun);
            prefixListId(model.prefixListId);
            previousVersion(model.previousVersion);
            currentVersion(model.currentVersion);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final Long getPreviousVersion() {
            return previousVersion;
        }

        public final void setPreviousVersion(Long previousVersion) {
            this.previousVersion = previousVersion;
        }

        @Override
        public final Builder previousVersion(Long previousVersion) {
            this.previousVersion = previousVersion;
            return this;
        }

        public final Long getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreManagedPrefixListVersionRequest build() {
            return new RestoreManagedPrefixListVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
