/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequestStatus;
import software.amazon.awssdk.services.ec2.model.CapacityReservationInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservationBillingRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservationBillingRequest> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(CapacityReservationBillingRequest.getter(CapacityReservationBillingRequest::capacityReservationId)).setter(CapacityReservationBillingRequest.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("capacityReservationId").build()}).build();
    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestedBy").getter(CapacityReservationBillingRequest.getter(CapacityReservationBillingRequest::requestedBy)).setter(CapacityReservationBillingRequest.setter(Builder::requestedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedBy").unmarshallLocationName("requestedBy").build()}).build();
    private static final SdkField<String> UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnusedReservationBillingOwnerId").getter(CapacityReservationBillingRequest.getter(CapacityReservationBillingRequest::unusedReservationBillingOwnerId)).setter(CapacityReservationBillingRequest.setter(Builder::unusedReservationBillingOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedReservationBillingOwnerId").unmarshallLocationName("unusedReservationBillingOwnerId").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(CapacityReservationBillingRequest.getter(CapacityReservationBillingRequest::lastUpdateTime)).setter(CapacityReservationBillingRequest.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").unmarshallLocationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CapacityReservationBillingRequest.getter(CapacityReservationBillingRequest::statusAsString)).setter(CapacityReservationBillingRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(CapacityReservationBillingRequest.getter(CapacityReservationBillingRequest::statusMessage)).setter(CapacityReservationBillingRequest.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<CapacityReservationInfo> CAPACITY_RESERVATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationInfo").getter(CapacityReservationBillingRequest.getter(CapacityReservationBillingRequest::capacityReservationInfo)).setter(CapacityReservationBillingRequest.setter(Builder::capacityReservationInfo)).constructor(CapacityReservationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationInfo").unmarshallLocationName("capacityReservationInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD, REQUESTED_BY_FIELD, UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CAPACITY_RESERVATION_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityReservationBillingRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityReservationId;
    private final String requestedBy;
    private final String unusedReservationBillingOwnerId;
    private final Instant lastUpdateTime;
    private final String status;
    private final String statusMessage;
    private final CapacityReservationInfo capacityReservationInfo;

    private CapacityReservationBillingRequest(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.requestedBy = builder.requestedBy;
        this.unusedReservationBillingOwnerId = builder.unusedReservationBillingOwnerId;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.capacityReservationInfo = builder.capacityReservationInfo;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final String requestedBy() {
        return this.requestedBy;
    }

    public final String unusedReservationBillingOwnerId() {
        return this.unusedReservationBillingOwnerId;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final CapacityReservationBillingRequestStatus status() {
        return CapacityReservationBillingRequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final CapacityReservationInfo capacityReservationInfo() {
        return this.capacityReservationInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedReservationBillingOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationBillingRequest)) {
            return false;
        }
        CapacityReservationBillingRequest other = (CapacityReservationBillingRequest)obj;
        return Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.requestedBy(), other.requestedBy()) && Objects.equals(this.unusedReservationBillingOwnerId(), other.unusedReservationBillingOwnerId()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.capacityReservationInfo(), other.capacityReservationInfo());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservationBillingRequest").add("CapacityReservationId", (Object)this.capacityReservationId()).add("RequestedBy", (Object)this.requestedBy()).add("UnusedReservationBillingOwnerId", (Object)this.unusedReservationBillingOwnerId()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CapacityReservationInfo", (Object)this.capacityReservationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "RequestedBy": {
                return Optional.ofNullable(clazz.cast(this.requestedBy()));
            }
            case "UnusedReservationBillingOwnerId": {
                return Optional.ofNullable(clazz.cast(this.unusedReservationBillingOwnerId()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CapacityReservationInfo": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("RequestedBy", REQUESTED_BY_FIELD);
        map.put("UnusedReservationBillingOwnerId", UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CapacityReservationInfo", CAPACITY_RESERVATION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationBillingRequest, T> g) {
        return obj -> g.apply((CapacityReservationBillingRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationId;
        private String requestedBy;
        private String unusedReservationBillingOwnerId;
        private Instant lastUpdateTime;
        private String status;
        private String statusMessage;
        private CapacityReservationInfo capacityReservationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationBillingRequest model) {
            this.capacityReservationId(model.capacityReservationId);
            this.requestedBy(model.requestedBy);
            this.unusedReservationBillingOwnerId(model.unusedReservationBillingOwnerId);
            this.lastUpdateTime(model.lastUpdateTime);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.capacityReservationInfo(model.capacityReservationInfo);
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final String getRequestedBy() {
            return this.requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final String getUnusedReservationBillingOwnerId() {
            return this.unusedReservationBillingOwnerId;
        }

        public final void setUnusedReservationBillingOwnerId(String unusedReservationBillingOwnerId) {
            this.unusedReservationBillingOwnerId = unusedReservationBillingOwnerId;
        }

        @Override
        public final Builder unusedReservationBillingOwnerId(String unusedReservationBillingOwnerId) {
            this.unusedReservationBillingOwnerId = unusedReservationBillingOwnerId;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityReservationBillingRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final CapacityReservationInfo.Builder getCapacityReservationInfo() {
            return this.capacityReservationInfo != null ? this.capacityReservationInfo.toBuilder() : null;
        }

        public final void setCapacityReservationInfo(CapacityReservationInfo.BuilderImpl capacityReservationInfo) {
            this.capacityReservationInfo = capacityReservationInfo != null ? capacityReservationInfo.build() : null;
        }

        @Override
        public final Builder capacityReservationInfo(CapacityReservationInfo capacityReservationInfo) {
            this.capacityReservationInfo = capacityReservationInfo;
            return this;
        }

        public CapacityReservationBillingRequest build() {
            return new CapacityReservationBillingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservationBillingRequest> {
        public Builder capacityReservationId(String var1);

        public Builder requestedBy(String var1);

        public Builder unusedReservationBillingOwnerId(String var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(CapacityReservationBillingRequestStatus var1);

        public Builder statusMessage(String var1);

        public Builder capacityReservationInfo(CapacityReservationInfo var1);

        default public Builder capacityReservationInfo(Consumer<CapacityReservationInfo.Builder> capacityReservationInfo) {
            return this.capacityReservationInfo((CapacityReservationInfo)((CapacityReservationInfo.Builder)CapacityReservationInfo.builder().applyMutation(capacityReservationInfo)).build());
        }
    }
}

