/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysisIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInsightsAccessScopeAnalysesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeNetworkInsightsAccessScopeAnalysesRequest> {
    private static final SdkField<List<String>> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInsightsAccessScopeAnalysisIds").getter(DescribeNetworkInsightsAccessScopeAnalysesRequest.getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::networkInsightsAccessScopeAnalysisIds)).setter(DescribeNetworkInsightsAccessScopeAnalysesRequest.setter(Builder::networkInsightsAccessScopeAnalysisIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeAnalysisId").unmarshallLocationName("NetworkInsightsAccessScopeAnalysisId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeId").getter(DescribeNetworkInsightsAccessScopeAnalysesRequest.getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::networkInsightsAccessScopeId)).setter(DescribeNetworkInsightsAccessScopeAnalysesRequest.setter(Builder::networkInsightsAccessScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId").unmarshallLocationName("NetworkInsightsAccessScopeId").build()}).build();
    private static final SdkField<Instant> ANALYSIS_START_TIME_BEGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AnalysisStartTimeBegin").getter(DescribeNetworkInsightsAccessScopeAnalysesRequest.getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::analysisStartTimeBegin)).setter(DescribeNetworkInsightsAccessScopeAnalysesRequest.setter(Builder::analysisStartTimeBegin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartTimeBegin").unmarshallLocationName("AnalysisStartTimeBegin").build()}).build();
    private static final SdkField<Instant> ANALYSIS_START_TIME_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AnalysisStartTimeEnd").getter(DescribeNetworkInsightsAccessScopeAnalysesRequest.getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::analysisStartTimeEnd)).setter(DescribeNetworkInsightsAccessScopeAnalysesRequest.setter(Builder::analysisStartTimeEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartTimeEnd").unmarshallLocationName("AnalysisStartTimeEnd").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeNetworkInsightsAccessScopeAnalysesRequest.getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::filters)).setter(DescribeNetworkInsightsAccessScopeAnalysesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeNetworkInsightsAccessScopeAnalysesRequest.getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::maxResults)).setter(DescribeNetworkInsightsAccessScopeAnalysesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeNetworkInsightsAccessScopeAnalysesRequest.getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::dryRun)).setter(DescribeNetworkInsightsAccessScopeAnalysesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNetworkInsightsAccessScopeAnalysesRequest.getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::nextToken)).setter(DescribeNetworkInsightsAccessScopeAnalysesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_IDS_FIELD, NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD, ANALYSIS_START_TIME_BEGIN_FIELD, ANALYSIS_START_TIME_END_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, DRY_RUN_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeNetworkInsightsAccessScopeAnalysesRequest.memberNameToFieldInitializer();
    private final List<String> networkInsightsAccessScopeAnalysisIds;
    private final String networkInsightsAccessScopeId;
    private final Instant analysisStartTimeBegin;
    private final Instant analysisStartTimeEnd;
    private final List<Filter> filters;
    private final Integer maxResults;
    private final Boolean dryRun;
    private final String nextToken;

    private DescribeNetworkInsightsAccessScopeAnalysesRequest(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAccessScopeAnalysisIds = builder.networkInsightsAccessScopeAnalysisIds;
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.analysisStartTimeBegin = builder.analysisStartTimeBegin;
        this.analysisStartTimeEnd = builder.analysisStartTimeEnd;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.dryRun = builder.dryRun;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkInsightsAccessScopeAnalysisIds() {
        return this.networkInsightsAccessScopeAnalysisIds != null && !(this.networkInsightsAccessScopeAnalysisIds instanceof SdkAutoConstructList);
    }

    public final List<String> networkInsightsAccessScopeAnalysisIds() {
        return this.networkInsightsAccessScopeAnalysisIds;
    }

    public final String networkInsightsAccessScopeId() {
        return this.networkInsightsAccessScopeId;
    }

    public final Instant analysisStartTimeBegin() {
        return this.analysisStartTimeBegin;
    }

    public final Instant analysisStartTimeEnd() {
        return this.analysisStartTimeEnd;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInsightsAccessScopeAnalysisIds() ? this.networkInsightsAccessScopeAnalysisIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStartTimeBegin());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStartTimeEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInsightsAccessScopeAnalysesRequest)) {
            return false;
        }
        DescribeNetworkInsightsAccessScopeAnalysesRequest other = (DescribeNetworkInsightsAccessScopeAnalysesRequest)((Object)obj);
        return this.hasNetworkInsightsAccessScopeAnalysisIds() == other.hasNetworkInsightsAccessScopeAnalysisIds() && Objects.equals(this.networkInsightsAccessScopeAnalysisIds(), other.networkInsightsAccessScopeAnalysisIds()) && Objects.equals(this.networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId()) && Objects.equals(this.analysisStartTimeBegin(), other.analysisStartTimeBegin()) && Objects.equals(this.analysisStartTimeEnd(), other.analysisStartTimeEnd()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNetworkInsightsAccessScopeAnalysesRequest").add("NetworkInsightsAccessScopeAnalysisIds", this.hasNetworkInsightsAccessScopeAnalysisIds() ? this.networkInsightsAccessScopeAnalysisIds() : null).add("NetworkInsightsAccessScopeId", (Object)this.networkInsightsAccessScopeId()).add("AnalysisStartTimeBegin", (Object)this.analysisStartTimeBegin()).add("AnalysisStartTimeEnd", (Object)this.analysisStartTimeEnd()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("DryRun", (Object)this.dryRun()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAccessScopeAnalysisIds": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeAnalysisIds()));
            }
            case "NetworkInsightsAccessScopeId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeId()));
            }
            case "AnalysisStartTimeBegin": {
                return Optional.ofNullable(clazz.cast(this.analysisStartTimeBegin()));
            }
            case "AnalysisStartTimeEnd": {
                return Optional.ofNullable(clazz.cast(this.analysisStartTimeEnd()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkInsightsAccessScopeAnalysisId", NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_IDS_FIELD);
        map.put("NetworkInsightsAccessScopeId", NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD);
        map.put("AnalysisStartTimeBegin", ANALYSIS_START_TIME_BEGIN_FIELD);
        map.put("AnalysisStartTimeEnd", ANALYSIS_START_TIME_END_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInsightsAccessScopeAnalysesRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInsightsAccessScopeAnalysesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> networkInsightsAccessScopeAnalysisIds = DefaultSdkAutoConstructList.getInstance();
        private String networkInsightsAccessScopeId;
        private Instant analysisStartTimeBegin;
        private Instant analysisStartTimeEnd;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private Boolean dryRun;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInsightsAccessScopeAnalysesRequest model) {
            super(model);
            this.networkInsightsAccessScopeAnalysisIds(model.networkInsightsAccessScopeAnalysisIds);
            this.networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            this.analysisStartTimeBegin(model.analysisStartTimeBegin);
            this.analysisStartTimeEnd(model.analysisStartTimeEnd);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.dryRun(model.dryRun);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getNetworkInsightsAccessScopeAnalysisIds() {
            if (this.networkInsightsAccessScopeAnalysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInsightsAccessScopeAnalysisIds;
        }

        public final void setNetworkInsightsAccessScopeAnalysisIds(Collection<String> networkInsightsAccessScopeAnalysisIds) {
            this.networkInsightsAccessScopeAnalysisIds = NetworkInsightsAccessScopeAnalysisIdListCopier.copy(networkInsightsAccessScopeAnalysisIds);
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisIds(Collection<String> networkInsightsAccessScopeAnalysisIds) {
            this.networkInsightsAccessScopeAnalysisIds = NetworkInsightsAccessScopeAnalysisIdListCopier.copy(networkInsightsAccessScopeAnalysisIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInsightsAccessScopeAnalysisIds(String ... networkInsightsAccessScopeAnalysisIds) {
            this.networkInsightsAccessScopeAnalysisIds(Arrays.asList(networkInsightsAccessScopeAnalysisIds));
            return this;
        }

        public final String getNetworkInsightsAccessScopeId() {
            return this.networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final Instant getAnalysisStartTimeBegin() {
            return this.analysisStartTimeBegin;
        }

        public final void setAnalysisStartTimeBegin(Instant analysisStartTimeBegin) {
            this.analysisStartTimeBegin = analysisStartTimeBegin;
        }

        @Override
        public final Builder analysisStartTimeBegin(Instant analysisStartTimeBegin) {
            this.analysisStartTimeBegin = analysisStartTimeBegin;
            return this;
        }

        public final Instant getAnalysisStartTimeEnd() {
            return this.analysisStartTimeEnd;
        }

        public final void setAnalysisStartTimeEnd(Instant analysisStartTimeEnd) {
            this.analysisStartTimeEnd = analysisStartTimeEnd;
        }

        @Override
        public final Builder analysisStartTimeEnd(Instant analysisStartTimeEnd) {
            this.analysisStartTimeEnd = analysisStartTimeEnd;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInsightsAccessScopeAnalysesRequest build() {
            return new DescribeNetworkInsightsAccessScopeAnalysesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInsightsAccessScopeAnalysesRequest> {
        public Builder networkInsightsAccessScopeAnalysisIds(Collection<String> var1);

        public Builder networkInsightsAccessScopeAnalysisIds(String ... var1);

        public Builder networkInsightsAccessScopeId(String var1);

        public Builder analysisStartTimeBegin(Instant var1);

        public Builder analysisStartTimeEnd(Instant var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

