/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.NitroTpmSupportedVersionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NitroTpmInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NitroTpmInfo> {
    private static final SdkField<List<String>> SUPPORTED_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedVersions").getter(NitroTpmInfo.getter(NitroTpmInfo::supportedVersions)).setter(NitroTpmInfo.setter(Builder::supportedVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedVersions").unmarshallLocationName("supportedVersions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NitroTpmInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> supportedVersions;

    private NitroTpmInfo(BuilderImpl builder) {
        this.supportedVersions = builder.supportedVersions;
    }

    public final boolean hasSupportedVersions() {
        return this.supportedVersions != null && !(this.supportedVersions instanceof SdkAutoConstructList);
    }

    public final List<String> supportedVersions() {
        return this.supportedVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedVersions() ? this.supportedVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NitroTpmInfo)) {
            return false;
        }
        NitroTpmInfo other = (NitroTpmInfo)obj;
        return this.hasSupportedVersions() == other.hasSupportedVersions() && Objects.equals(this.supportedVersions(), other.supportedVersions());
    }

    public final String toString() {
        return ToString.builder((String)"NitroTpmInfo").add("SupportedVersions", this.hasSupportedVersions() ? this.supportedVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportedVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("SupportedVersions", SUPPORTED_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NitroTpmInfo, T> g) {
        return obj -> g.apply((NitroTpmInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NitroTpmInfo model) {
            this.supportedVersions(model.supportedVersions);
        }

        public final Collection<String> getSupportedVersions() {
            if (this.supportedVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedVersions;
        }

        public final void setSupportedVersions(Collection<String> supportedVersions) {
            this.supportedVersions = NitroTpmSupportedVersionsListCopier.copy(supportedVersions);
        }

        @Override
        public final Builder supportedVersions(Collection<String> supportedVersions) {
            this.supportedVersions = NitroTpmSupportedVersionsListCopier.copy(supportedVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedVersions(String ... supportedVersions) {
            this.supportedVersions(Arrays.asList(supportedVersions));
            return this;
        }

        public NitroTpmInfo build() {
            return new NitroTpmInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NitroTpmInfo> {
        public Builder supportedVersions(Collection<String> var1);

        public Builder supportedVersions(String ... var1);
    }
}

