/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateNatGatewayAddressResponse extends Ec2Response implements
        ToCopyableBuilder<DisassociateNatGatewayAddressResponse.Builder, DisassociateNatGatewayAddressResponse> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId")
            .getter(getter(DisassociateNatGatewayAddressResponse::natGatewayId))
            .setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId")
                    .unmarshallLocationName("natGatewayId").build()).build();

    private static final SdkField<List<NatGatewayAddress>> NAT_GATEWAY_ADDRESSES_FIELD = SdkField
            .<List<NatGatewayAddress>> builder(MarshallingType.LIST)
            .memberName("NatGatewayAddresses")
            .getter(getter(DisassociateNatGatewayAddressResponse::natGatewayAddresses))
            .setter(setter(Builder::natGatewayAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayAddressSet")
                    .unmarshallLocationName("natGatewayAddressSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NatGatewayAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(NatGatewayAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD,
            NAT_GATEWAY_ADDRESSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String natGatewayId;

    private final List<NatGatewayAddress> natGatewayAddresses;

    private DisassociateNatGatewayAddressResponse(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.natGatewayAddresses = builder.natGatewayAddresses;
    }

    /**
     * <p>
     * The ID of the NAT gateway.
     * </p>
     * 
     * @return The ID of the NAT gateway.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NatGatewayAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNatGatewayAddresses() {
        return natGatewayAddresses != null && !(natGatewayAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the NAT gateway IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNatGatewayAddresses} method.
     * </p>
     * 
     * @return Information about the NAT gateway IP addresses.
     */
    public final List<NatGatewayAddress> natGatewayAddresses() {
        return natGatewayAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNatGatewayAddresses() ? natGatewayAddresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateNatGatewayAddressResponse)) {
            return false;
        }
        DisassociateNatGatewayAddressResponse other = (DisassociateNatGatewayAddressResponse) obj;
        return Objects.equals(natGatewayId(), other.natGatewayId()) && hasNatGatewayAddresses() == other.hasNatGatewayAddresses()
                && Objects.equals(natGatewayAddresses(), other.natGatewayAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateNatGatewayAddressResponse").add("NatGatewayId", natGatewayId())
                .add("NatGatewayAddresses", hasNatGatewayAddresses() ? natGatewayAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "NatGatewayAddresses":
            return Optional.ofNullable(clazz.cast(natGatewayAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("NatGatewayAddressSet", NAT_GATEWAY_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateNatGatewayAddressResponse, T> g) {
        return obj -> g.apply((DisassociateNatGatewayAddressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateNatGatewayAddressResponse> {
        /**
         * <p>
         * The ID of the NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * Information about the NAT gateway IP addresses.
         * </p>
         * 
         * @param natGatewayAddresses
         *        Information about the NAT gateway IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses);

        /**
         * <p>
         * Information about the NAT gateway IP addresses.
         * </p>
         * 
         * @param natGatewayAddresses
         *        Information about the NAT gateway IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayAddresses(NatGatewayAddress... natGatewayAddresses);

        /**
         * <p>
         * Information about the NAT gateway IP addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.NatGatewayAddress.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.NatGatewayAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.NatGatewayAddress.Builder#build()} is called immediately and
         * its result is passed to {@link #natGatewayAddresses(List<NatGatewayAddress>)}.
         * 
         * @param natGatewayAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.NatGatewayAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #natGatewayAddresses(java.util.Collection<NatGatewayAddress>)
         */
        Builder natGatewayAddresses(Consumer<NatGatewayAddress.Builder>... natGatewayAddresses);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String natGatewayId;

        private List<NatGatewayAddress> natGatewayAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateNatGatewayAddressResponse model) {
            super(model);
            natGatewayId(model.natGatewayId);
            natGatewayAddresses(model.natGatewayAddresses);
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final List<NatGatewayAddress.Builder> getNatGatewayAddresses() {
            List<NatGatewayAddress.Builder> result = NatGatewayAddressListCopier.copyToBuilder(this.natGatewayAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNatGatewayAddresses(Collection<NatGatewayAddress.BuilderImpl> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copyFromBuilder(natGatewayAddresses);
        }

        @Override
        public final Builder natGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copy(natGatewayAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(NatGatewayAddress... natGatewayAddresses) {
            natGatewayAddresses(Arrays.asList(natGatewayAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(Consumer<NatGatewayAddress.Builder>... natGatewayAddresses) {
            natGatewayAddresses(Stream.of(natGatewayAddresses).map(c -> NatGatewayAddress.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DisassociateNatGatewayAddressResponse build() {
            return new DisassociateNatGatewayAddressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
