/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCoipPoolUsageResponse extends Ec2Response implements
        ToCopyableBuilder<GetCoipPoolUsageResponse.Builder, GetCoipPoolUsageResponse> {
    private static final SdkField<String> COIP_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CoipPoolId")
            .getter(getter(GetCoipPoolUsageResponse::coipPoolId))
            .setter(setter(Builder::coipPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipPoolId")
                    .unmarshallLocationName("coipPoolId").build()).build();

    private static final SdkField<List<CoipAddressUsage>> COIP_ADDRESS_USAGES_FIELD = SdkField
            .<List<CoipAddressUsage>> builder(MarshallingType.LIST)
            .memberName("CoipAddressUsages")
            .getter(getter(GetCoipPoolUsageResponse::coipAddressUsages))
            .setter(setter(Builder::coipAddressUsages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipAddressUsageSet")
                    .unmarshallLocationName("coipAddressUsageSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CoipAddressUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoipAddressUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableId")
            .getter(getter(GetCoipPoolUsageResponse::localGatewayRouteTableId))
            .setter(setter(Builder::localGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId")
                    .unmarshallLocationName("localGatewayRouteTableId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetCoipPoolUsageResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COIP_POOL_ID_FIELD,
            COIP_ADDRESS_USAGES_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String coipPoolId;

    private final List<CoipAddressUsage> coipAddressUsages;

    private final String localGatewayRouteTableId;

    private final String nextToken;

    private GetCoipPoolUsageResponse(BuilderImpl builder) {
        super(builder);
        this.coipPoolId = builder.coipPoolId;
        this.coipAddressUsages = builder.coipAddressUsages;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the customer-owned address pool.
     * </p>
     * 
     * @return The ID of the customer-owned address pool.
     */
    public final String coipPoolId() {
        return coipPoolId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CoipAddressUsages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCoipAddressUsages() {
        return coipAddressUsages != null && !(coipAddressUsages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the address usage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCoipAddressUsages} method.
     * </p>
     * 
     * @return Information about the address usage.
     */
    public final List<CoipAddressUsage> coipAddressUsages() {
        return coipAddressUsages;
    }

    /**
     * <p>
     * The ID of the local gateway route table.
     * </p>
     * 
     * @return The ID of the local gateway route table.
     */
    public final String localGatewayRouteTableId() {
        return localGatewayRouteTableId;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coipPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCoipAddressUsages() ? coipAddressUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoipPoolUsageResponse)) {
            return false;
        }
        GetCoipPoolUsageResponse other = (GetCoipPoolUsageResponse) obj;
        return Objects.equals(coipPoolId(), other.coipPoolId()) && hasCoipAddressUsages() == other.hasCoipAddressUsages()
                && Objects.equals(coipAddressUsages(), other.coipAddressUsages())
                && Objects.equals(localGatewayRouteTableId(), other.localGatewayRouteTableId())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCoipPoolUsageResponse").add("CoipPoolId", coipPoolId())
                .add("CoipAddressUsages", hasCoipAddressUsages() ? coipAddressUsages() : null)
                .add("LocalGatewayRouteTableId", localGatewayRouteTableId()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoipPoolId":
            return Optional.ofNullable(clazz.cast(coipPoolId()));
        case "CoipAddressUsages":
            return Optional.ofNullable(clazz.cast(coipAddressUsages()));
        case "LocalGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoipPoolId", COIP_POOL_ID_FIELD);
        map.put("CoipAddressUsageSet", COIP_ADDRESS_USAGES_FIELD);
        map.put("LocalGatewayRouteTableId", LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCoipPoolUsageResponse, T> g) {
        return obj -> g.apply((GetCoipPoolUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetCoipPoolUsageResponse> {
        /**
         * <p>
         * The ID of the customer-owned address pool.
         * </p>
         * 
         * @param coipPoolId
         *        The ID of the customer-owned address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipPoolId(String coipPoolId);

        /**
         * <p>
         * Information about the address usage.
         * </p>
         * 
         * @param coipAddressUsages
         *        Information about the address usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipAddressUsages(Collection<CoipAddressUsage> coipAddressUsages);

        /**
         * <p>
         * Information about the address usage.
         * </p>
         * 
         * @param coipAddressUsages
         *        Information about the address usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipAddressUsages(CoipAddressUsage... coipAddressUsages);

        /**
         * <p>
         * Information about the address usage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CoipAddressUsage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.CoipAddressUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CoipAddressUsage.Builder#build()} is called immediately and
         * its result is passed to {@link #coipAddressUsages(List<CoipAddressUsage>)}.
         * 
         * @param coipAddressUsages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CoipAddressUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coipAddressUsages(java.util.Collection<CoipAddressUsage>)
         */
        Builder coipAddressUsages(Consumer<CoipAddressUsage.Builder>... coipAddressUsages);

        /**
         * <p>
         * The ID of the local gateway route table.
         * </p>
         * 
         * @param localGatewayRouteTableId
         *        The ID of the local gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableId(String localGatewayRouteTableId);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String coipPoolId;

        private List<CoipAddressUsage> coipAddressUsages = DefaultSdkAutoConstructList.getInstance();

        private String localGatewayRouteTableId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoipPoolUsageResponse model) {
            super(model);
            coipPoolId(model.coipPoolId);
            coipAddressUsages(model.coipAddressUsages);
            localGatewayRouteTableId(model.localGatewayRouteTableId);
            nextToken(model.nextToken);
        }

        public final String getCoipPoolId() {
            return coipPoolId;
        }

        public final void setCoipPoolId(String coipPoolId) {
            this.coipPoolId = coipPoolId;
        }

        @Override
        public final Builder coipPoolId(String coipPoolId) {
            this.coipPoolId = coipPoolId;
            return this;
        }

        public final List<CoipAddressUsage.Builder> getCoipAddressUsages() {
            List<CoipAddressUsage.Builder> result = CoipAddressUsageSetCopier.copyToBuilder(this.coipAddressUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoipAddressUsages(Collection<CoipAddressUsage.BuilderImpl> coipAddressUsages) {
            this.coipAddressUsages = CoipAddressUsageSetCopier.copyFromBuilder(coipAddressUsages);
        }

        @Override
        public final Builder coipAddressUsages(Collection<CoipAddressUsage> coipAddressUsages) {
            this.coipAddressUsages = CoipAddressUsageSetCopier.copy(coipAddressUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipAddressUsages(CoipAddressUsage... coipAddressUsages) {
            coipAddressUsages(Arrays.asList(coipAddressUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipAddressUsages(Consumer<CoipAddressUsage.Builder>... coipAddressUsages) {
            coipAddressUsages(Stream.of(coipAddressUsages).map(c -> CoipAddressUsage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCoipPoolUsageResponse build() {
            return new GetCoipPoolUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
