/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifySpotFleetRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySpotFleetRequestRequest extends Ec2Request implements
        ToCopyableBuilder<ModifySpotFleetRequestRequest.Builder, ModifySpotFleetRequestRequest> {
    private static final SdkField<List<LaunchTemplateConfig>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField
            .<List<LaunchTemplateConfig>> builder(MarshallingType.LIST)
            .memberName("LaunchTemplateConfigs")
            .getter(getter(ModifySpotFleetRequestRequest::launchTemplateConfigs))
            .setter(setter(Builder::launchTemplateConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfig")
                    .unmarshallLocationName("LaunchTemplateConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandTargetCapacity")
            .getter(getter(ModifySpotFleetRequestRequest::onDemandTargetCapacity))
            .setter(setter(Builder::onDemandTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity")
                    .unmarshallLocationName("OnDemandTargetCapacity").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Context")
            .getter(getter(ModifySpotFleetRequestRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context")
                    .unmarshallLocationName("Context").build()).build();

    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotFleetRequestId")
            .getter(getter(ModifySpotFleetRequestRequest::spotFleetRequestId))
            .setter(setter(Builder::spotFleetRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build()).build();

    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetCapacity")
            .getter(getter(ModifySpotFleetRequestRequest::targetCapacity))
            .setter(setter(Builder::targetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacity")
                    .unmarshallLocationName("targetCapacity").build()).build();

    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExcessCapacityTerminationPolicy")
            .getter(getter(ModifySpotFleetRequestRequest::excessCapacityTerminationPolicyAsString))
            .setter(setter(Builder::excessCapacityTerminationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy")
                    .unmarshallLocationName("excessCapacityTerminationPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_CONFIGS_FIELD,
            ON_DEMAND_TARGET_CAPACITY_FIELD, CONTEXT_FIELD, SPOT_FLEET_REQUEST_ID_FIELD, TARGET_CAPACITY_FIELD,
            EXCESS_CAPACITY_TERMINATION_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LaunchTemplateConfig> launchTemplateConfigs;

    private final Integer onDemandTargetCapacity;

    private final String context;

    private final String spotFleetRequestId;

    private final Integer targetCapacity;

    private final String excessCapacityTerminationPolicy;

    private ModifySpotFleetRequestRequest(BuilderImpl builder) {
        super(builder);
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
        this.context = builder.context;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.targetCapacity = builder.targetCapacity;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the LaunchTemplateConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLaunchTemplateConfigs() {
        return launchTemplateConfigs != null && !(launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The launch template and overrides. You can only use this parameter if you specified a launch template (
     * <code>LaunchTemplateConfigs</code>) in your Spot Fleet request. If you specified
     * <code>LaunchSpecifications</code> in your Spot Fleet request, then omit this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLaunchTemplateConfigs} method.
     * </p>
     * 
     * @return The launch template and overrides. You can only use this parameter if you specified a launch template (
     *         <code>LaunchTemplateConfigs</code>) in your Spot Fleet request. If you specified
     *         <code>LaunchSpecifications</code> in your Spot Fleet request, then omit this parameter.
     */
    public final List<LaunchTemplateConfig> launchTemplateConfigs() {
        return launchTemplateConfigs;
    }

    /**
     * <p>
     * The number of On-Demand Instances in the fleet.
     * </p>
     * 
     * @return The number of On-Demand Instances in the fleet.
     */
    public final Integer onDemandTargetCapacity() {
        return onDemandTargetCapacity;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * The ID of the Spot Fleet request.
     * </p>
     * 
     * @return The ID of the Spot Fleet request.
     */
    public final String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    /**
     * <p>
     * The size of the fleet.
     * </p>
     * 
     * @return The size of the fleet.
     */
    public final Integer targetCapacity() {
        return targetCapacity;
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the target capacity of the Spot Fleet request is
     * decreased below the current size of the Spot Fleet.
     * </p>
     * <p>
     * Supported only for fleets of type <code>maintain</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the target capacity of the Spot Fleet request
     *         is decreased below the current size of the Spot Fleet.</p>
     *         <p>
     *         Supported only for fleets of type <code>maintain</code>.
     * @see ExcessCapacityTerminationPolicy
     */
    public final ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the target capacity of the Spot Fleet request is
     * decreased below the current size of the Spot Fleet.
     * </p>
     * <p>
     * Supported only for fleets of type <code>maintain</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the target capacity of the Spot Fleet request
     *         is decreased below the current size of the Spot Fleet.</p>
     *         <p>
     *         Supported only for fleets of type <code>maintain</code>.
     * @see ExcessCapacityTerminationPolicy
     */
    public final String excessCapacityTerminationPolicyAsString() {
        return excessCapacityTerminationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchTemplateConfigs() ? launchTemplateConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(onDemandTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(excessCapacityTerminationPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySpotFleetRequestRequest)) {
            return false;
        }
        ModifySpotFleetRequestRequest other = (ModifySpotFleetRequestRequest) obj;
        return hasLaunchTemplateConfigs() == other.hasLaunchTemplateConfigs()
                && Objects.equals(launchTemplateConfigs(), other.launchTemplateConfigs())
                && Objects.equals(onDemandTargetCapacity(), other.onDemandTargetCapacity())
                && Objects.equals(context(), other.context()) && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId())
                && Objects.equals(targetCapacity(), other.targetCapacity())
                && Objects.equals(excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySpotFleetRequestRequest")
                .add("LaunchTemplateConfigs", hasLaunchTemplateConfigs() ? launchTemplateConfigs() : null)
                .add("OnDemandTargetCapacity", onDemandTargetCapacity()).add("Context", context())
                .add("SpotFleetRequestId", spotFleetRequestId()).add("TargetCapacity", targetCapacity())
                .add("ExcessCapacityTerminationPolicy", excessCapacityTerminationPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateConfigs":
            return Optional.ofNullable(clazz.cast(launchTemplateConfigs()));
        case "OnDemandTargetCapacity":
            return Optional.ofNullable(clazz.cast(onDemandTargetCapacity()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "SpotFleetRequestId":
            return Optional.ofNullable(clazz.cast(spotFleetRequestId()));
        case "TargetCapacity":
            return Optional.ofNullable(clazz.cast(targetCapacity()));
        case "ExcessCapacityTerminationPolicy":
            return Optional.ofNullable(clazz.cast(excessCapacityTerminationPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LaunchTemplateConfig", LAUNCH_TEMPLATE_CONFIGS_FIELD);
        map.put("OnDemandTargetCapacity", ON_DEMAND_TARGET_CAPACITY_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("SpotFleetRequestId", SPOT_FLEET_REQUEST_ID_FIELD);
        map.put("TargetCapacity", TARGET_CAPACITY_FIELD);
        map.put("ExcessCapacityTerminationPolicy", EXCESS_CAPACITY_TERMINATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifySpotFleetRequestRequest, T> g) {
        return obj -> g.apply((ModifySpotFleetRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifySpotFleetRequestRequest> {
        /**
         * <p>
         * The launch template and overrides. You can only use this parameter if you specified a launch template (
         * <code>LaunchTemplateConfigs</code>) in your Spot Fleet request. If you specified
         * <code>LaunchSpecifications</code> in your Spot Fleet request, then omit this parameter.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides. You can only use this parameter if you specified a launch template
         *        (<code>LaunchTemplateConfigs</code>) in your Spot Fleet request. If you specified
         *        <code>LaunchSpecifications</code> in your Spot Fleet request, then omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides. You can only use this parameter if you specified a launch template (
         * <code>LaunchTemplateConfigs</code>) in your Spot Fleet request. If you specified
         * <code>LaunchSpecifications</code> in your Spot Fleet request, then omit this parameter.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides. You can only use this parameter if you specified a launch template
         *        (<code>LaunchTemplateConfigs</code>) in your Spot Fleet request. If you specified
         *        <code>LaunchSpecifications</code> in your Spot Fleet request, then omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(LaunchTemplateConfig... launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides. You can only use this parameter if you specified a launch template (
         * <code>LaunchTemplateConfigs</code>) in your Spot Fleet request. If you specified
         * <code>LaunchSpecifications</code> in your Spot Fleet request, then omit this parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #launchTemplateConfigs(List<LaunchTemplateConfig>)}.
         * 
         * @param launchTemplateConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateConfigs(java.util.Collection<LaunchTemplateConfig>)
         */
        Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder>... launchTemplateConfigs);

        /**
         * <p>
         * The number of On-Demand Instances in the fleet.
         * </p>
         * 
         * @param onDemandTargetCapacity
         *        The number of On-Demand Instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandTargetCapacity(Integer onDemandTargetCapacity);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param context
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * The ID of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);

        /**
         * <p>
         * The size of the fleet.
         * </p>
         * 
         * @param targetCapacity
         *        The size of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacity(Integer targetCapacity);

        /**
         * <p>
         * Indicates whether running instances should be terminated if the target capacity of the Spot Fleet request is
         * decreased below the current size of the Spot Fleet.
         * </p>
         * <p>
         * Supported only for fleets of type <code>maintain</code>.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the target capacity of the Spot Fleet
         *        request is decreased below the current size of the Spot Fleet.</p>
         *        <p>
         *        Supported only for fleets of type <code>maintain</code>.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running instances should be terminated if the target capacity of the Spot Fleet request is
         * decreased below the current size of the Spot Fleet.
         * </p>
         * <p>
         * Supported only for fleets of type <code>maintain</code>.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the target capacity of the Spot Fleet
         *        request is decreased below the current size of the Spot Fleet.</p>
         *        <p>
         *        Supported only for fleets of type <code>maintain</code>.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<LaunchTemplateConfig> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();

        private Integer onDemandTargetCapacity;

        private String context;

        private String spotFleetRequestId;

        private Integer targetCapacity;

        private String excessCapacityTerminationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySpotFleetRequestRequest model) {
            super(model);
            launchTemplateConfigs(model.launchTemplateConfigs);
            onDemandTargetCapacity(model.onDemandTargetCapacity);
            context(model.context);
            spotFleetRequestId(model.spotFleetRequestId);
            targetCapacity(model.targetCapacity);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
        }

        public final List<LaunchTemplateConfig.Builder> getLaunchTemplateConfigs() {
            List<LaunchTemplateConfig.Builder> result = LaunchTemplateConfigListCopier.copyToBuilder(this.launchTemplateConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchTemplateConfigs(Collection<LaunchTemplateConfig.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copyFromBuilder(launchTemplateConfigs);
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(LaunchTemplateConfig... launchTemplateConfigs) {
            launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder>... launchTemplateConfigs) {
            launchTemplateConfigs(Stream.of(launchTemplateConfigs)
                    .map(c -> LaunchTemplateConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getOnDemandTargetCapacity() {
            return onDemandTargetCapacity;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        @Override
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final Integer getTargetCapacity() {
            return targetCapacity;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return excessCapacityTerminationPolicy;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy
                    .toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySpotFleetRequestRequest build() {
            return new ModifySpotFleetRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
