/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for Verified Access logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessLogOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessLogOptions.Builder, VerifiedAccessLogOptions> {
    private static final SdkField<VerifiedAccessLogS3DestinationOptions> S3_FIELD = SdkField
            .<VerifiedAccessLogS3DestinationOptions> builder(MarshallingType.SDK_POJO)
            .memberName("S3")
            .getter(getter(VerifiedAccessLogOptions::s3))
            .setter(setter(Builder::s3))
            .constructor(VerifiedAccessLogS3DestinationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").unmarshallLocationName("S3")
                    .build()).build();

    private static final SdkField<VerifiedAccessLogCloudWatchLogsDestinationOptions> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<VerifiedAccessLogCloudWatchLogsDestinationOptions> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchLogs")
            .getter(getter(VerifiedAccessLogOptions::cloudWatchLogs))
            .setter(setter(Builder::cloudWatchLogs))
            .constructor(VerifiedAccessLogCloudWatchLogsDestinationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogs")
                    .unmarshallLocationName("CloudWatchLogs").build()).build();

    private static final SdkField<VerifiedAccessLogKinesisDataFirehoseDestinationOptions> KINESIS_DATA_FIREHOSE_FIELD = SdkField
            .<VerifiedAccessLogKinesisDataFirehoseDestinationOptions> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisDataFirehose")
            .getter(getter(VerifiedAccessLogOptions::kinesisDataFirehose))
            .setter(setter(Builder::kinesisDataFirehose))
            .constructor(VerifiedAccessLogKinesisDataFirehoseDestinationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataFirehose")
                    .unmarshallLocationName("KinesisDataFirehose").build()).build();

    private static final SdkField<String> LOG_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LogVersion")
            .getter(getter(VerifiedAccessLogOptions::logVersion))
            .setter(setter(Builder::logVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogVersion")
                    .unmarshallLocationName("LogVersion").build()).build();

    private static final SdkField<Boolean> INCLUDE_TRUST_CONTEXT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeTrustContext")
            .getter(getter(VerifiedAccessLogOptions::includeTrustContext))
            .setter(setter(Builder::includeTrustContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTrustContext")
                    .unmarshallLocationName("IncludeTrustContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD,
            CLOUD_WATCH_LOGS_FIELD, KINESIS_DATA_FIREHOSE_FIELD, LOG_VERSION_FIELD, INCLUDE_TRUST_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VerifiedAccessLogS3DestinationOptions s3;

    private final VerifiedAccessLogCloudWatchLogsDestinationOptions cloudWatchLogs;

    private final VerifiedAccessLogKinesisDataFirehoseDestinationOptions kinesisDataFirehose;

    private final String logVersion;

    private final Boolean includeTrustContext;

    private VerifiedAccessLogOptions(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.kinesisDataFirehose = builder.kinesisDataFirehose;
        this.logVersion = builder.logVersion;
        this.includeTrustContext = builder.includeTrustContext;
    }

    /**
     * <p>
     * Sends Verified Access logs to Amazon S3.
     * </p>
     * 
     * @return Sends Verified Access logs to Amazon S3.
     */
    public final VerifiedAccessLogS3DestinationOptions s3() {
        return s3;
    }

    /**
     * <p>
     * Sends Verified Access logs to CloudWatch Logs.
     * </p>
     * 
     * @return Sends Verified Access logs to CloudWatch Logs.
     */
    public final VerifiedAccessLogCloudWatchLogsDestinationOptions cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * Sends Verified Access logs to Kinesis.
     * </p>
     * 
     * @return Sends Verified Access logs to Kinesis.
     */
    public final VerifiedAccessLogKinesisDataFirehoseDestinationOptions kinesisDataFirehose() {
        return kinesisDataFirehose;
    }

    /**
     * <p>
     * The logging version.
     * </p>
     * <p>
     * Valid values: <code>ocsf-0.1</code> | <code>ocsf-1.0.0-rc.2</code>
     * </p>
     * 
     * @return The logging version.</p>
     *         <p>
     *         Valid values: <code>ocsf-0.1</code> | <code>ocsf-1.0.0-rc.2</code>
     */
    public final String logVersion() {
        return logVersion;
    }

    /**
     * <p>
     * Indicates whether to include trust data sent by trust providers in the logs.
     * </p>
     * 
     * @return Indicates whether to include trust data sent by trust providers in the logs.
     */
    public final Boolean includeTrustContext() {
        return includeTrustContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisDataFirehose());
        hashCode = 31 * hashCode + Objects.hashCode(logVersion());
        hashCode = 31 * hashCode + Objects.hashCode(includeTrustContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessLogOptions)) {
            return false;
        }
        VerifiedAccessLogOptions other = (VerifiedAccessLogOptions) obj;
        return Objects.equals(s3(), other.s3()) && Objects.equals(cloudWatchLogs(), other.cloudWatchLogs())
                && Objects.equals(kinesisDataFirehose(), other.kinesisDataFirehose())
                && Objects.equals(logVersion(), other.logVersion())
                && Objects.equals(includeTrustContext(), other.includeTrustContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessLogOptions").add("S3", s3()).add("CloudWatchLogs", cloudWatchLogs())
                .add("KinesisDataFirehose", kinesisDataFirehose()).add("LogVersion", logVersion())
                .add("IncludeTrustContext", includeTrustContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "CloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "KinesisDataFirehose":
            return Optional.ofNullable(clazz.cast(kinesisDataFirehose()));
        case "LogVersion":
            return Optional.ofNullable(clazz.cast(logVersion()));
        case "IncludeTrustContext":
            return Optional.ofNullable(clazz.cast(includeTrustContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3", S3_FIELD);
        map.put("CloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("KinesisDataFirehose", KINESIS_DATA_FIREHOSE_FIELD);
        map.put("LogVersion", LOG_VERSION_FIELD);
        map.put("IncludeTrustContext", INCLUDE_TRUST_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessLogOptions, T> g) {
        return obj -> g.apply((VerifiedAccessLogOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessLogOptions> {
        /**
         * <p>
         * Sends Verified Access logs to Amazon S3.
         * </p>
         * 
         * @param s3
         *        Sends Verified Access logs to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(VerifiedAccessLogS3DestinationOptions s3);

        /**
         * <p>
         * Sends Verified Access logs to Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessLogS3DestinationOptions.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessLogS3DestinationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessLogS3DestinationOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #s3(VerifiedAccessLogS3DestinationOptions)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link VerifiedAccessLogS3DestinationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(VerifiedAccessLogS3DestinationOptions)
         */
        default Builder s3(Consumer<VerifiedAccessLogS3DestinationOptions.Builder> s3) {
            return s3(VerifiedAccessLogS3DestinationOptions.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * Sends Verified Access logs to CloudWatch Logs.
         * </p>
         * 
         * @param cloudWatchLogs
         *        Sends Verified Access logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestinationOptions cloudWatchLogs);

        /**
         * <p>
         * Sends Verified Access logs to CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessLogCloudWatchLogsDestinationOptions.Builder} avoiding the need to create one manually
         * via {@link VerifiedAccessLogCloudWatchLogsDestinationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link VerifiedAccessLogCloudWatchLogsDestinationOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestinationOptions)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link VerifiedAccessLogCloudWatchLogsDestinationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestinationOptions)
         */
        default Builder cloudWatchLogs(Consumer<VerifiedAccessLogCloudWatchLogsDestinationOptions.Builder> cloudWatchLogs) {
            return cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestinationOptions.builder().applyMutation(cloudWatchLogs)
                    .build());
        }

        /**
         * <p>
         * Sends Verified Access logs to Kinesis.
         * </p>
         * 
         * @param kinesisDataFirehose
         *        Sends Verified Access logs to Kinesis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestinationOptions kinesisDataFirehose);

        /**
         * <p>
         * Sends Verified Access logs to Kinesis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessLogKinesisDataFirehoseDestinationOptions.Builder} avoiding the need to create one
         * manually via {@link VerifiedAccessLogKinesisDataFirehoseDestinationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link VerifiedAccessLogKinesisDataFirehoseDestinationOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestinationOptions)}.
         * 
         * @param kinesisDataFirehose
         *        a consumer that will call methods on
         *        {@link VerifiedAccessLogKinesisDataFirehoseDestinationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestinationOptions)
         */
        default Builder kinesisDataFirehose(
                Consumer<VerifiedAccessLogKinesisDataFirehoseDestinationOptions.Builder> kinesisDataFirehose) {
            return kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestinationOptions.builder()
                    .applyMutation(kinesisDataFirehose).build());
        }

        /**
         * <p>
         * The logging version.
         * </p>
         * <p>
         * Valid values: <code>ocsf-0.1</code> | <code>ocsf-1.0.0-rc.2</code>
         * </p>
         * 
         * @param logVersion
         *        The logging version.</p>
         *        <p>
         *        Valid values: <code>ocsf-0.1</code> | <code>ocsf-1.0.0-rc.2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logVersion(String logVersion);

        /**
         * <p>
         * Indicates whether to include trust data sent by trust providers in the logs.
         * </p>
         * 
         * @param includeTrustContext
         *        Indicates whether to include trust data sent by trust providers in the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTrustContext(Boolean includeTrustContext);
    }

    static final class BuilderImpl implements Builder {
        private VerifiedAccessLogS3DestinationOptions s3;

        private VerifiedAccessLogCloudWatchLogsDestinationOptions cloudWatchLogs;

        private VerifiedAccessLogKinesisDataFirehoseDestinationOptions kinesisDataFirehose;

        private String logVersion;

        private Boolean includeTrustContext;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessLogOptions model) {
            s3(model.s3);
            cloudWatchLogs(model.cloudWatchLogs);
            kinesisDataFirehose(model.kinesisDataFirehose);
            logVersion(model.logVersion);
            includeTrustContext(model.includeTrustContext);
        }

        public final VerifiedAccessLogS3DestinationOptions.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(VerifiedAccessLogS3DestinationOptions.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(VerifiedAccessLogS3DestinationOptions s3) {
            this.s3 = s3;
            return this;
        }

        public final VerifiedAccessLogCloudWatchLogsDestinationOptions.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestinationOptions.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(VerifiedAccessLogCloudWatchLogsDestinationOptions cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final VerifiedAccessLogKinesisDataFirehoseDestinationOptions.Builder getKinesisDataFirehose() {
            return kinesisDataFirehose != null ? kinesisDataFirehose.toBuilder() : null;
        }

        public final void setKinesisDataFirehose(
                VerifiedAccessLogKinesisDataFirehoseDestinationOptions.BuilderImpl kinesisDataFirehose) {
            this.kinesisDataFirehose = kinesisDataFirehose != null ? kinesisDataFirehose.build() : null;
        }

        @Override
        public final Builder kinesisDataFirehose(VerifiedAccessLogKinesisDataFirehoseDestinationOptions kinesisDataFirehose) {
            this.kinesisDataFirehose = kinesisDataFirehose;
            return this;
        }

        public final String getLogVersion() {
            return logVersion;
        }

        public final void setLogVersion(String logVersion) {
            this.logVersion = logVersion;
        }

        @Override
        public final Builder logVersion(String logVersion) {
            this.logVersion = logVersion;
            return this;
        }

        public final Boolean getIncludeTrustContext() {
            return includeTrustContext;
        }

        public final void setIncludeTrustContext(Boolean includeTrustContext) {
            this.includeTrustContext = includeTrustContext;
        }

        @Override
        public final Builder includeTrustContext(Boolean includeTrustContext) {
            this.includeTrustContext = includeTrustContext;
            return this;
        }

        @Override
        public VerifiedAccessLogOptions build() {
            return new VerifiedAccessLogOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
