/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteNetworkInsightsAccessScopeAnalysisResponse extends Ec2Response
        implements
        ToCopyableBuilder<DeleteNetworkInsightsAccessScopeAnalysisResponse.Builder, DeleteNetworkInsightsAccessScopeAnalysisResponse> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeAnalysisId")
            .getter(getter(DeleteNetworkInsightsAccessScopeAnalysisResponse::networkInsightsAccessScopeAnalysisId))
            .setter(setter(Builder::networkInsightsAccessScopeAnalysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkInsightsAccessScopeAnalysisId")
                    .unmarshallLocationName("networkInsightsAccessScopeAnalysisId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String networkInsightsAccessScopeAnalysisId;

    private DeleteNetworkInsightsAccessScopeAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAccessScopeAnalysisId = builder.networkInsightsAccessScopeAnalysisId;
    }

    /**
     * <p>
     * The ID of the Network Access Scope analysis.
     * </p>
     * 
     * @return The ID of the Network Access Scope analysis.
     */
    public final String networkInsightsAccessScopeAnalysisId() {
        return networkInsightsAccessScopeAnalysisId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeAnalysisId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkInsightsAccessScopeAnalysisResponse)) {
            return false;
        }
        DeleteNetworkInsightsAccessScopeAnalysisResponse other = (DeleteNetworkInsightsAccessScopeAnalysisResponse) obj;
        return Objects.equals(networkInsightsAccessScopeAnalysisId(), other.networkInsightsAccessScopeAnalysisId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteNetworkInsightsAccessScopeAnalysisResponse")
                .add("NetworkInsightsAccessScopeAnalysisId", networkInsightsAccessScopeAnalysisId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAccessScopeAnalysisId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeAnalysisId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NetworkInsightsAccessScopeAnalysisId", NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkInsightsAccessScopeAnalysisResponse, T> g) {
        return obj -> g.apply((DeleteNetworkInsightsAccessScopeAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteNetworkInsightsAccessScopeAnalysisResponse> {
        /**
         * <p>
         * The ID of the Network Access Scope analysis.
         * </p>
         * 
         * @param networkInsightsAccessScopeAnalysisId
         *        The ID of the Network Access Scope analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String networkInsightsAccessScopeAnalysisId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkInsightsAccessScopeAnalysisResponse model) {
            super(model);
            networkInsightsAccessScopeAnalysisId(model.networkInsightsAccessScopeAnalysisId);
        }

        public final String getNetworkInsightsAccessScopeAnalysisId() {
            return networkInsightsAccessScopeAnalysisId;
        }

        public final void setNetworkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
            return this;
        }

        @Override
        public DeleteNetworkInsightsAccessScopeAnalysisResponse build() {
            return new DeleteNetworkInsightsAccessScopeAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
