/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcBlockPublicAccessOptionsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcBlockPublicAccessOptionsResponse.Builder, DescribeVpcBlockPublicAccessOptionsResponse> {
    private static final SdkField<VpcBlockPublicAccessOptions> VPC_BLOCK_PUBLIC_ACCESS_OPTIONS_FIELD = SdkField
            .<VpcBlockPublicAccessOptions> builder(MarshallingType.SDK_POJO)
            .memberName("VpcBlockPublicAccessOptions")
            .getter(getter(DescribeVpcBlockPublicAccessOptionsResponse::vpcBlockPublicAccessOptions))
            .setter(setter(Builder::vpcBlockPublicAccessOptions))
            .constructor(VpcBlockPublicAccessOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcBlockPublicAccessOptions")
                    .unmarshallLocationName("vpcBlockPublicAccessOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VPC_BLOCK_PUBLIC_ACCESS_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcBlockPublicAccessOptions vpcBlockPublicAccessOptions;

    private DescribeVpcBlockPublicAccessOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcBlockPublicAccessOptions = builder.vpcBlockPublicAccessOptions;
    }

    /**
     * <p>
     * Details related to the options.
     * </p>
     * 
     * @return Details related to the options.
     */
    public final VpcBlockPublicAccessOptions vpcBlockPublicAccessOptions() {
        return vpcBlockPublicAccessOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcBlockPublicAccessOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcBlockPublicAccessOptionsResponse)) {
            return false;
        }
        DescribeVpcBlockPublicAccessOptionsResponse other = (DescribeVpcBlockPublicAccessOptionsResponse) obj;
        return Objects.equals(vpcBlockPublicAccessOptions(), other.vpcBlockPublicAccessOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpcBlockPublicAccessOptionsResponse")
                .add("VpcBlockPublicAccessOptions", vpcBlockPublicAccessOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcBlockPublicAccessOptions":
            return Optional.ofNullable(clazz.cast(vpcBlockPublicAccessOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcBlockPublicAccessOptions", VPC_BLOCK_PUBLIC_ACCESS_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcBlockPublicAccessOptionsResponse, T> g) {
        return obj -> g.apply((DescribeVpcBlockPublicAccessOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcBlockPublicAccessOptionsResponse> {
        /**
         * <p>
         * Details related to the options.
         * </p>
         * 
         * @param vpcBlockPublicAccessOptions
         *        Details related to the options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcBlockPublicAccessOptions(VpcBlockPublicAccessOptions vpcBlockPublicAccessOptions);

        /**
         * <p>
         * Details related to the options.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcBlockPublicAccessOptions.Builder}
         * avoiding the need to create one manually via {@link VpcBlockPublicAccessOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcBlockPublicAccessOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcBlockPublicAccessOptions(VpcBlockPublicAccessOptions)}.
         * 
         * @param vpcBlockPublicAccessOptions
         *        a consumer that will call methods on {@link VpcBlockPublicAccessOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcBlockPublicAccessOptions(VpcBlockPublicAccessOptions)
         */
        default Builder vpcBlockPublicAccessOptions(Consumer<VpcBlockPublicAccessOptions.Builder> vpcBlockPublicAccessOptions) {
            return vpcBlockPublicAccessOptions(VpcBlockPublicAccessOptions.builder().applyMutation(vpcBlockPublicAccessOptions)
                    .build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VpcBlockPublicAccessOptions vpcBlockPublicAccessOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcBlockPublicAccessOptionsResponse model) {
            super(model);
            vpcBlockPublicAccessOptions(model.vpcBlockPublicAccessOptions);
        }

        public final VpcBlockPublicAccessOptions.Builder getVpcBlockPublicAccessOptions() {
            return vpcBlockPublicAccessOptions != null ? vpcBlockPublicAccessOptions.toBuilder() : null;
        }

        public final void setVpcBlockPublicAccessOptions(VpcBlockPublicAccessOptions.BuilderImpl vpcBlockPublicAccessOptions) {
            this.vpcBlockPublicAccessOptions = vpcBlockPublicAccessOptions != null ? vpcBlockPublicAccessOptions.build() : null;
        }

        @Override
        public final Builder vpcBlockPublicAccessOptions(VpcBlockPublicAccessOptions vpcBlockPublicAccessOptions) {
            this.vpcBlockPublicAccessOptions = vpcBlockPublicAccessOptions;
            return this;
        }

        @Override
        public DescribeVpcBlockPublicAccessOptionsResponse build() {
            return new DescribeVpcBlockPublicAccessOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
