/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The maintenance options for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMaintenanceOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMaintenanceOptionsRequest.Builder, InstanceMaintenanceOptionsRequest> {
    private static final SdkField<String> AUTO_RECOVERY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoRecovery")
            .getter(getter(InstanceMaintenanceOptionsRequest::autoRecoveryAsString))
            .setter(setter(Builder::autoRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecovery")
                    .unmarshallLocationName("AutoRecovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_RECOVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String autoRecovery;

    private InstanceMaintenanceOptionsRequest(BuilderImpl builder) {
        this.autoRecovery = builder.autoRecovery;
    }

    /**
     * <p>
     * Disables the automatic recovery behavior of your instance or sets it to default. For more information, see <a
     * href
     * ="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery"
     * >Simplified automatic recovery</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRecovery} will
     * return {@link InstanceAutoRecoveryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoRecoveryAsString}.
     * </p>
     * 
     * @return Disables the automatic recovery behavior of your instance or sets it to default. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery"
     *         >Simplified automatic recovery</a>.
     * @see InstanceAutoRecoveryState
     */
    public final InstanceAutoRecoveryState autoRecovery() {
        return InstanceAutoRecoveryState.fromValue(autoRecovery);
    }

    /**
     * <p>
     * Disables the automatic recovery behavior of your instance or sets it to default. For more information, see <a
     * href
     * ="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery"
     * >Simplified automatic recovery</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRecovery} will
     * return {@link InstanceAutoRecoveryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoRecoveryAsString}.
     * </p>
     * 
     * @return Disables the automatic recovery behavior of your instance or sets it to default. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery"
     *         >Simplified automatic recovery</a>.
     * @see InstanceAutoRecoveryState
     */
    public final String autoRecoveryAsString() {
        return autoRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoRecoveryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMaintenanceOptionsRequest)) {
            return false;
        }
        InstanceMaintenanceOptionsRequest other = (InstanceMaintenanceOptionsRequest) obj;
        return Objects.equals(autoRecoveryAsString(), other.autoRecoveryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMaintenanceOptionsRequest").add("AutoRecovery", autoRecoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoRecovery":
            return Optional.ofNullable(clazz.cast(autoRecoveryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoRecovery", AUTO_RECOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceMaintenanceOptionsRequest, T> g) {
        return obj -> g.apply((InstanceMaintenanceOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMaintenanceOptionsRequest> {
        /**
         * <p>
         * Disables the automatic recovery behavior of your instance or sets it to default. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery"
         * >Simplified automatic recovery</a>.
         * </p>
         * 
         * @param autoRecovery
         *        Disables the automatic recovery behavior of your instance or sets it to default. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery"
         *        >Simplified automatic recovery</a>.
         * @see InstanceAutoRecoveryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAutoRecoveryState
         */
        Builder autoRecovery(String autoRecovery);

        /**
         * <p>
         * Disables the automatic recovery behavior of your instance or sets it to default. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery"
         * >Simplified automatic recovery</a>.
         * </p>
         * 
         * @param autoRecovery
         *        Disables the automatic recovery behavior of your instance or sets it to default. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery"
         *        >Simplified automatic recovery</a>.
         * @see InstanceAutoRecoveryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAutoRecoveryState
         */
        Builder autoRecovery(InstanceAutoRecoveryState autoRecovery);
    }

    static final class BuilderImpl implements Builder {
        private String autoRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMaintenanceOptionsRequest model) {
            autoRecovery(model.autoRecovery);
        }

        public final String getAutoRecovery() {
            return autoRecovery;
        }

        public final void setAutoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
        }

        @Override
        public final Builder autoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        @Override
        public final Builder autoRecovery(InstanceAutoRecoveryState autoRecovery) {
            this.autoRecovery(autoRecovery == null ? null : autoRecovery.toString());
            return this;
        }

        @Override
        public InstanceMaintenanceOptionsRequest build() {
            return new InstanceMaintenanceOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
