/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeClientVpnIngressRequest extends Ec2Request implements
        ToCopyableBuilder<RevokeClientVpnIngressRequest.Builder, RevokeClientVpnIngressRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(RevokeClientVpnIngressRequest::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("ClientVpnEndpointId").build()).build();

    private static final SdkField<String> TARGET_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetNetworkCidr")
            .getter(getter(RevokeClientVpnIngressRequest::targetNetworkCidr))
            .setter(setter(Builder::targetNetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNetworkCidr")
                    .unmarshallLocationName("TargetNetworkCidr").build()).build();

    private static final SdkField<String> ACCESS_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGroupId")
            .getter(getter(RevokeClientVpnIngressRequest::accessGroupId))
            .setter(setter(Builder::accessGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGroupId")
                    .unmarshallLocationName("AccessGroupId").build()).build();

    private static final SdkField<Boolean> REVOKE_ALL_GROUPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RevokeAllGroups")
            .getter(getter(RevokeClientVpnIngressRequest::revokeAllGroups))
            .setter(setter(Builder::revokeAllGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokeAllGroups")
                    .unmarshallLocationName("RevokeAllGroups").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(RevokeClientVpnIngressRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            TARGET_NETWORK_CIDR_FIELD, ACCESS_GROUP_ID_FIELD, REVOKE_ALL_GROUPS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientVpnEndpointId;

    private final String targetNetworkCidr;

    private final String accessGroupId;

    private final Boolean revokeAllGroups;

    private final Boolean dryRun;

    private RevokeClientVpnIngressRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.targetNetworkCidr = builder.targetNetworkCidr;
        this.accessGroupId = builder.accessGroupId;
        this.revokeAllGroups = builder.revokeAllGroups;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint with which the authorization rule is associated.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint with which the authorization rule is associated.
     */
    public final String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, of the network for which access is being removed.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, of the network for which access is being removed.
     */
    public final String targetNetworkCidr() {
        return targetNetworkCidr;
    }

    /**
     * <p>
     * The ID of the Active Directory group for which to revoke access.
     * </p>
     * 
     * @return The ID of the Active Directory group for which to revoke access.
     */
    public final String accessGroupId() {
        return accessGroupId;
    }

    /**
     * <p>
     * Indicates whether access should be revoked for all groups for a single <code>TargetNetworkCidr</code> that
     * earlier authorized ingress for all groups using <code>AuthorizeAllGroups</code>. This does not impact other
     * authorization rules that allowed ingress to the same <code>TargetNetworkCidr</code> with a specific
     * <code>AccessGroupId</code>.
     * </p>
     * 
     * @return Indicates whether access should be revoked for all groups for a single <code>TargetNetworkCidr</code>
     *         that earlier authorized ingress for all groups using <code>AuthorizeAllGroups</code>. This does not
     *         impact other authorization rules that allowed ingress to the same <code>TargetNetworkCidr</code> with a
     *         specific <code>AccessGroupId</code>.
     */
    public final Boolean revokeAllGroups() {
        return revokeAllGroups;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(targetNetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(accessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(revokeAllGroups());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeClientVpnIngressRequest)) {
            return false;
        }
        RevokeClientVpnIngressRequest other = (RevokeClientVpnIngressRequest) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(targetNetworkCidr(), other.targetNetworkCidr())
                && Objects.equals(accessGroupId(), other.accessGroupId())
                && Objects.equals(revokeAllGroups(), other.revokeAllGroups()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeClientVpnIngressRequest").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("TargetNetworkCidr", targetNetworkCidr()).add("AccessGroupId", accessGroupId())
                .add("RevokeAllGroups", revokeAllGroups()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "TargetNetworkCidr":
            return Optional.ofNullable(clazz.cast(targetNetworkCidr()));
        case "AccessGroupId":
            return Optional.ofNullable(clazz.cast(accessGroupId()));
        case "RevokeAllGroups":
            return Optional.ofNullable(clazz.cast(revokeAllGroups()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientVpnEndpointId", CLIENT_VPN_ENDPOINT_ID_FIELD);
        map.put("TargetNetworkCidr", TARGET_NETWORK_CIDR_FIELD);
        map.put("AccessGroupId", ACCESS_GROUP_ID_FIELD);
        map.put("RevokeAllGroups", REVOKE_ALL_GROUPS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeClientVpnIngressRequest, T> g) {
        return obj -> g.apply((RevokeClientVpnIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RevokeClientVpnIngressRequest> {
        /**
         * <p>
         * The ID of the Client VPN endpoint with which the authorization rule is associated.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint with which the authorization rule is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the network for which access is being removed.
         * </p>
         * 
         * @param targetNetworkCidr
         *        The IPv4 address range, in CIDR notation, of the network for which access is being removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNetworkCidr(String targetNetworkCidr);

        /**
         * <p>
         * The ID of the Active Directory group for which to revoke access.
         * </p>
         * 
         * @param accessGroupId
         *        The ID of the Active Directory group for which to revoke access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGroupId(String accessGroupId);

        /**
         * <p>
         * Indicates whether access should be revoked for all groups for a single <code>TargetNetworkCidr</code> that
         * earlier authorized ingress for all groups using <code>AuthorizeAllGroups</code>. This does not impact other
         * authorization rules that allowed ingress to the same <code>TargetNetworkCidr</code> with a specific
         * <code>AccessGroupId</code>.
         * </p>
         * 
         * @param revokeAllGroups
         *        Indicates whether access should be revoked for all groups for a single <code>TargetNetworkCidr</code>
         *        that earlier authorized ingress for all groups using <code>AuthorizeAllGroups</code>. This does not
         *        impact other authorization rules that allowed ingress to the same <code>TargetNetworkCidr</code> with
         *        a specific <code>AccessGroupId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokeAllGroups(Boolean revokeAllGroups);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String targetNetworkCidr;

        private String accessGroupId;

        private Boolean revokeAllGroups;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeClientVpnIngressRequest model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            targetNetworkCidr(model.targetNetworkCidr);
            accessGroupId(model.accessGroupId);
            revokeAllGroups(model.revokeAllGroups);
            dryRun(model.dryRun);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getTargetNetworkCidr() {
            return targetNetworkCidr;
        }

        public final void setTargetNetworkCidr(String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
        }

        @Override
        public final Builder targetNetworkCidr(String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
            return this;
        }

        public final String getAccessGroupId() {
            return accessGroupId;
        }

        public final void setAccessGroupId(String accessGroupId) {
            this.accessGroupId = accessGroupId;
        }

        @Override
        public final Builder accessGroupId(String accessGroupId) {
            this.accessGroupId = accessGroupId;
            return this;
        }

        public final Boolean getRevokeAllGroups() {
            return revokeAllGroups;
        }

        public final void setRevokeAllGroups(Boolean revokeAllGroups) {
            this.revokeAllGroups = revokeAllGroups;
        }

        @Override
        public final Builder revokeAllGroups(Boolean revokeAllGroups) {
            this.revokeAllGroups = revokeAllGroups;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeClientVpnIngressRequest build() {
            return new RevokeClientVpnIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
