/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Prefixes of the subnet IP.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubnetIpPrefixes implements SdkPojo, Serializable,
        ToCopyableBuilder<SubnetIpPrefixes.Builder, SubnetIpPrefixes> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(SubnetIpPrefixes::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<List<String>> IP_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpPrefixes")
            .getter(getter(SubnetIpPrefixes::ipPrefixes))
            .setter(setter(Builder::ipPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPrefixSet")
                    .unmarshallLocationName("ipPrefixSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD,
            IP_PREFIXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final List<String> ipPrefixes;

    private SubnetIpPrefixes(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.ipPrefixes = builder.ipPrefixes;
    }

    /**
     * <p>
     * ID of the subnet.
     * </p>
     * 
     * @return ID of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPrefixes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpPrefixes() {
        return ipPrefixes != null && !(ipPrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of SubnetIpPrefixes objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPrefixes} method.
     * </p>
     * 
     * @return Array of SubnetIpPrefixes objects.
     */
    public final List<String> ipPrefixes() {
        return ipPrefixes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPrefixes() ? ipPrefixes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetIpPrefixes)) {
            return false;
        }
        SubnetIpPrefixes other = (SubnetIpPrefixes) obj;
        return Objects.equals(subnetId(), other.subnetId()) && hasIpPrefixes() == other.hasIpPrefixes()
                && Objects.equals(ipPrefixes(), other.ipPrefixes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubnetIpPrefixes").add("SubnetId", subnetId())
                .add("IpPrefixes", hasIpPrefixes() ? ipPrefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "IpPrefixes":
            return Optional.ofNullable(clazz.cast(ipPrefixes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("IpPrefixSet", IP_PREFIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubnetIpPrefixes, T> g) {
        return obj -> g.apply((SubnetIpPrefixes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubnetIpPrefixes> {
        /**
         * <p>
         * ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Array of SubnetIpPrefixes objects.
         * </p>
         * 
         * @param ipPrefixes
         *        Array of SubnetIpPrefixes objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPrefixes(Collection<String> ipPrefixes);

        /**
         * <p>
         * Array of SubnetIpPrefixes objects.
         * </p>
         * 
         * @param ipPrefixes
         *        Array of SubnetIpPrefixes objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPrefixes(String... ipPrefixes);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private List<String> ipPrefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetIpPrefixes model) {
            subnetId(model.subnetId);
            ipPrefixes(model.ipPrefixes);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getIpPrefixes() {
            if (ipPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return ipPrefixes;
        }

        public final void setIpPrefixes(Collection<String> ipPrefixes) {
            this.ipPrefixes = ValueStringListCopier.copy(ipPrefixes);
        }

        @Override
        public final Builder ipPrefixes(Collection<String> ipPrefixes) {
            this.ipPrefixes = ValueStringListCopier.copy(ipPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPrefixes(String... ipPrefixes) {
            ipPrefixes(Arrays.asList(ipPrefixes));
            return this;
        }

        @Override
        public SubnetIpPrefixes build() {
            return new SubnetIpPrefixes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
