/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an attachment between a resource and a transit gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayAttachment.Builder, TransitGatewayAttachment> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(TransitGatewayAttachment::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(TransitGatewayAttachment::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayOwnerId")
            .getter(getter(TransitGatewayAttachment::transitGatewayOwnerId))
            .setter(setter(Builder::transitGatewayOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayOwnerId")
                    .unmarshallLocationName("transitGatewayOwnerId").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwnerId")
            .getter(getter(TransitGatewayAttachment::resourceOwnerId))
            .setter(setter(Builder::resourceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId")
                    .unmarshallLocationName("resourceOwnerId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(TransitGatewayAttachment::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(TransitGatewayAttachment::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayAttachment::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<TransitGatewayAttachmentAssociation> ASSOCIATION_FIELD = SdkField
            .<TransitGatewayAttachmentAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("Association")
            .getter(getter(TransitGatewayAttachment::association))
            .setter(setter(Builder::association))
            .constructor(TransitGatewayAttachmentAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association")
                    .unmarshallLocationName("association").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(TransitGatewayAttachment::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TransitGatewayAttachment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_OWNER_ID_FIELD,
            RESOURCE_OWNER_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, STATE_FIELD, ASSOCIATION_FIELD, CREATION_TIME_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentId;

    private final String transitGatewayId;

    private final String transitGatewayOwnerId;

    private final String resourceOwnerId;

    private final String resourceType;

    private final String resourceId;

    private final String state;

    private final TransitGatewayAttachmentAssociation association;

    private final Instant creationTime;

    private final List<Tag> tags;

    private TransitGatewayAttachment(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transitGatewayId = builder.transitGatewayId;
        this.transitGatewayOwnerId = builder.transitGatewayOwnerId;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.state = builder.state;
        this.association = builder.association;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the transit gateway.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the transit gateway.
     */
    public final String transitGatewayOwnerId() {
        return transitGatewayOwnerId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the resource.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the resource.
     */
    public final String resourceOwnerId() {
        return resourceOwnerId;
    }

    /**
     * <p>
     * The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * @see TransitGatewayAttachmentResourceType
     */
    public final TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
     * @see TransitGatewayAttachmentResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The attachment state. Note that the <code>initiating</code> state has been deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The attachment state. Note that the <code>initiating</code> state has been deprecated.
     * @see TransitGatewayAttachmentState
     */
    public final TransitGatewayAttachmentState state() {
        return TransitGatewayAttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The attachment state. Note that the <code>initiating</code> state has been deprecated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The attachment state. Note that the <code>initiating</code> state has been deprecated.
     * @see TransitGatewayAttachmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The association.
     * </p>
     * 
     * @return The association.
     */
    public final TransitGatewayAttachmentAssociation association() {
        return association;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the attachment.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(association());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayAttachment)) {
            return false;
        }
        TransitGatewayAttachment other = (TransitGatewayAttachment) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(transitGatewayOwnerId(), other.transitGatewayOwnerId())
                && Objects.equals(resourceOwnerId(), other.resourceOwnerId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(association(), other.association()) && Objects.equals(creationTime(), other.creationTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayAttachment").add("TransitGatewayAttachmentId", transitGatewayAttachmentId())
                .add("TransitGatewayId", transitGatewayId()).add("TransitGatewayOwnerId", transitGatewayOwnerId())
                .add("ResourceOwnerId", resourceOwnerId()).add("ResourceType", resourceTypeAsString())
                .add("ResourceId", resourceId()).add("State", stateAsString()).add("Association", association())
                .add("CreationTime", creationTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "TransitGatewayOwnerId":
            return Optional.ofNullable(clazz.cast(transitGatewayOwnerId()));
        case "ResourceOwnerId":
            return Optional.ofNullable(clazz.cast(resourceOwnerId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("TransitGatewayOwnerId", TRANSIT_GATEWAY_OWNER_ID_FIELD);
        map.put("ResourceOwnerId", RESOURCE_OWNER_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Association", ASSOCIATION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayAttachment, T> g) {
        return obj -> g.apply((TransitGatewayAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayAttachment> {
        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the transit gateway.
         * </p>
         * 
         * @param transitGatewayOwnerId
         *        The ID of the Amazon Web Services account that owns the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayOwnerId(String transitGatewayOwnerId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the resource.
         * </p>
         * 
         * @param resourceOwnerId
         *        The ID of the Amazon Web Services account that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerId(String resourceOwnerId);

        /**
         * <p>
         * The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
         * </p>
         * 
         * @param resourceType
         *        The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
         * </p>
         * 
         * @param resourceType
         *        The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(TransitGatewayAttachmentResourceType resourceType);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The attachment state. Note that the <code>initiating</code> state has been deprecated.
         * </p>
         * 
         * @param state
         *        The attachment state. Note that the <code>initiating</code> state has been deprecated.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The attachment state. Note that the <code>initiating</code> state has been deprecated.
         * </p>
         * 
         * @param state
         *        The attachment state. Note that the <code>initiating</code> state has been deprecated.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(TransitGatewayAttachmentState state);

        /**
         * <p>
         * The association.
         * </p>
         * 
         * @param association
         *        The association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(TransitGatewayAttachmentAssociation association);

        /**
         * <p>
         * The association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayAttachmentAssociation.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayAttachmentAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayAttachmentAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #association(TransitGatewayAttachmentAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link TransitGatewayAttachmentAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(TransitGatewayAttachmentAssociation)
         */
        default Builder association(Consumer<TransitGatewayAttachmentAssociation.Builder> association) {
            return association(TransitGatewayAttachmentAssociation.builder().applyMutation(association).build());
        }

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String transitGatewayId;

        private String transitGatewayOwnerId;

        private String resourceOwnerId;

        private String resourceType;

        private String resourceId;

        private String state;

        private TransitGatewayAttachmentAssociation association;

        private Instant creationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayAttachment model) {
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            transitGatewayId(model.transitGatewayId);
            transitGatewayOwnerId(model.transitGatewayOwnerId);
            resourceOwnerId(model.resourceOwnerId);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            state(model.state);
            association(model.association);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getTransitGatewayOwnerId() {
            return transitGatewayOwnerId;
        }

        public final void setTransitGatewayOwnerId(String transitGatewayOwnerId) {
            this.transitGatewayOwnerId = transitGatewayOwnerId;
        }

        @Override
        public final Builder transitGatewayOwnerId(String transitGatewayOwnerId) {
            this.transitGatewayOwnerId = transitGatewayOwnerId;
            return this;
        }

        public final String getResourceOwnerId() {
            return resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final TransitGatewayAttachmentAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        public final void setAssociation(TransitGatewayAttachmentAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(TransitGatewayAttachmentAssociation association) {
            this.association = association;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGatewayAttachment build() {
            return new TransitGatewayAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
