/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the deregistered transit gateway multicast group sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayMulticastDeregisteredGroupSources
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<TransitGatewayMulticastDeregisteredGroupSources.Builder, TransitGatewayMulticastDeregisteredGroupSources> {
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayMulticastDomainId")
            .getter(getter(TransitGatewayMulticastDeregisteredGroupSources::transitGatewayMulticastDomainId))
            .setter(setter(Builder::transitGatewayMulticastDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId")
                    .unmarshallLocationName("transitGatewayMulticastDomainId").build()).build();

    private static final SdkField<List<String>> DEREGISTERED_NETWORK_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeregisteredNetworkInterfaceIds")
            .getter(getter(TransitGatewayMulticastDeregisteredGroupSources::deregisteredNetworkInterfaceIds))
            .setter(setter(Builder::deregisteredNetworkInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeregisteredNetworkInterfaceIds")
                    .unmarshallLocationName("deregisteredNetworkInterfaceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupIpAddress")
            .getter(getter(TransitGatewayMulticastDeregisteredGroupSources::groupIpAddress))
            .setter(setter(Builder::groupIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress")
                    .unmarshallLocationName("groupIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, DEREGISTERED_NETWORK_INTERFACE_IDS_FIELD, GROUP_IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transitGatewayMulticastDomainId;

    private final List<String> deregisteredNetworkInterfaceIds;

    private final String groupIpAddress;

    private TransitGatewayMulticastDeregisteredGroupSources(BuilderImpl builder) {
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.deregisteredNetworkInterfaceIds = builder.deregisteredNetworkInterfaceIds;
        this.groupIpAddress = builder.groupIpAddress;
    }

    /**
     * <p>
     * The ID of the transit gateway multicast domain.
     * </p>
     * 
     * @return The ID of the transit gateway multicast domain.
     */
    public final String transitGatewayMulticastDomainId() {
        return transitGatewayMulticastDomainId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeregisteredNetworkInterfaceIds
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDeregisteredNetworkInterfaceIds() {
        return deregisteredNetworkInterfaceIds != null && !(deregisteredNetworkInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interface IDs of the non-registered members.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeregisteredNetworkInterfaceIds}
     * method.
     * </p>
     * 
     * @return The network interface IDs of the non-registered members.
     */
    public final List<String> deregisteredNetworkInterfaceIds() {
        return deregisteredNetworkInterfaceIds;
    }

    /**
     * <p>
     * The IP address assigned to the transit gateway multicast group.
     * </p>
     * 
     * @return The IP address assigned to the transit gateway multicast group.
     */
    public final String groupIpAddress() {
        return groupIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDeregisteredNetworkInterfaceIds() ? deregisteredNetworkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(groupIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastDeregisteredGroupSources)) {
            return false;
        }
        TransitGatewayMulticastDeregisteredGroupSources other = (TransitGatewayMulticastDeregisteredGroupSources) obj;
        return Objects.equals(transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId())
                && hasDeregisteredNetworkInterfaceIds() == other.hasDeregisteredNetworkInterfaceIds()
                && Objects.equals(deregisteredNetworkInterfaceIds(), other.deregisteredNetworkInterfaceIds())
                && Objects.equals(groupIpAddress(), other.groupIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("TransitGatewayMulticastDeregisteredGroupSources")
                .add("TransitGatewayMulticastDomainId", transitGatewayMulticastDomainId())
                .add("DeregisteredNetworkInterfaceIds",
                        hasDeregisteredNetworkInterfaceIds() ? deregisteredNetworkInterfaceIds() : null)
                .add("GroupIpAddress", groupIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMulticastDomainId":
            return Optional.ofNullable(clazz.cast(transitGatewayMulticastDomainId()));
        case "DeregisteredNetworkInterfaceIds":
            return Optional.ofNullable(clazz.cast(deregisteredNetworkInterfaceIds()));
        case "GroupIpAddress":
            return Optional.ofNullable(clazz.cast(groupIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayMulticastDomainId", TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD);
        map.put("DeregisteredNetworkInterfaceIds", DEREGISTERED_NETWORK_INTERFACE_IDS_FIELD);
        map.put("GroupIpAddress", GROUP_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastDeregisteredGroupSources, T> g) {
        return obj -> g.apply((TransitGatewayMulticastDeregisteredGroupSources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayMulticastDeregisteredGroupSources> {
        /**
         * <p>
         * The ID of the transit gateway multicast domain.
         * </p>
         * 
         * @param transitGatewayMulticastDomainId
         *        The ID of the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId);

        /**
         * <p>
         * The network interface IDs of the non-registered members.
         * </p>
         * 
         * @param deregisteredNetworkInterfaceIds
         *        The network interface IDs of the non-registered members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregisteredNetworkInterfaceIds(Collection<String> deregisteredNetworkInterfaceIds);

        /**
         * <p>
         * The network interface IDs of the non-registered members.
         * </p>
         * 
         * @param deregisteredNetworkInterfaceIds
         *        The network interface IDs of the non-registered members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregisteredNetworkInterfaceIds(String... deregisteredNetworkInterfaceIds);

        /**
         * <p>
         * The IP address assigned to the transit gateway multicast group.
         * </p>
         * 
         * @param groupIpAddress
         *        The IP address assigned to the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIpAddress(String groupIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayMulticastDomainId;

        private List<String> deregisteredNetworkInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private String groupIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastDeregisteredGroupSources model) {
            transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            deregisteredNetworkInterfaceIds(model.deregisteredNetworkInterfaceIds);
            groupIpAddress(model.groupIpAddress);
        }

        public final String getTransitGatewayMulticastDomainId() {
            return transitGatewayMulticastDomainId;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final Collection<String> getDeregisteredNetworkInterfaceIds() {
            if (deregisteredNetworkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return deregisteredNetworkInterfaceIds;
        }

        public final void setDeregisteredNetworkInterfaceIds(Collection<String> deregisteredNetworkInterfaceIds) {
            this.deregisteredNetworkInterfaceIds = ValueStringListCopier.copy(deregisteredNetworkInterfaceIds);
        }

        @Override
        public final Builder deregisteredNetworkInterfaceIds(Collection<String> deregisteredNetworkInterfaceIds) {
            this.deregisteredNetworkInterfaceIds = ValueStringListCopier.copy(deregisteredNetworkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deregisteredNetworkInterfaceIds(String... deregisteredNetworkInterfaceIds) {
            deregisteredNetworkInterfaceIds(Arrays.asList(deregisteredNetworkInterfaceIds));
            return this;
        }

        public final String getGroupIpAddress() {
            return groupIpAddress;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        @Override
        public TransitGatewayMulticastDeregisteredGroupSources build() {
            return new TransitGatewayMulticastDeregisteredGroupSources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
