/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.RouteServerPersistRoutesState;
import software.amazon.awssdk.services.ec2.model.RouteServerState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteServer> {
    private static final SdkField<String> ROUTE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerId").getter(RouteServer.getter(RouteServer::routeServerId)).setter(RouteServer.setter(Builder::routeServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerId").unmarshallLocationName("routeServerId").build()}).build();
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AmazonSideAsn").getter(RouteServer.getter(RouteServer::amazonSideAsn)).setter(RouteServer.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").unmarshallLocationName("amazonSideAsn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RouteServer.getter(RouteServer::stateAsString)).setter(RouteServer.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RouteServer.getter(RouteServer::tags)).setter(RouteServer.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PERSIST_ROUTES_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersistRoutesState").getter(RouteServer.getter(RouteServer::persistRoutesStateAsString)).setter(RouteServer.setter(Builder::persistRoutesState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutesState").unmarshallLocationName("persistRoutesState").build()}).build();
    private static final SdkField<Long> PERSIST_ROUTES_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PersistRoutesDuration").getter(RouteServer.getter(RouteServer::persistRoutesDuration)).setter(RouteServer.setter(Builder::persistRoutesDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistRoutesDuration").unmarshallLocationName("persistRoutesDuration").build()}).build();
    private static final SdkField<Boolean> SNS_NOTIFICATIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SnsNotificationsEnabled").getter(RouteServer.getter(RouteServer::snsNotificationsEnabled)).setter(RouteServer.setter(Builder::snsNotificationsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsNotificationsEnabled").unmarshallLocationName("snsNotificationsEnabled").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(RouteServer.getter(RouteServer::snsTopicArn)).setter(RouteServer.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").unmarshallLocationName("snsTopicArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ID_FIELD, AMAZON_SIDE_ASN_FIELD, STATE_FIELD, TAGS_FIELD, PERSIST_ROUTES_STATE_FIELD, PERSIST_ROUTES_DURATION_FIELD, SNS_NOTIFICATIONS_ENABLED_FIELD, SNS_TOPIC_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteServer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String routeServerId;
    private final Long amazonSideAsn;
    private final String state;
    private final List<Tag> tags;
    private final String persistRoutesState;
    private final Long persistRoutesDuration;
    private final Boolean snsNotificationsEnabled;
    private final String snsTopicArn;

    private RouteServer(BuilderImpl builder) {
        this.routeServerId = builder.routeServerId;
        this.amazonSideAsn = builder.amazonSideAsn;
        this.state = builder.state;
        this.tags = builder.tags;
        this.persistRoutesState = builder.persistRoutesState;
        this.persistRoutesDuration = builder.persistRoutesDuration;
        this.snsNotificationsEnabled = builder.snsNotificationsEnabled;
        this.snsTopicArn = builder.snsTopicArn;
    }

    public final String routeServerId() {
        return this.routeServerId;
    }

    public final Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public final RouteServerState state() {
        return RouteServerState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final RouteServerPersistRoutesState persistRoutesState() {
        return RouteServerPersistRoutesState.fromValue(this.persistRoutesState);
    }

    public final String persistRoutesStateAsString() {
        return this.persistRoutesState;
    }

    public final Long persistRoutesDuration() {
        return this.persistRoutesDuration;
    }

    public final Boolean snsNotificationsEnabled() {
        return this.snsNotificationsEnabled;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.persistRoutesStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistRoutesDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteServer)) {
            return false;
        }
        RouteServer other = (RouteServer)obj;
        return Objects.equals(this.routeServerId(), other.routeServerId()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.persistRoutesStateAsString(), other.persistRoutesStateAsString()) && Objects.equals(this.persistRoutesDuration(), other.persistRoutesDuration()) && Objects.equals(this.snsNotificationsEnabled(), other.snsNotificationsEnabled()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn());
    }

    public final String toString() {
        return ToString.builder((String)"RouteServer").add("RouteServerId", (Object)this.routeServerId()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("PersistRoutesState", (Object)this.persistRoutesStateAsString()).add("PersistRoutesDuration", (Object)this.persistRoutesDuration()).add("SnsNotificationsEnabled", (Object)this.snsNotificationsEnabled()).add("SnsTopicArn", (Object)this.snsTopicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServerId": {
                return Optional.ofNullable(clazz.cast(this.routeServerId()));
            }
            case "AmazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PersistRoutesState": {
                return Optional.ofNullable(clazz.cast(this.persistRoutesStateAsString()));
            }
            case "PersistRoutesDuration": {
                return Optional.ofNullable(clazz.cast(this.persistRoutesDuration()));
            }
            case "SnsNotificationsEnabled": {
                return Optional.ofNullable(clazz.cast(this.snsNotificationsEnabled()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteServerId", ROUTE_SERVER_ID_FIELD);
        map.put("AmazonSideAsn", AMAZON_SIDE_ASN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("PersistRoutesState", PERSIST_ROUTES_STATE_FIELD);
        map.put("PersistRoutesDuration", PERSIST_ROUTES_DURATION_FIELD);
        map.put("SnsNotificationsEnabled", SNS_NOTIFICATIONS_ENABLED_FIELD);
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteServer, T> g) {
        return obj -> g.apply((RouteServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String routeServerId;
        private Long amazonSideAsn;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String persistRoutesState;
        private Long persistRoutesDuration;
        private Boolean snsNotificationsEnabled;
        private String snsTopicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteServer model) {
            this.routeServerId(model.routeServerId);
            this.amazonSideAsn(model.amazonSideAsn);
            this.state(model.state);
            this.tags(model.tags);
            this.persistRoutesState(model.persistRoutesState);
            this.persistRoutesDuration(model.persistRoutesDuration);
            this.snsNotificationsEnabled(model.snsNotificationsEnabled);
            this.snsTopicArn(model.snsTopicArn);
        }

        public final String getRouteServerId() {
            return this.routeServerId;
        }

        public final void setRouteServerId(String routeServerId) {
            this.routeServerId = routeServerId;
        }

        @Override
        public final Builder routeServerId(String routeServerId) {
            this.routeServerId = routeServerId;
            return this;
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteServerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPersistRoutesState() {
            return this.persistRoutesState;
        }

        public final void setPersistRoutesState(String persistRoutesState) {
            this.persistRoutesState = persistRoutesState;
        }

        @Override
        public final Builder persistRoutesState(String persistRoutesState) {
            this.persistRoutesState = persistRoutesState;
            return this;
        }

        @Override
        public final Builder persistRoutesState(RouteServerPersistRoutesState persistRoutesState) {
            this.persistRoutesState(persistRoutesState == null ? null : persistRoutesState.toString());
            return this;
        }

        public final Long getPersistRoutesDuration() {
            return this.persistRoutesDuration;
        }

        public final void setPersistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
        }

        @Override
        public final Builder persistRoutesDuration(Long persistRoutesDuration) {
            this.persistRoutesDuration = persistRoutesDuration;
            return this;
        }

        public final Boolean getSnsNotificationsEnabled() {
            return this.snsNotificationsEnabled;
        }

        public final void setSnsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
        }

        @Override
        public final Builder snsNotificationsEnabled(Boolean snsNotificationsEnabled) {
            this.snsNotificationsEnabled = snsNotificationsEnabled;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public RouteServer build() {
            return new RouteServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteServer> {
        public Builder routeServerId(String var1);

        public Builder amazonSideAsn(Long var1);

        public Builder state(String var1);

        public Builder state(RouteServerState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder persistRoutesState(String var1);

        public Builder persistRoutesState(RouteServerPersistRoutesState var1);

        public Builder persistRoutesDuration(Long var1);

        public Builder snsNotificationsEnabled(Boolean var1);

        public Builder snsTopicArn(String var1);
    }
}

