/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet registers the running Spot Instances with
 * these Classic Load Balancers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassicLoadBalancersConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassicLoadBalancersConfig.Builder, ClassicLoadBalancersConfig> {
    private static final SdkField<List<ClassicLoadBalancer>> CLASSIC_LOAD_BALANCERS_FIELD = SdkField
            .<List<ClassicLoadBalancer>> builder(MarshallingType.LIST)
            .memberName("ClassicLoadBalancers")
            .getter(getter(ClassicLoadBalancersConfig::classicLoadBalancers))
            .setter(setter(Builder::classicLoadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLoadBalancers")
                    .unmarshallLocationName("classicLoadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ClassicLoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClassicLoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIC_LOAD_BALANCERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ClassicLoadBalancer> classicLoadBalancers;

    private ClassicLoadBalancersConfig(BuilderImpl builder) {
        this.classicLoadBalancers = builder.classicLoadBalancers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClassicLoadBalancers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClassicLoadBalancers() {
        return classicLoadBalancers != null && !(classicLoadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Classic Load Balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClassicLoadBalancers} method.
     * </p>
     * 
     * @return One or more Classic Load Balancers.
     */
    public final List<ClassicLoadBalancer> classicLoadBalancers() {
        return classicLoadBalancers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClassicLoadBalancers() ? classicLoadBalancers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassicLoadBalancersConfig)) {
            return false;
        }
        ClassicLoadBalancersConfig other = (ClassicLoadBalancersConfig) obj;
        return hasClassicLoadBalancers() == other.hasClassicLoadBalancers()
                && Objects.equals(classicLoadBalancers(), other.classicLoadBalancers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClassicLoadBalancersConfig")
                .add("ClassicLoadBalancers", hasClassicLoadBalancers() ? classicLoadBalancers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClassicLoadBalancers":
            return Optional.ofNullable(clazz.cast(classicLoadBalancers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClassicLoadBalancers", CLASSIC_LOAD_BALANCERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClassicLoadBalancersConfig, T> g) {
        return obj -> g.apply((ClassicLoadBalancersConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassicLoadBalancersConfig> {
        /**
         * <p>
         * One or more Classic Load Balancers.
         * </p>
         * 
         * @param classicLoadBalancers
         *        One or more Classic Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancers(Collection<ClassicLoadBalancer> classicLoadBalancers);

        /**
         * <p>
         * One or more Classic Load Balancers.
         * </p>
         * 
         * @param classicLoadBalancers
         *        One or more Classic Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancers(ClassicLoadBalancer... classicLoadBalancers);

        /**
         * <p>
         * One or more Classic Load Balancers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer.Builder#build()} is called immediately
         * and its result is passed to {@link #classicLoadBalancers(List<ClassicLoadBalancer>)}.
         * 
         * @param classicLoadBalancers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classicLoadBalancers(java.util.Collection<ClassicLoadBalancer>)
         */
        Builder classicLoadBalancers(Consumer<ClassicLoadBalancer.Builder>... classicLoadBalancers);
    }

    static final class BuilderImpl implements Builder {
        private List<ClassicLoadBalancer> classicLoadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClassicLoadBalancersConfig model) {
            classicLoadBalancers(model.classicLoadBalancers);
        }

        public final List<ClassicLoadBalancer.Builder> getClassicLoadBalancers() {
            List<ClassicLoadBalancer.Builder> result = ClassicLoadBalancersCopier.copyToBuilder(this.classicLoadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClassicLoadBalancers(Collection<ClassicLoadBalancer.BuilderImpl> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copyFromBuilder(classicLoadBalancers);
        }

        @Override
        public final Builder classicLoadBalancers(Collection<ClassicLoadBalancer> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copy(classicLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLoadBalancers(ClassicLoadBalancer... classicLoadBalancers) {
            classicLoadBalancers(Arrays.asList(classicLoadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLoadBalancers(Consumer<ClassicLoadBalancer.Builder>... classicLoadBalancers) {
            classicLoadBalancers(Stream.of(classicLoadBalancers).map(c -> ClassicLoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClassicLoadBalancersConfig build() {
            return new ClassicLoadBalancersConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
