/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeprovisionPublicIpv4PoolCidrResponse extends Ec2Response implements
        ToCopyableBuilder<DeprovisionPublicIpv4PoolCidrResponse.Builder, DeprovisionPublicIpv4PoolCidrResponse> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PoolId")
            .getter(getter(DeprovisionPublicIpv4PoolCidrResponse::poolId))
            .setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId")
                    .unmarshallLocationName("poolId").build()).build();

    private static final SdkField<List<String>> DEPROVISIONED_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeprovisionedAddresses")
            .getter(getter(DeprovisionPublicIpv4PoolCidrResponse::deprovisionedAddresses))
            .setter(setter(Builder::deprovisionedAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprovisionedAddressSet")
                    .unmarshallLocationName("deprovisionedAddressSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD,
            DEPROVISIONED_ADDRESSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String poolId;

    private final List<String> deprovisionedAddresses;

    private DeprovisionPublicIpv4PoolCidrResponse(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.deprovisionedAddresses = builder.deprovisionedAddresses;
    }

    /**
     * <p>
     * The ID of the pool that you deprovisioned the CIDR from.
     * </p>
     * 
     * @return The ID of the pool that you deprovisioned the CIDR from.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeprovisionedAddresses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeprovisionedAddresses() {
        return deprovisionedAddresses != null && !(deprovisionedAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The deprovisioned CIDRs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeprovisionedAddresses} method.
     * </p>
     * 
     * @return The deprovisioned CIDRs.
     */
    public final List<String> deprovisionedAddresses() {
        return deprovisionedAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeprovisionedAddresses() ? deprovisionedAddresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprovisionPublicIpv4PoolCidrResponse)) {
            return false;
        }
        DeprovisionPublicIpv4PoolCidrResponse other = (DeprovisionPublicIpv4PoolCidrResponse) obj;
        return Objects.equals(poolId(), other.poolId()) && hasDeprovisionedAddresses() == other.hasDeprovisionedAddresses()
                && Objects.equals(deprovisionedAddresses(), other.deprovisionedAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeprovisionPublicIpv4PoolCidrResponse").add("PoolId", poolId())
                .add("DeprovisionedAddresses", hasDeprovisionedAddresses() ? deprovisionedAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "DeprovisionedAddresses":
            return Optional.ofNullable(clazz.cast(deprovisionedAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolId", POOL_ID_FIELD);
        map.put("DeprovisionedAddressSet", DEPROVISIONED_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeprovisionPublicIpv4PoolCidrResponse, T> g) {
        return obj -> g.apply((DeprovisionPublicIpv4PoolCidrResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeprovisionPublicIpv4PoolCidrResponse> {
        /**
         * <p>
         * The ID of the pool that you deprovisioned the CIDR from.
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that you deprovisioned the CIDR from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The deprovisioned CIDRs.
         * </p>
         * 
         * @param deprovisionedAddresses
         *        The deprovisioned CIDRs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprovisionedAddresses(Collection<String> deprovisionedAddresses);

        /**
         * <p>
         * The deprovisioned CIDRs.
         * </p>
         * 
         * @param deprovisionedAddresses
         *        The deprovisioned CIDRs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprovisionedAddresses(String... deprovisionedAddresses);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String poolId;

        private List<String> deprovisionedAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeprovisionPublicIpv4PoolCidrResponse model) {
            super(model);
            poolId(model.poolId);
            deprovisionedAddresses(model.deprovisionedAddresses);
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Collection<String> getDeprovisionedAddresses() {
            if (deprovisionedAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return deprovisionedAddresses;
        }

        public final void setDeprovisionedAddresses(Collection<String> deprovisionedAddresses) {
            this.deprovisionedAddresses = DeprovisionedAddressSetCopier.copy(deprovisionedAddresses);
        }

        @Override
        public final Builder deprovisionedAddresses(Collection<String> deprovisionedAddresses) {
            this.deprovisionedAddresses = DeprovisionedAddressSetCopier.copy(deprovisionedAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deprovisionedAddresses(String... deprovisionedAddresses) {
            deprovisionedAddresses(Arrays.asList(deprovisionedAddresses));
            return this;
        }

        @Override
        public DeprovisionPublicIpv4PoolCidrResponse build() {
            return new DeprovisionPublicIpv4PoolCidrResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
