/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ENA Express uses Amazon Web Services Scalable Reliable Datagram (SRD) technology to increase the maximum bandwidth
 * used per stream and minimize tail latency of network traffic between EC2 instances. With ENA Express, you can
 * communicate between two EC2 instances in the same subnet within the same account, or in different accounts. Both
 * sending and receiving instances must have ENA Express enabled.
 * </p>
 * <p>
 * To improve the reliability of network packet delivery, ENA Express reorders network packets on the receiving end by
 * default. However, some UDP-based applications are designed to handle network packets that are out of order to reduce
 * the overhead for packet delivery at the network layer. When ENA Express is enabled, you can specify whether UDP
 * network traffic uses it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnaSrdSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<EnaSrdSpecification.Builder, EnaSrdSpecification> {
    private static final SdkField<Boolean> ENA_SRD_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnaSrdEnabled")
            .getter(getter(EnaSrdSpecification::enaSrdEnabled))
            .setter(setter(Builder::enaSrdEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdEnabled")
                    .unmarshallLocationName("EnaSrdEnabled").build()).build();

    private static final SdkField<EnaSrdUdpSpecification> ENA_SRD_UDP_SPECIFICATION_FIELD = SdkField
            .<EnaSrdUdpSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("EnaSrdUdpSpecification")
            .getter(getter(EnaSrdSpecification::enaSrdUdpSpecification))
            .setter(setter(Builder::enaSrdUdpSpecification))
            .constructor(EnaSrdUdpSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdUdpSpecification")
                    .unmarshallLocationName("EnaSrdUdpSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENA_SRD_ENABLED_FIELD,
            ENA_SRD_UDP_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enaSrdEnabled;

    private final EnaSrdUdpSpecification enaSrdUdpSpecification;

    private EnaSrdSpecification(BuilderImpl builder) {
        this.enaSrdEnabled = builder.enaSrdEnabled;
        this.enaSrdUdpSpecification = builder.enaSrdUdpSpecification;
    }

    /**
     * <p>
     * Indicates whether ENA Express is enabled for the network interface.
     * </p>
     * 
     * @return Indicates whether ENA Express is enabled for the network interface.
     */
    public final Boolean enaSrdEnabled() {
        return enaSrdEnabled;
    }

    /**
     * <p>
     * Configures ENA Express for UDP network traffic.
     * </p>
     * 
     * @return Configures ENA Express for UDP network traffic.
     */
    public final EnaSrdUdpSpecification enaSrdUdpSpecification() {
        return enaSrdUdpSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdUdpSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnaSrdSpecification)) {
            return false;
        }
        EnaSrdSpecification other = (EnaSrdSpecification) obj;
        return Objects.equals(enaSrdEnabled(), other.enaSrdEnabled())
                && Objects.equals(enaSrdUdpSpecification(), other.enaSrdUdpSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnaSrdSpecification").add("EnaSrdEnabled", enaSrdEnabled())
                .add("EnaSrdUdpSpecification", enaSrdUdpSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnaSrdEnabled":
            return Optional.ofNullable(clazz.cast(enaSrdEnabled()));
        case "EnaSrdUdpSpecification":
            return Optional.ofNullable(clazz.cast(enaSrdUdpSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnaSrdEnabled", ENA_SRD_ENABLED_FIELD);
        map.put("EnaSrdUdpSpecification", ENA_SRD_UDP_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnaSrdSpecification, T> g) {
        return obj -> g.apply((EnaSrdSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnaSrdSpecification> {
        /**
         * <p>
         * Indicates whether ENA Express is enabled for the network interface.
         * </p>
         * 
         * @param enaSrdEnabled
         *        Indicates whether ENA Express is enabled for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdEnabled(Boolean enaSrdEnabled);

        /**
         * <p>
         * Configures ENA Express for UDP network traffic.
         * </p>
         * 
         * @param enaSrdUdpSpecification
         *        Configures ENA Express for UDP network traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdUdpSpecification(EnaSrdUdpSpecification enaSrdUdpSpecification);

        /**
         * <p>
         * Configures ENA Express for UDP network traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnaSrdUdpSpecification.Builder} avoiding
         * the need to create one manually via {@link EnaSrdUdpSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnaSrdUdpSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #enaSrdUdpSpecification(EnaSrdUdpSpecification)}.
         * 
         * @param enaSrdUdpSpecification
         *        a consumer that will call methods on {@link EnaSrdUdpSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enaSrdUdpSpecification(EnaSrdUdpSpecification)
         */
        default Builder enaSrdUdpSpecification(Consumer<EnaSrdUdpSpecification.Builder> enaSrdUdpSpecification) {
            return enaSrdUdpSpecification(EnaSrdUdpSpecification.builder().applyMutation(enaSrdUdpSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enaSrdEnabled;

        private EnaSrdUdpSpecification enaSrdUdpSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(EnaSrdSpecification model) {
            enaSrdEnabled(model.enaSrdEnabled);
            enaSrdUdpSpecification(model.enaSrdUdpSpecification);
        }

        public final Boolean getEnaSrdEnabled() {
            return enaSrdEnabled;
        }

        public final void setEnaSrdEnabled(Boolean enaSrdEnabled) {
            this.enaSrdEnabled = enaSrdEnabled;
        }

        @Override
        public final Builder enaSrdEnabled(Boolean enaSrdEnabled) {
            this.enaSrdEnabled = enaSrdEnabled;
            return this;
        }

        public final EnaSrdUdpSpecification.Builder getEnaSrdUdpSpecification() {
            return enaSrdUdpSpecification != null ? enaSrdUdpSpecification.toBuilder() : null;
        }

        public final void setEnaSrdUdpSpecification(EnaSrdUdpSpecification.BuilderImpl enaSrdUdpSpecification) {
            this.enaSrdUdpSpecification = enaSrdUdpSpecification != null ? enaSrdUdpSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdUdpSpecification(EnaSrdUdpSpecification enaSrdUdpSpecification) {
            this.enaSrdUdpSpecification = enaSrdUdpSpecification;
            return this;
        }

        @Override
        public EnaSrdSpecification build() {
            return new EnaSrdSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
