/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a stateful rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallStatefulRule implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallStatefulRule.Builder, FirewallStatefulRule> {
    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupArn")
            .getter(getter(FirewallStatefulRule::ruleGroupArn))
            .setter(setter(Builder::ruleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn")
                    .unmarshallLocationName("ruleGroupArn").build()).build();

    private static final SdkField<List<String>> SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(FirewallStatefulRule::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSet")
                    .unmarshallLocationName("sourceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(FirewallStatefulRule::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSet")
                    .unmarshallLocationName("destinationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<PortRange>> SOURCE_PORTS_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("SourcePorts")
            .getter(getter(FirewallStatefulRule::sourcePorts))
            .setter(setter(Builder::sourcePorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortSet")
                    .unmarshallLocationName("sourcePortSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<PortRange>> DESTINATION_PORTS_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("DestinationPorts")
            .getter(getter(FirewallStatefulRule::destinationPorts))
            .setter(setter(Builder::destinationPorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortSet")
                    .unmarshallLocationName("destinationPortSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(FirewallStatefulRule::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleAction")
            .getter(getter(FirewallStatefulRule::ruleAction))
            .setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction")
                    .unmarshallLocationName("ruleAction").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Direction")
            .getter(getter(FirewallStatefulRule::direction))
            .setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction")
                    .unmarshallLocationName("direction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ARN_FIELD,
            SOURCES_FIELD, DESTINATIONS_FIELD, SOURCE_PORTS_FIELD, DESTINATION_PORTS_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD,
            DIRECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleGroupArn;

    private final List<String> sources;

    private final List<String> destinations;

    private final List<PortRange> sourcePorts;

    private final List<PortRange> destinationPorts;

    private final String protocol;

    private final String ruleAction;

    private final String direction;

    private FirewallStatefulRule(BuilderImpl builder) {
        this.ruleGroupArn = builder.ruleGroupArn;
        this.sources = builder.sources;
        this.destinations = builder.destinations;
        this.sourcePorts = builder.sourcePorts;
        this.destinationPorts = builder.destinationPorts;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.direction = builder.direction;
    }

    /**
     * <p>
     * The ARN of the stateful rule group.
     * </p>
     * 
     * @return The ARN of the stateful rule group.
     */
    public final String ruleGroupArn() {
        return ruleGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source IP addresses, in CIDR notation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The source IP addresses, in CIDR notation.
     */
    public final List<String> sources() {
        return sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination IP addresses, in CIDR notation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The destination IP addresses, in CIDR notation.
     */
    public final List<String> destinations() {
        return destinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourcePorts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourcePorts() {
        return sourcePorts != null && !(sourcePorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source ports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourcePorts} method.
     * </p>
     * 
     * @return The source ports.
     */
    public final List<PortRange> sourcePorts() {
        return sourcePorts;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationPorts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationPorts() {
        return destinationPorts != null && !(destinationPorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination ports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationPorts} method.
     * </p>
     * 
     * @return The destination ports.
     */
    public final List<PortRange> destinationPorts() {
        return destinationPorts;
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * 
     * @return The protocol.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The rule action. The possible values are <code>pass</code>, <code>drop</code>, and <code>alert</code>.
     * </p>
     * 
     * @return The rule action. The possible values are <code>pass</code>, <code>drop</code>, and <code>alert</code>.
     */
    public final String ruleAction() {
        return ruleAction;
    }

    /**
     * <p>
     * The direction. The possible values are <code>FORWARD</code> and <code>ANY</code>.
     * </p>
     * 
     * @return The direction. The possible values are <code>FORWARD</code> and <code>ANY</code>.
     */
    public final String direction() {
        return direction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourcePorts() ? sourcePorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPorts() ? destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(ruleAction());
        hashCode = 31 * hashCode + Objects.hashCode(direction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallStatefulRule)) {
            return false;
        }
        FirewallStatefulRule other = (FirewallStatefulRule) obj;
        return Objects.equals(ruleGroupArn(), other.ruleGroupArn()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations()) && hasSourcePorts() == other.hasSourcePorts()
                && Objects.equals(sourcePorts(), other.sourcePorts()) && hasDestinationPorts() == other.hasDestinationPorts()
                && Objects.equals(destinationPorts(), other.destinationPorts()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(ruleAction(), other.ruleAction()) && Objects.equals(direction(), other.direction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallStatefulRule").add("RuleGroupArn", ruleGroupArn())
                .add("Sources", hasSources() ? sources() : null).add("Destinations", hasDestinations() ? destinations() : null)
                .add("SourcePorts", hasSourcePorts() ? sourcePorts() : null)
                .add("DestinationPorts", hasDestinationPorts() ? destinationPorts() : null).add("Protocol", protocol())
                .add("RuleAction", ruleAction()).add("Direction", direction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupArn":
            return Optional.ofNullable(clazz.cast(ruleGroupArn()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "SourcePorts":
            return Optional.ofNullable(clazz.cast(sourcePorts()));
        case "DestinationPorts":
            return Optional.ofNullable(clazz.cast(destinationPorts()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleAction()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(direction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleGroupArn", RULE_GROUP_ARN_FIELD);
        map.put("SourceSet", SOURCES_FIELD);
        map.put("DestinationSet", DESTINATIONS_FIELD);
        map.put("SourcePortSet", SOURCE_PORTS_FIELD);
        map.put("DestinationPortSet", DESTINATION_PORTS_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("RuleAction", RULE_ACTION_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirewallStatefulRule, T> g) {
        return obj -> g.apply((FirewallStatefulRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallStatefulRule> {
        /**
         * <p>
         * The ARN of the stateful rule group.
         * </p>
         * 
         * @param ruleGroupArn
         *        The ARN of the stateful rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArn(String ruleGroupArn);

        /**
         * <p>
         * The source IP addresses, in CIDR notation.
         * </p>
         * 
         * @param sources
         *        The source IP addresses, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<String> sources);

        /**
         * <p>
         * The source IP addresses, in CIDR notation.
         * </p>
         * 
         * @param sources
         *        The source IP addresses, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(String... sources);

        /**
         * <p>
         * The destination IP addresses, in CIDR notation.
         * </p>
         * 
         * @param destinations
         *        The destination IP addresses, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<String> destinations);

        /**
         * <p>
         * The destination IP addresses, in CIDR notation.
         * </p>
         * 
         * @param destinations
         *        The destination IP addresses, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(String... destinations);

        /**
         * <p>
         * The source ports.
         * </p>
         * 
         * @param sourcePorts
         *        The source ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePorts(Collection<PortRange> sourcePorts);

        /**
         * <p>
         * The source ports.
         * </p>
         * 
         * @param sourcePorts
         *        The source ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePorts(PortRange... sourcePorts);

        /**
         * <p>
         * The source ports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.PortRange.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.PortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.PortRange.Builder#build()} is called immediately and its
         * result is passed to {@link #sourcePorts(List<PortRange>)}.
         * 
         * @param sourcePorts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePorts(java.util.Collection<PortRange>)
         */
        Builder sourcePorts(Consumer<PortRange.Builder>... sourcePorts);

        /**
         * <p>
         * The destination ports.
         * </p>
         * 
         * @param destinationPorts
         *        The destination ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(Collection<PortRange> destinationPorts);

        /**
         * <p>
         * The destination ports.
         * </p>
         * 
         * @param destinationPorts
         *        The destination ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(PortRange... destinationPorts);

        /**
         * <p>
         * The destination ports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.PortRange.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.PortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.PortRange.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationPorts(List<PortRange>)}.
         * 
         * @param destinationPorts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPorts(java.util.Collection<PortRange>)
         */
        Builder destinationPorts(Consumer<PortRange.Builder>... destinationPorts);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The rule action. The possible values are <code>pass</code>, <code>drop</code>, and <code>alert</code>.
         * </p>
         * 
         * @param ruleAction
         *        The rule action. The possible values are <code>pass</code>, <code>drop</code>, and <code>alert</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * The direction. The possible values are <code>FORWARD</code> and <code>ANY</code>.
         * </p>
         * 
         * @param direction
         *        The direction. The possible values are <code>FORWARD</code> and <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder direction(String direction);
    }

    static final class BuilderImpl implements Builder {
        private String ruleGroupArn;

        private List<String> sources = DefaultSdkAutoConstructList.getInstance();

        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();

        private List<PortRange> sourcePorts = DefaultSdkAutoConstructList.getInstance();

        private List<PortRange> destinationPorts = DefaultSdkAutoConstructList.getInstance();

        private String protocol;

        private String ruleAction;

        private String direction;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallStatefulRule model) {
            ruleGroupArn(model.ruleGroupArn);
            sources(model.sources);
            destinations(model.destinations);
            sourcePorts(model.sourcePorts);
            destinationPorts(model.destinationPorts);
            protocol(model.protocol);
            ruleAction(model.ruleAction);
            direction(model.direction);
        }

        public final String getRuleGroupArn() {
            return ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final Collection<String> getSources() {
            if (sources instanceof SdkAutoConstructList) {
                return null;
            }
            return sources;
        }

        public final void setSources(Collection<String> sources) {
            this.sources = ValueStringListCopier.copy(sources);
        }

        @Override
        public final Builder sources(Collection<String> sources) {
            this.sources = ValueStringListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(String... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        public final Collection<String> getDestinations() {
            if (destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = ValueStringListCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = ValueStringListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        public final List<PortRange.Builder> getSourcePorts() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.sourcePorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourcePorts(Collection<PortRange.BuilderImpl> sourcePorts) {
            this.sourcePorts = PortRangeListCopier.copyFromBuilder(sourcePorts);
        }

        @Override
        public final Builder sourcePorts(Collection<PortRange> sourcePorts) {
            this.sourcePorts = PortRangeListCopier.copy(sourcePorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(PortRange... sourcePorts) {
            sourcePorts(Arrays.asList(sourcePorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(Consumer<PortRange.Builder>... sourcePorts) {
            sourcePorts(Stream.of(sourcePorts).map(c -> PortRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PortRange.Builder> getDestinationPorts() {
            List<PortRange.Builder> result = PortRangeListCopier.copyToBuilder(this.destinationPorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationPorts(Collection<PortRange.BuilderImpl> destinationPorts) {
            this.destinationPorts = PortRangeListCopier.copyFromBuilder(destinationPorts);
        }

        @Override
        public final Builder destinationPorts(Collection<PortRange> destinationPorts) {
            this.destinationPorts = PortRangeListCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(PortRange... destinationPorts) {
            destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(Consumer<PortRange.Builder>... destinationPorts) {
            destinationPorts(Stream.of(destinationPorts).map(c -> PortRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public FirewallStatefulRule build() {
            return new FirewallStatefulRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
