/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template and overrides.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetLaunchTemplateConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetLaunchTemplateConfig.Builder, FleetLaunchTemplateConfig> {
    private static final SdkField<FleetLaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField
            .<FleetLaunchTemplateSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplateSpecification")
            .getter(getter(FleetLaunchTemplateConfig::launchTemplateSpecification))
            .setter(setter(Builder::launchTemplateSpecification))
            .constructor(FleetLaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification")
                    .unmarshallLocationName("launchTemplateSpecification").build()).build();

    private static final SdkField<List<FleetLaunchTemplateOverrides>> OVERRIDES_FIELD = SdkField
            .<List<FleetLaunchTemplateOverrides>> builder(MarshallingType.LIST)
            .memberName("Overrides")
            .getter(getter(FleetLaunchTemplateConfig::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides")
                    .unmarshallLocationName("overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<FleetLaunchTemplateOverrides> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetLaunchTemplateOverrides::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_TEMPLATE_SPECIFICATION_FIELD, OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FleetLaunchTemplateSpecification launchTemplateSpecification;

    private final List<FleetLaunchTemplateOverrides> overrides;

    private FleetLaunchTemplateConfig(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    /**
     * <p>
     * The launch template.
     * </p>
     * 
     * @return The launch template.
     */
    public final FleetLaunchTemplateSpecification launchTemplateSpecification() {
        return launchTemplateSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any parameters that you specify override the same parameters in the launch template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return Any parameters that you specify override the same parameters in the launch template.
     */
    public final List<FleetLaunchTemplateOverrides> overrides() {
        return overrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateConfig)) {
            return false;
        }
        FleetLaunchTemplateConfig other = (FleetLaunchTemplateConfig) obj;
        return Objects.equals(launchTemplateSpecification(), other.launchTemplateSpecification())
                && hasOverrides() == other.hasOverrides() && Objects.equals(overrides(), other.overrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetLaunchTemplateConfig").add("LaunchTemplateSpecification", launchTemplateSpecification())
                .add("Overrides", hasOverrides() ? overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateSpecification":
            return Optional.ofNullable(clazz.cast(launchTemplateSpecification()));
        case "Overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LaunchTemplateSpecification", LAUNCH_TEMPLATE_SPECIFICATION_FIELD);
        map.put("Overrides", OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateConfig, T> g) {
        return obj -> g.apply((FleetLaunchTemplateConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetLaunchTemplateConfig> {
        /**
         * <p>
         * The launch template.
         * </p>
         * 
         * @param launchTemplateSpecification
         *        The launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification);

        /**
         * <p>
         * The launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetLaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link FleetLaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetLaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #launchTemplateSpecification(FleetLaunchTemplateSpecification)}.
         * 
         * @param launchTemplateSpecification
         *        a consumer that will call methods on {@link FleetLaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateSpecification(FleetLaunchTemplateSpecification)
         */
        default Builder launchTemplateSpecification(Consumer<FleetLaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return launchTemplateSpecification(FleetLaunchTemplateSpecification.builder()
                    .applyMutation(launchTemplateSpecification).build());
        }

        /**
         * <p>
         * Any parameters that you specify override the same parameters in the launch template.
         * </p>
         * 
         * @param overrides
         *        Any parameters that you specify override the same parameters in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Collection<FleetLaunchTemplateOverrides> overrides);

        /**
         * <p>
         * Any parameters that you specify override the same parameters in the launch template.
         * </p>
         * 
         * @param overrides
         *        Any parameters that you specify override the same parameters in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(FleetLaunchTemplateOverrides... overrides);

        /**
         * <p>
         * Any parameters that you specify override the same parameters in the launch template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides.Builder#build()} is called
         * immediately and its result is passed to {@link #overrides(List<FleetLaunchTemplateOverrides>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(java.util.Collection<FleetLaunchTemplateOverrides>)
         */
        Builder overrides(Consumer<FleetLaunchTemplateOverrides.Builder>... overrides);
    }

    static final class BuilderImpl implements Builder {
        private FleetLaunchTemplateSpecification launchTemplateSpecification;

        private List<FleetLaunchTemplateOverrides> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateConfig model) {
            launchTemplateSpecification(model.launchTemplateSpecification);
            overrides(model.overrides);
        }

        public final FleetLaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return launchTemplateSpecification != null ? launchTemplateSpecification.toBuilder() : null;
        }

        public final void setLaunchTemplateSpecification(FleetLaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final List<FleetLaunchTemplateOverrides.Builder> getOverrides() {
            List<FleetLaunchTemplateOverrides.Builder> result = FleetLaunchTemplateOverridesListCopier
                    .copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<FleetLaunchTemplateOverrides.BuilderImpl> overrides) {
            this.overrides = FleetLaunchTemplateOverridesListCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<FleetLaunchTemplateOverrides> overrides) {
            this.overrides = FleetLaunchTemplateOverridesListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(FleetLaunchTemplateOverrides... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<FleetLaunchTemplateOverrides.Builder>... overrides) {
            overrides(Stream.of(overrides).map(c -> FleetLaunchTemplateOverrides.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FleetLaunchTemplateConfig build() {
            return new FleetLaunchTemplateConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
