/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEncryptionControl implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcEncryptionControl.Builder, VpcEncryptionControl> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(VpcEncryptionControl::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> VPC_ENCRYPTION_CONTROL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEncryptionControlId")
            .getter(getter(VpcEncryptionControl::vpcEncryptionControlId))
            .setter(setter(Builder::vpcEncryptionControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEncryptionControlId")
                    .unmarshallLocationName("vpcEncryptionControlId").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Mode")
            .getter(getter(VpcEncryptionControl::modeAsString))
            .setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode")
                    .unmarshallLocationName("mode").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(VpcEncryptionControl::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateMessage")
            .getter(getter(VpcEncryptionControl::stateMessage))
            .setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage")
                    .unmarshallLocationName("stateMessage").build()).build();

    private static final SdkField<VpcEncryptionControlExclusions> RESOURCE_EXCLUSIONS_FIELD = SdkField
            .<VpcEncryptionControlExclusions> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceExclusions")
            .getter(getter(VpcEncryptionControl::resourceExclusions))
            .setter(setter(Builder::resourceExclusions))
            .constructor(VpcEncryptionControlExclusions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceExclusions")
                    .unmarshallLocationName("resourceExclusions").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(VpcEncryptionControl::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VPC_ID_FIELD, VPC_ENCRYPTION_CONTROL_ID_FIELD, MODE_FIELD, STATE_FIELD,
                    STATE_MESSAGE_FIELD, RESOURCE_EXCLUSIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcId;

    private final String vpcEncryptionControlId;

    private final String mode;

    private final String state;

    private final String stateMessage;

    private final VpcEncryptionControlExclusions resourceExclusions;

    private final List<Tag> tags;

    private VpcEncryptionControl(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.vpcEncryptionControlId = builder.vpcEncryptionControlId;
        this.mode = builder.mode;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.resourceExclusions = builder.resourceExclusions;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the VpcId property for this object.
     * 
     * @return The value of the VpcId property for this object.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * Returns the value of the VpcEncryptionControlId property for this object.
     * 
     * @return The value of the VpcEncryptionControlId property for this object.
     */
    public final String vpcEncryptionControlId() {
        return vpcEncryptionControlId;
    }

    /**
     * Returns the value of the Mode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link VpcEncryptionControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The value of the Mode property for this object.
     * @see VpcEncryptionControlMode
     */
    public final VpcEncryptionControlMode mode() {
        return VpcEncryptionControlMode.fromValue(mode);
    }

    /**
     * Returns the value of the Mode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link VpcEncryptionControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The value of the Mode property for this object.
     * @see VpcEncryptionControlMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcEncryptionControlState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see VpcEncryptionControlState
     */
    public final VpcEncryptionControlState state() {
        return VpcEncryptionControlState.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcEncryptionControlState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see VpcEncryptionControlState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * Returns the value of the StateMessage property for this object.
     * 
     * @return The value of the StateMessage property for this object.
     */
    public final String stateMessage() {
        return stateMessage;
    }

    /**
     * Returns the value of the ResourceExclusions property for this object.
     * 
     * @return The value of the ResourceExclusions property for this object.
     */
    public final VpcEncryptionControlExclusions resourceExclusions() {
        return resourceExclusions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEncryptionControlId());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(resourceExclusions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEncryptionControl)) {
            return false;
        }
        VpcEncryptionControl other = (VpcEncryptionControl) obj;
        return Objects.equals(vpcId(), other.vpcId()) && Objects.equals(vpcEncryptionControlId(), other.vpcEncryptionControlId())
                && Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateMessage(), other.stateMessage())
                && Objects.equals(resourceExclusions(), other.resourceExclusions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEncryptionControl").add("VpcId", vpcId())
                .add("VpcEncryptionControlId", vpcEncryptionControlId()).add("Mode", modeAsString())
                .add("State", stateAsString()).add("StateMessage", stateMessage())
                .add("ResourceExclusions", resourceExclusions()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VpcEncryptionControlId":
            return Optional.ofNullable(clazz.cast(vpcEncryptionControlId()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        case "ResourceExclusions":
            return Optional.ofNullable(clazz.cast(resourceExclusions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcEncryptionControlId", VPC_ENCRYPTION_CONTROL_ID_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("ResourceExclusions", RESOURCE_EXCLUSIONS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEncryptionControl, T> g) {
        return obj -> g.apply((VpcEncryptionControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEncryptionControl> {
        /**
         * Sets the value of the VpcId property for this object.
         *
         * @param vpcId
         *        The new value for the VpcId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * Sets the value of the VpcEncryptionControlId property for this object.
         *
         * @param vpcEncryptionControlId
         *        The new value for the VpcEncryptionControlId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEncryptionControlId(String vpcEncryptionControlId);

        /**
         * Sets the value of the Mode property for this object.
         *
         * @param mode
         *        The new value for the Mode property for this object.
         * @see VpcEncryptionControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEncryptionControlMode
         */
        Builder mode(String mode);

        /**
         * Sets the value of the Mode property for this object.
         *
         * @param mode
         *        The new value for the Mode property for this object.
         * @see VpcEncryptionControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEncryptionControlMode
         */
        Builder mode(VpcEncryptionControlMode mode);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see VpcEncryptionControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEncryptionControlState
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see VpcEncryptionControlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEncryptionControlState
         */
        Builder state(VpcEncryptionControlState state);

        /**
         * Sets the value of the StateMessage property for this object.
         *
         * @param stateMessage
         *        The new value for the StateMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);

        /**
         * Sets the value of the ResourceExclusions property for this object.
         *
         * @param resourceExclusions
         *        The new value for the ResourceExclusions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceExclusions(VpcEncryptionControlExclusions resourceExclusions);

        /**
         * Sets the value of the ResourceExclusions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusions.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusions.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceExclusions(VpcEncryptionControlExclusions)}.
         * 
         * @param resourceExclusions
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceExclusions(VpcEncryptionControlExclusions)
         */
        default Builder resourceExclusions(Consumer<VpcEncryptionControlExclusions.Builder> resourceExclusions) {
            return resourceExclusions(VpcEncryptionControlExclusions.builder().applyMutation(resourceExclusions).build());
        }

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String vpcId;

        private String vpcEncryptionControlId;

        private String mode;

        private String state;

        private String stateMessage;

        private VpcEncryptionControlExclusions resourceExclusions;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEncryptionControl model) {
            vpcId(model.vpcId);
            vpcEncryptionControlId(model.vpcEncryptionControlId);
            mode(model.mode);
            state(model.state);
            stateMessage(model.stateMessage);
            resourceExclusions(model.resourceExclusions);
            tags(model.tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcEncryptionControlId() {
            return vpcEncryptionControlId;
        }

        public final void setVpcEncryptionControlId(String vpcEncryptionControlId) {
            this.vpcEncryptionControlId = vpcEncryptionControlId;
        }

        @Override
        public final Builder vpcEncryptionControlId(String vpcEncryptionControlId) {
            this.vpcEncryptionControlId = vpcEncryptionControlId;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(VpcEncryptionControlMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcEncryptionControlState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final VpcEncryptionControlExclusions.Builder getResourceExclusions() {
            return resourceExclusions != null ? resourceExclusions.toBuilder() : null;
        }

        public final void setResourceExclusions(VpcEncryptionControlExclusions.BuilderImpl resourceExclusions) {
            this.resourceExclusions = resourceExclusions != null ? resourceExclusions.build() : null;
        }

        @Override
        public final Builder resourceExclusions(VpcEncryptionControlExclusions resourceExclusions) {
            this.resourceExclusions = resourceExclusions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public VpcEncryptionControl build() {
            return new VpcEncryptionControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
