/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorSession;

public class DescribeTrafficMirrorSessionsIterable
implements SdkIterable<DescribeTrafficMirrorSessionsResponse> {
    private final Ec2Client client;
    private final DescribeTrafficMirrorSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrafficMirrorSessionsIterable(Ec2Client client, DescribeTrafficMirrorSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTrafficMirrorSessionsResponseFetcher();
    }

    public Iterator<DescribeTrafficMirrorSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrafficMirrorSession> trafficMirrorSessions() {
        Function<DescribeTrafficMirrorSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficMirrorSessions() != null) {
                return response.trafficMirrorSessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTrafficMirrorSessionsResponseFetcher
    implements SyncPageFetcher<DescribeTrafficMirrorSessionsResponse> {
        private DescribeTrafficMirrorSessionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrafficMirrorSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTrafficMirrorSessionsResponse nextPage(DescribeTrafficMirrorSessionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrafficMirrorSessionsIterable.this.client.describeTrafficMirrorSessions(DescribeTrafficMirrorSessionsIterable.this.firstRequest);
            }
            return DescribeTrafficMirrorSessionsIterable.this.client.describeTrafficMirrorSessions((DescribeTrafficMirrorSessionsRequest)((Object)DescribeTrafficMirrorSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

