/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocalGatewayVirtualInterfaceRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateLocalGatewayVirtualInterfaceRequest> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceGroupId").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::localGatewayVirtualInterfaceGroupId)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::localGatewayVirtualInterfaceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceGroupId").unmarshallLocationName("LocalGatewayVirtualInterfaceGroupId").build()}).build();
    private static final SdkField<String> OUTPOST_LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostLagId").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::outpostLagId)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::outpostLagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagId").unmarshallLocationName("OutpostLagId").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Vlan").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::vlan)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan").unmarshallLocationName("Vlan").build()}).build();
    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalAddress").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::localAddress)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::localAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress").unmarshallLocationName("LocalAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::peerAddress)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("PeerAddress").build()}).build();
    private static final SdkField<Integer> PEER_BGP_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeerBgpAsn").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::peerBgpAsn)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::peerBgpAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn").unmarshallLocationName("PeerBgpAsn").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::tagSpecifications)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::dryRun)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<Long> PEER_BGP_ASN_EXTENDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PeerBgpAsnExtended").getter(CreateLocalGatewayVirtualInterfaceRequest.getter(CreateLocalGatewayVirtualInterfaceRequest::peerBgpAsnExtended)).setter(CreateLocalGatewayVirtualInterfaceRequest.setter(Builder::peerBgpAsnExtended)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsnExtended").unmarshallLocationName("PeerBgpAsnExtended").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, OUTPOST_LAG_ID_FIELD, VLAN_FIELD, LOCAL_ADDRESS_FIELD, PEER_ADDRESS_FIELD, PEER_BGP_ASN_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD, PEER_BGP_ASN_EXTENDED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLocalGatewayVirtualInterfaceRequest.memberNameToFieldInitializer();
    private final String localGatewayVirtualInterfaceGroupId;
    private final String outpostLagId;
    private final Integer vlan;
    private final String localAddress;
    private final String peerAddress;
    private final Integer peerBgpAsn;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;
    private final Long peerBgpAsnExtended;

    private CreateLocalGatewayVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.outpostLagId = builder.outpostLagId;
        this.vlan = builder.vlan;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.peerBgpAsn = builder.peerBgpAsn;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.peerBgpAsnExtended = builder.peerBgpAsnExtended;
    }

    public final String localGatewayVirtualInterfaceGroupId() {
        return this.localGatewayVirtualInterfaceGroupId;
    }

    public final String outpostLagId() {
        return this.outpostLagId;
    }

    public final Integer vlan() {
        return this.vlan;
    }

    public final String localAddress() {
        return this.localAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final Integer peerBgpAsn() {
        return this.peerBgpAsn;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Long peerBgpAsnExtended() {
        return this.peerBgpAsnExtended;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostLagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerBgpAsnExtended());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocalGatewayVirtualInterfaceRequest)) {
            return false;
        }
        CreateLocalGatewayVirtualInterfaceRequest other = (CreateLocalGatewayVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId()) && Objects.equals(this.outpostLagId(), other.outpostLagId()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.localAddress(), other.localAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.peerBgpAsn(), other.peerBgpAsn()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.peerBgpAsnExtended(), other.peerBgpAsnExtended());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLocalGatewayVirtualInterfaceRequest").add("LocalGatewayVirtualInterfaceGroupId", (Object)this.localGatewayVirtualInterfaceGroupId()).add("OutpostLagId", (Object)this.outpostLagId()).add("Vlan", (Object)this.vlan()).add("LocalAddress", (Object)this.localAddress()).add("PeerAddress", (Object)this.peerAddress()).add("PeerBgpAsn", (Object)this.peerBgpAsn()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).add("PeerBgpAsnExtended", (Object)this.peerBgpAsnExtended()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayVirtualInterfaceGroupId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceGroupId()));
            }
            case "OutpostLagId": {
                return Optional.ofNullable(clazz.cast(this.outpostLagId()));
            }
            case "Vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "LocalAddress": {
                return Optional.ofNullable(clazz.cast(this.localAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "PeerBgpAsn": {
                return Optional.ofNullable(clazz.cast(this.peerBgpAsn()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "PeerBgpAsnExtended": {
                return Optional.ofNullable(clazz.cast(this.peerBgpAsnExtended()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocalGatewayVirtualInterfaceGroupId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD);
        map.put("OutpostLagId", OUTPOST_LAG_ID_FIELD);
        map.put("Vlan", VLAN_FIELD);
        map.put("LocalAddress", LOCAL_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("PeerBgpAsn", PEER_BGP_ASN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PeerBgpAsnExtended", PEER_BGP_ASN_EXTENDED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLocalGatewayVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((CreateLocalGatewayVirtualInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String localGatewayVirtualInterfaceGroupId;
        private String outpostLagId;
        private Integer vlan;
        private String localAddress;
        private String peerAddress;
        private Integer peerBgpAsn;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private Long peerBgpAsnExtended;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocalGatewayVirtualInterfaceRequest model) {
            super(model);
            this.localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            this.outpostLagId(model.outpostLagId);
            this.vlan(model.vlan);
            this.localAddress(model.localAddress);
            this.peerAddress(model.peerAddress);
            this.peerBgpAsn(model.peerBgpAsn);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
            this.peerBgpAsnExtended(model.peerBgpAsnExtended);
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final String getOutpostLagId() {
            return this.outpostLagId;
        }

        public final void setOutpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
        }

        @Override
        public final Builder outpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final String getLocalAddress() {
            return this.localAddress;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Integer getPeerBgpAsn() {
            return this.peerBgpAsn;
        }

        public final void setPeerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Long getPeerBgpAsnExtended() {
            return this.peerBgpAsnExtended;
        }

        public final void setPeerBgpAsnExtended(Long peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
        }

        @Override
        public final Builder peerBgpAsnExtended(Long peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocalGatewayVirtualInterfaceRequest build() {
            return new CreateLocalGatewayVirtualInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocalGatewayVirtualInterfaceRequest> {
        public Builder localGatewayVirtualInterfaceGroupId(String var1);

        public Builder outpostLagId(String var1);

        public Builder vlan(Integer var1);

        public Builder localAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder peerBgpAsn(Integer var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder peerBgpAsnExtended(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

