/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateEbsBlockDeviceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateEbsBlockDeviceRequest> {
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::encrypted)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("Encrypted").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::deleteOnTermination)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("DeleteOnTermination").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::iops)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").unmarshallLocationName("Iops").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::kmsKeyId)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("KmsKeyId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::snapshotId)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSize").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::volumeSize)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").unmarshallLocationName("VolumeSize").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::volumeTypeAsString)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").unmarshallLocationName("VolumeType").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Throughput").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::throughput)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").unmarshallLocationName("Throughput").build()}).build();
    private static final SdkField<Integer> VOLUME_INITIALIZATION_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeInitializationRate").getter(LaunchTemplateEbsBlockDeviceRequest.getter(LaunchTemplateEbsBlockDeviceRequest::volumeInitializationRate)).setter(LaunchTemplateEbsBlockDeviceRequest.setter(Builder::volumeInitializationRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeInitializationRate").unmarshallLocationName("VolumeInitializationRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_FIELD, DELETE_ON_TERMINATION_FIELD, IOPS_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ID_FIELD, VOLUME_SIZE_FIELD, VOLUME_TYPE_FIELD, THROUGHPUT_FIELD, VOLUME_INITIALIZATION_RATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchTemplateEbsBlockDeviceRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean encrypted;
    private final Boolean deleteOnTermination;
    private final Integer iops;
    private final String kmsKeyId;
    private final String snapshotId;
    private final Integer volumeSize;
    private final String volumeType;
    private final Integer throughput;
    private final Integer volumeInitializationRate;

    private LaunchTemplateEbsBlockDeviceRequest(BuilderImpl builder) {
        this.encrypted = builder.encrypted;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
        this.throughput = builder.throughput;
        this.volumeInitializationRate = builder.volumeInitializationRate;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Integer volumeSize() {
        return this.volumeSize;
    }

    public final VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final Integer throughput() {
        return this.throughput;
    }

    public final Integer volumeInitializationRate() {
        return this.volumeInitializationRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeInitializationRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateEbsBlockDeviceRequest)) {
            return false;
        }
        LaunchTemplateEbsBlockDeviceRequest other = (LaunchTemplateEbsBlockDeviceRequest)obj;
        return Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.throughput(), other.throughput()) && Objects.equals(this.volumeInitializationRate(), other.volumeInitializationRate());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateEbsBlockDeviceRequest").add("Encrypted", (Object)this.encrypted()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("Iops", (Object)this.iops()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SnapshotId", (Object)this.snapshotId()).add("VolumeSize", (Object)this.volumeSize()).add("VolumeType", (Object)this.volumeTypeAsString()).add("Throughput", (Object)this.throughput()).add("VolumeInitializationRate", (Object)this.volumeInitializationRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "Throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
            case "VolumeInitializationRate": {
                return Optional.ofNullable(clazz.cast(this.volumeInitializationRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("VolumeInitializationRate", VOLUME_INITIALIZATION_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateEbsBlockDeviceRequest, T> g) {
        return obj -> g.apply((LaunchTemplateEbsBlockDeviceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean encrypted;
        private Boolean deleteOnTermination;
        private Integer iops;
        private String kmsKeyId;
        private String snapshotId;
        private Integer volumeSize;
        private String volumeType;
        private Integer throughput;
        private Integer volumeInitializationRate;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateEbsBlockDeviceRequest model) {
            this.encrypted(model.encrypted);
            this.deleteOnTermination(model.deleteOnTermination);
            this.iops(model.iops);
            this.kmsKeyId(model.kmsKeyId);
            this.snapshotId(model.snapshotId);
            this.volumeSize(model.volumeSize);
            this.volumeType(model.volumeType);
            this.throughput(model.throughput);
            this.volumeInitializationRate(model.volumeInitializationRate);
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Integer getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final Integer getVolumeInitializationRate() {
            return this.volumeInitializationRate;
        }

        public final void setVolumeInitializationRate(Integer volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
        }

        @Override
        public final Builder volumeInitializationRate(Integer volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
            return this;
        }

        public LaunchTemplateEbsBlockDeviceRequest build() {
            return new LaunchTemplateEbsBlockDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateEbsBlockDeviceRequest> {
        public Builder encrypted(Boolean var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder iops(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder snapshotId(String var1);

        public Builder volumeSize(Integer var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder throughput(Integer var1);

        public Builder volumeInitializationRate(Integer var1);
    }
}

