/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a parameter used to set up an EBS volume in a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsInstanceBlockDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsInstanceBlockDevice.Builder, EbsInstanceBlockDevice> {
    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AttachTime")
            .getter(getter(EbsInstanceBlockDevice::attachTime))
            .setter(setter(Builder::attachTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime")
                    .unmarshallLocationName("attachTime").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(EbsInstanceBlockDevice::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("deleteOnTermination").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(EbsInstanceBlockDevice::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(EbsInstanceBlockDevice::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResource")
            .getter(getter(EbsInstanceBlockDevice::associatedResource))
            .setter(setter(Builder::associatedResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResource")
                    .unmarshallLocationName("associatedResource").build()).build();

    private static final SdkField<String> VOLUME_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeOwnerId")
            .getter(getter(EbsInstanceBlockDevice::volumeOwnerId))
            .setter(setter(Builder::volumeOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeOwnerId")
                    .unmarshallLocationName("volumeOwnerId").build()).build();

    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField
            .<OperatorResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Operator")
            .getter(getter(EbsInstanceBlockDevice::operator))
            .setter(setter(Builder::operator))
            .constructor(OperatorResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator")
                    .unmarshallLocationName("operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACH_TIME_FIELD,
            DELETE_ON_TERMINATION_FIELD, STATUS_FIELD, VOLUME_ID_FIELD, ASSOCIATED_RESOURCE_FIELD, VOLUME_OWNER_ID_FIELD,
            OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant attachTime;

    private final Boolean deleteOnTermination;

    private final String status;

    private final String volumeId;

    private final String associatedResource;

    private final String volumeOwnerId;

    private final OperatorResponse operator;

    private EbsInstanceBlockDevice(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.status = builder.status;
        this.volumeId = builder.volumeId;
        this.associatedResource = builder.associatedResource;
        this.volumeOwnerId = builder.volumeOwnerId;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The time stamp when the attachment initiated.
     * </p>
     * 
     * @return The time stamp when the attachment initiated.
     */
    public final Instant attachTime() {
        return attachTime;
    }

    /**
     * <p>
     * Indicates whether the volume is deleted on instance termination.
     * </p>
     * 
     * @return Indicates whether the volume is deleted on instance termination.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The attachment state.
     * @see AttachmentStatus
     */
    public final AttachmentStatus status() {
        return AttachmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The attachment state.
     * @see AttachmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the EBS volume.
     * </p>
     * 
     * @return The ID of the EBS volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The ARN of the Amazon ECS or Fargate task to which the volume is attached.
     * </p>
     * 
     * @return The ARN of the Amazon ECS or Fargate task to which the volume is attached.
     */
    public final String associatedResource() {
        return associatedResource;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the volume.
     * </p>
     * <p>
     * This parameter is returned only for volumes that are attached to Fargate tasks.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the volume.</p>
     *         <p>
     *         This parameter is returned only for volumes that are attached to Fargate tasks.
     */
    public final String volumeOwnerId() {
        return volumeOwnerId;
    }

    /**
     * <p>
     * The service provider that manages the EBS volume.
     * </p>
     * 
     * @return The service provider that manages the EBS volume.
     */
    public final OperatorResponse operator() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResource());
        hashCode = 31 * hashCode + Objects.hashCode(volumeOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInstanceBlockDevice)) {
            return false;
        }
        EbsInstanceBlockDevice other = (EbsInstanceBlockDevice) obj;
        return Objects.equals(attachTime(), other.attachTime())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(associatedResource(), other.associatedResource())
                && Objects.equals(volumeOwnerId(), other.volumeOwnerId()) && Objects.equals(operator(), other.operator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsInstanceBlockDevice").add("AttachTime", attachTime())
                .add("DeleteOnTermination", deleteOnTermination()).add("Status", statusAsString()).add("VolumeId", volumeId())
                .add("AssociatedResource", associatedResource()).add("VolumeOwnerId", volumeOwnerId())
                .add("Operator", operator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachTime":
            return Optional.ofNullable(clazz.cast(attachTime()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "AssociatedResource":
            return Optional.ofNullable(clazz.cast(associatedResource()));
        case "VolumeOwnerId":
            return Optional.ofNullable(clazz.cast(volumeOwnerId()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachTime", ATTACH_TIME_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("AssociatedResource", ASSOCIATED_RESOURCE_FIELD);
        map.put("VolumeOwnerId", VOLUME_OWNER_ID_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EbsInstanceBlockDevice, T> g) {
        return obj -> g.apply((EbsInstanceBlockDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsInstanceBlockDevice> {
        /**
         * <p>
         * The time stamp when the attachment initiated.
         * </p>
         * 
         * @param attachTime
         *        The time stamp when the attachment initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(Instant attachTime);

        /**
         * <p>
         * Indicates whether the volume is deleted on instance termination.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the volume is deleted on instance termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The attachment state.
         * </p>
         * 
         * @param status
         *        The attachment state.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The attachment state.
         * </p>
         * 
         * @param status
         *        The attachment state.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(AttachmentStatus status);

        /**
         * <p>
         * The ID of the EBS volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The ARN of the Amazon ECS or Fargate task to which the volume is attached.
         * </p>
         * 
         * @param associatedResource
         *        The ARN of the Amazon ECS or Fargate task to which the volume is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResource(String associatedResource);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the volume.
         * </p>
         * <p>
         * This parameter is returned only for volumes that are attached to Fargate tasks.
         * </p>
         * 
         * @param volumeOwnerId
         *        The ID of the Amazon Web Services account that owns the volume.</p>
         *        <p>
         *        This parameter is returned only for volumes that are attached to Fargate tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeOwnerId(String volumeOwnerId);

        /**
         * <p>
         * The service provider that manages the EBS volume.
         * </p>
         * 
         * @param operator
         *        The service provider that manages the EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(OperatorResponse operator);

        /**
         * <p>
         * The service provider that manages the EBS volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link OperatorResponse.Builder} avoiding the
         * need to create one manually via {@link OperatorResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OperatorResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #operator(OperatorResponse)}.
         * 
         * @param operator
         *        a consumer that will call methods on {@link OperatorResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operator(OperatorResponse)
         */
        default Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return operator(OperatorResponse.builder().applyMutation(operator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant attachTime;

        private Boolean deleteOnTermination;

        private String status;

        private String volumeId;

        private String associatedResource;

        private String volumeOwnerId;

        private OperatorResponse operator;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInstanceBlockDevice model) {
            attachTime(model.attachTime);
            deleteOnTermination(model.deleteOnTermination);
            status(model.status);
            volumeId(model.volumeId);
            associatedResource(model.associatedResource);
            volumeOwnerId(model.volumeOwnerId);
            operator(model.operator);
        }

        public final Instant getAttachTime() {
            return attachTime;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getAssociatedResource() {
            return associatedResource;
        }

        public final void setAssociatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
        }

        @Override
        public final Builder associatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
            return this;
        }

        public final String getVolumeOwnerId() {
            return volumeOwnerId;
        }

        public final void setVolumeOwnerId(String volumeOwnerId) {
            this.volumeOwnerId = volumeOwnerId;
        }

        @Override
        public final Builder volumeOwnerId(String volumeOwnerId) {
            this.volumeOwnerId = volumeOwnerId;
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return operator != null ? operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public EbsInstanceBlockDevice build() {
            return new EbsInstanceBlockDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
