/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServersResponse;
import software.amazon.awssdk.services.ec2.model.RouteServer;

public class DescribeRouteServersIterable
implements SdkIterable<DescribeRouteServersResponse> {
    private final Ec2Client client;
    private final DescribeRouteServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRouteServersIterable(Ec2Client client, DescribeRouteServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRouteServersResponseFetcher();
    }

    public Iterator<DescribeRouteServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RouteServer> routeServers() {
        Function<DescribeRouteServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.routeServers() != null) {
                return response.routeServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRouteServersResponseFetcher
    implements SyncPageFetcher<DescribeRouteServersResponse> {
        private DescribeRouteServersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRouteServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRouteServersResponse nextPage(DescribeRouteServersResponse previousPage) {
            if (previousPage == null) {
                return DescribeRouteServersIterable.this.client.describeRouteServers(DescribeRouteServersIterable.this.firstRequest);
            }
            return DescribeRouteServersIterable.this.client.describeRouteServers((DescribeRouteServersRequest)((Object)DescribeRouteServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

