/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersConfig;
import software.amazon.awssdk.services.ec2.model.TargetGroupsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancersConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancersConfig> {
    private static final SdkField<ClassicLoadBalancersConfig> CLASSIC_LOAD_BALANCERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClassicLoadBalancersConfig").getter(LoadBalancersConfig.getter(LoadBalancersConfig::classicLoadBalancersConfig)).setter(LoadBalancersConfig.setter(Builder::classicLoadBalancersConfig)).constructor(ClassicLoadBalancersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLoadBalancersConfig").unmarshallLocationName("classicLoadBalancersConfig").build()}).build();
    private static final SdkField<TargetGroupsConfig> TARGET_GROUPS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetGroupsConfig").getter(LoadBalancersConfig.getter(LoadBalancersConfig::targetGroupsConfig)).setter(LoadBalancersConfig.setter(Builder::targetGroupsConfig)).constructor(TargetGroupsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupsConfig").unmarshallLocationName("targetGroupsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIC_LOAD_BALANCERS_CONFIG_FIELD, TARGET_GROUPS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoadBalancersConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ClassicLoadBalancersConfig classicLoadBalancersConfig;
    private final TargetGroupsConfig targetGroupsConfig;

    private LoadBalancersConfig(BuilderImpl builder) {
        this.classicLoadBalancersConfig = builder.classicLoadBalancersConfig;
        this.targetGroupsConfig = builder.targetGroupsConfig;
    }

    public final ClassicLoadBalancersConfig classicLoadBalancersConfig() {
        return this.classicLoadBalancersConfig;
    }

    public final TargetGroupsConfig targetGroupsConfig() {
        return this.targetGroupsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.classicLoadBalancersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancersConfig)) {
            return false;
        }
        LoadBalancersConfig other = (LoadBalancersConfig)obj;
        return Objects.equals(this.classicLoadBalancersConfig(), other.classicLoadBalancersConfig()) && Objects.equals(this.targetGroupsConfig(), other.targetGroupsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancersConfig").add("ClassicLoadBalancersConfig", (Object)this.classicLoadBalancersConfig()).add("TargetGroupsConfig", (Object)this.targetGroupsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClassicLoadBalancersConfig": {
                return Optional.ofNullable(clazz.cast(this.classicLoadBalancersConfig()));
            }
            case "TargetGroupsConfig": {
                return Optional.ofNullable(clazz.cast(this.targetGroupsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClassicLoadBalancersConfig", CLASSIC_LOAD_BALANCERS_CONFIG_FIELD);
        map.put("TargetGroupsConfig", TARGET_GROUPS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancersConfig, T> g) {
        return obj -> g.apply((LoadBalancersConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ClassicLoadBalancersConfig classicLoadBalancersConfig;
        private TargetGroupsConfig targetGroupsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancersConfig model) {
            this.classicLoadBalancersConfig(model.classicLoadBalancersConfig);
            this.targetGroupsConfig(model.targetGroupsConfig);
        }

        public final ClassicLoadBalancersConfig.Builder getClassicLoadBalancersConfig() {
            return this.classicLoadBalancersConfig != null ? this.classicLoadBalancersConfig.toBuilder() : null;
        }

        public final void setClassicLoadBalancersConfig(ClassicLoadBalancersConfig.BuilderImpl classicLoadBalancersConfig) {
            this.classicLoadBalancersConfig = classicLoadBalancersConfig != null ? classicLoadBalancersConfig.build() : null;
        }

        @Override
        public final Builder classicLoadBalancersConfig(ClassicLoadBalancersConfig classicLoadBalancersConfig) {
            this.classicLoadBalancersConfig = classicLoadBalancersConfig;
            return this;
        }

        public final TargetGroupsConfig.Builder getTargetGroupsConfig() {
            return this.targetGroupsConfig != null ? this.targetGroupsConfig.toBuilder() : null;
        }

        public final void setTargetGroupsConfig(TargetGroupsConfig.BuilderImpl targetGroupsConfig) {
            this.targetGroupsConfig = targetGroupsConfig != null ? targetGroupsConfig.build() : null;
        }

        @Override
        public final Builder targetGroupsConfig(TargetGroupsConfig targetGroupsConfig) {
            this.targetGroupsConfig = targetGroupsConfig;
            return this;
        }

        public LoadBalancersConfig build() {
            return new LoadBalancersConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancersConfig> {
        public Builder classicLoadBalancersConfig(ClassicLoadBalancersConfig var1);

        default public Builder classicLoadBalancersConfig(Consumer<ClassicLoadBalancersConfig.Builder> classicLoadBalancersConfig) {
            return this.classicLoadBalancersConfig((ClassicLoadBalancersConfig)((ClassicLoadBalancersConfig.Builder)ClassicLoadBalancersConfig.builder().applyMutation(classicLoadBalancersConfig)).build());
        }

        public Builder targetGroupsConfig(TargetGroupsConfig var1);

        default public Builder targetGroupsConfig(Consumer<TargetGroupsConfig.Builder> targetGroupsConfig) {
            return this.targetGroupsConfig((TargetGroupsConfig)((TargetGroupsConfig.Builder)TargetGroupsConfig.builder().applyMutation(targetGroupsConfig)).build());
        }
    }
}

