/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachVerifiedAccessTrustProviderRequest extends Ec2Request implements
        ToCopyableBuilder<AttachVerifiedAccessTrustProviderRequest.Builder, AttachVerifiedAccessTrustProviderRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessInstanceId")
            .getter(getter(AttachVerifiedAccessTrustProviderRequest::verifiedAccessInstanceId))
            .setter(setter(Builder::verifiedAccessInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId")
                    .unmarshallLocationName("VerifiedAccessInstanceId").build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessTrustProviderId")
            .getter(getter(AttachVerifiedAccessTrustProviderRequest::verifiedAccessTrustProviderId))
            .setter(setter(Builder::verifiedAccessTrustProviderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderId")
                    .unmarshallLocationName("VerifiedAccessTrustProviderId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(AttachVerifiedAccessTrustProviderRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(AttachVerifiedAccessTrustProviderRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_INSTANCE_ID_FIELD, VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String verifiedAccessInstanceId;

    private final String verifiedAccessTrustProviderId;

    private final String clientToken;

    private final Boolean dryRun;

    private AttachVerifiedAccessTrustProviderRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.verifiedAccessTrustProviderId = builder.verifiedAccessTrustProviderId;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the Verified Access instance.
     * </p>
     * 
     * @return The ID of the Verified Access instance.
     */
    public final String verifiedAccessInstanceId() {
        return verifiedAccessInstanceId;
    }

    /**
     * <p>
     * The ID of the Verified Access trust provider.
     * </p>
     * 
     * @return The ID of the Verified Access trust provider.
     */
    public final String verifiedAccessTrustProviderId() {
        return verifiedAccessTrustProviderId;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessTrustProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVerifiedAccessTrustProviderRequest)) {
            return false;
        }
        AttachVerifiedAccessTrustProviderRequest other = (AttachVerifiedAccessTrustProviderRequest) obj;
        return Objects.equals(verifiedAccessInstanceId(), other.verifiedAccessInstanceId())
                && Objects.equals(verifiedAccessTrustProviderId(), other.verifiedAccessTrustProviderId())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachVerifiedAccessTrustProviderRequest")
                .add("VerifiedAccessInstanceId", verifiedAccessInstanceId())
                .add("VerifiedAccessTrustProviderId", verifiedAccessTrustProviderId()).add("ClientToken", clientToken())
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessInstanceId":
            return Optional.ofNullable(clazz.cast(verifiedAccessInstanceId()));
        case "VerifiedAccessTrustProviderId":
            return Optional.ofNullable(clazz.cast(verifiedAccessTrustProviderId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
        map.put("VerifiedAccessTrustProviderId", VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachVerifiedAccessTrustProviderRequest, T> g) {
        return obj -> g.apply((AttachVerifiedAccessTrustProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, AttachVerifiedAccessTrustProviderRequest> {
        /**
         * <p>
         * The ID of the Verified Access instance.
         * </p>
         * 
         * @param verifiedAccessInstanceId
         *        The ID of the Verified Access instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessInstanceId(String verifiedAccessInstanceId);

        /**
         * <p>
         * The ID of the Verified Access trust provider.
         * </p>
         * 
         * @param verifiedAccessTrustProviderId
         *        The ID of the Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure idempotency of your modification request.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String verifiedAccessInstanceId;

        private String verifiedAccessTrustProviderId;

        private String clientToken;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVerifiedAccessTrustProviderRequest model) {
            super(model);
            verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            verifiedAccessTrustProviderId(model.verifiedAccessTrustProviderId);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
        }

        public final String getVerifiedAccessInstanceId() {
            return verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getVerifiedAccessTrustProviderId() {
            return verifiedAccessTrustProviderId;
        }

        public final void setVerifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
        }

        @Override
        public final Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachVerifiedAccessTrustProviderRequest build() {
            return new AttachVerifiedAccessTrustProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
