/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotResponse extends Ec2Response implements
        ToCopyableBuilder<CreateSnapshotResponse.Builder, CreateSnapshotResponse> {
    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerAlias")
            .getter(getter(CreateSnapshotResponse::ownerAlias))
            .setter(setter(Builder::ownerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias")
                    .unmarshallLocationName("ownerAlias").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(CreateSnapshotResponse::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateSnapshotResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STORAGE_TIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StorageTier")
            .getter(getter(CreateSnapshotResponse::storageTierAsString))
            .setter(setter(Builder::storageTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTier")
                    .unmarshallLocationName("storageTier").build()).build();

    private static final SdkField<Instant> RESTORE_EXPIRY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RestoreExpiryTime")
            .getter(getter(CreateSnapshotResponse::restoreExpiryTime))
            .setter(setter(Builder::restoreExpiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreExpiryTime")
                    .unmarshallLocationName("restoreExpiryTime").build()).build();

    private static final SdkField<String> SSE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SseType")
            .getter(getter(CreateSnapshotResponse::sseTypeAsString))
            .setter(setter(Builder::sseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseType")
                    .unmarshallLocationName("sseType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CreateSnapshotResponse::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> TRANSFER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransferType")
            .getter(getter(CreateSnapshotResponse::transferTypeAsString))
            .setter(setter(Builder::transferType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferType")
                    .unmarshallLocationName("transferType").build()).build();

    private static final SdkField<Integer> COMPLETION_DURATION_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompletionDurationMinutes")
            .getter(getter(CreateSnapshotResponse::completionDurationMinutes))
            .setter(setter(Builder::completionDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDurationMinutes")
                    .unmarshallLocationName("completionDurationMinutes").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime")
            .getter(getter(CreateSnapshotResponse::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime")
                    .unmarshallLocationName("completionTime").build()).build();

    private static final SdkField<Long> FULL_SNAPSHOT_SIZE_IN_BYTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("FullSnapshotSizeInBytes")
            .getter(getter(CreateSnapshotResponse::fullSnapshotSizeInBytes))
            .setter(setter(Builder::fullSnapshotSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullSnapshotSizeInBytes")
                    .unmarshallLocationName("fullSnapshotSizeInBytes").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(CreateSnapshotResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(CreateSnapshotResponse::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(CreateSnapshotResponse::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateMessage")
            .getter(getter(CreateSnapshotResponse::stateMessage))
            .setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(CreateSnapshotResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Progress")
            .getter(getter(CreateSnapshotResponse::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(CreateSnapshotResponse::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateSnapshotResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize")
            .getter(getter(CreateSnapshotResponse::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize")
                    .unmarshallLocationName("volumeSize").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(CreateSnapshotResponse::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(CreateSnapshotResponse::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("kmsKeyId").build()).build();

    private static final SdkField<String> DATA_ENCRYPTION_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataEncryptionKeyId")
            .getter(getter(CreateSnapshotResponse::dataEncryptionKeyId))
            .setter(setter(Builder::dataEncryptionKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEncryptionKeyId")
                    .unmarshallLocationName("dataEncryptionKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ALIAS_FIELD,
            OUTPOST_ARN_FIELD, TAGS_FIELD, STORAGE_TIER_FIELD, RESTORE_EXPIRY_TIME_FIELD, SSE_TYPE_FIELD,
            AVAILABILITY_ZONE_FIELD, TRANSFER_TYPE_FIELD, COMPLETION_DURATION_MINUTES_FIELD, COMPLETION_TIME_FIELD,
            FULL_SNAPSHOT_SIZE_IN_BYTES_FIELD, SNAPSHOT_ID_FIELD, VOLUME_ID_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD,
            START_TIME_FIELD, PROGRESS_FIELD, OWNER_ID_FIELD, DESCRIPTION_FIELD, VOLUME_SIZE_FIELD, ENCRYPTED_FIELD,
            KMS_KEY_ID_FIELD, DATA_ENCRYPTION_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ownerAlias;

    private final String outpostArn;

    private final List<Tag> tags;

    private final String storageTier;

    private final Instant restoreExpiryTime;

    private final String sseType;

    private final String availabilityZone;

    private final String transferType;

    private final Integer completionDurationMinutes;

    private final Instant completionTime;

    private final Long fullSnapshotSizeInBytes;

    private final String snapshotId;

    private final String volumeId;

    private final String state;

    private final String stateMessage;

    private final Instant startTime;

    private final String progress;

    private final String ownerId;

    private final String description;

    private final Integer volumeSize;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String dataEncryptionKeyId;

    private CreateSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAlias = builder.ownerAlias;
        this.outpostArn = builder.outpostArn;
        this.tags = builder.tags;
        this.storageTier = builder.storageTier;
        this.restoreExpiryTime = builder.restoreExpiryTime;
        this.sseType = builder.sseType;
        this.availabilityZone = builder.availabilityZone;
        this.transferType = builder.transferType;
        this.completionDurationMinutes = builder.completionDurationMinutes;
        this.completionTime = builder.completionTime;
        this.fullSnapshotSizeInBytes = builder.fullSnapshotSizeInBytes;
        this.snapshotId = builder.snapshotId;
        this.volumeId = builder.volumeId;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.startTime = builder.startTime;
        this.progress = builder.progress;
        this.ownerId = builder.ownerId;
        this.description = builder.description;
        this.volumeSize = builder.volumeSize;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dataEncryptionKeyId = builder.dataEncryptionKeyId;
    }

    /**
     * <p>
     * The Amazon Web Services owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the
     * user-configured Amazon Web Services account alias set using the IAM console.
     * </p>
     * 
     * @return The Amazon Web Services owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not
     *         the user-configured Amazon Web Services account alias set using the IAM console.
     */
    public final String ownerAlias() {
        return ownerAlias;
    }

    /**
     * <p>
     * The ARN of the Outpost on which the snapshot is stored. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local snapshots on
     * Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @return The ARN of the Outpost on which the snapshot is stored. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local
     *         snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the snapshot.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is stored in
     * the standard snapshot storage tier and that it is ready for use. <code>archive</code> indicates that the snapshot
     * is currently archived and that it must be restored before it can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageTier} will
     * return {@link StorageTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTierAsString}.
     * </p>
     * 
     * @return The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is
     *         stored in the standard snapshot storage tier and that it is ready for use. <code>archive</code> indicates
     *         that the snapshot is currently archived and that it must be restored before it can be used.
     * @see StorageTier
     */
    public final StorageTier storageTier() {
        return StorageTier.fromValue(storageTier);
    }

    /**
     * <p>
     * The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is stored in
     * the standard snapshot storage tier and that it is ready for use. <code>archive</code> indicates that the snapshot
     * is currently archived and that it must be restored before it can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageTier} will
     * return {@link StorageTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTierAsString}.
     * </p>
     * 
     * @return The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is
     *         stored in the standard snapshot storage tier and that it is ready for use. <code>archive</code> indicates
     *         that the snapshot is currently archived and that it must be restored before it can be used.
     * @see StorageTier
     */
    public final String storageTierAsString() {
        return storageTier;
    }

    /**
     * <p>
     * Only for archived snapshots that are temporarily restored. Indicates the date and time when a temporarily
     * restored snapshot will be automatically re-archived.
     * </p>
     * 
     * @return Only for archived snapshots that are temporarily restored. Indicates the date and time when a temporarily
     *         restored snapshot will be automatically re-archived.
     */
    public final Instant restoreExpiryTime() {
        return restoreExpiryTime;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Reserved for future use.
     * @see SSEType
     */
    public final SSEType sseType() {
        return SSEType.fromValue(sseType);
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Reserved for future use.
     * @see SSEType
     */
    public final String sseTypeAsString() {
        return sseType;
    }

    /**
     * <p>
     * The Availability Zone or Local Zone of the snapshot. For example, <code>us-west-1a</code> (Availability Zone) or
     * <code>us-west-2-lax-1a</code> (Local Zone).
     * </p>
     * 
     * @return The Availability Zone or Local Zone of the snapshot. For example, <code>us-west-1a</code> (Availability
     *         Zone) or <code>us-west-2-lax-1a</code> (Local Zone).
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <note>
     * <p>
     * Only for snapshot copies.
     * </p>
     * </note>
     * <p>
     * Indicates whether the snapshot copy was created with a standard or time-based snapshot copy operation. Time-based
     * snapshot copy operations complete within the completion duration specified in the request. Standard snapshot copy
     * operations are completed on a best-effort basis.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>standard</code> - The snapshot copy was created with a standard snapshot copy operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>time-based</code> - The snapshot copy was created with a time-based snapshot copy operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferType} will
     * return {@link TransferType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transferTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         Only for snapshot copies.
     *         </p>
     *         </note>
     *         <p>
     *         Indicates whether the snapshot copy was created with a standard or time-based snapshot copy operation.
     *         Time-based snapshot copy operations complete within the completion duration specified in the request.
     *         Standard snapshot copy operations are completed on a best-effort basis.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>standard</code> - The snapshot copy was created with a standard snapshot copy operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>time-based</code> - The snapshot copy was created with a time-based snapshot copy operation.
     *         </p>
     *         </li>
     * @see TransferType
     */
    public final TransferType transferType() {
        return TransferType.fromValue(transferType);
    }

    /**
     * <note>
     * <p>
     * Only for snapshot copies.
     * </p>
     * </note>
     * <p>
     * Indicates whether the snapshot copy was created with a standard or time-based snapshot copy operation. Time-based
     * snapshot copy operations complete within the completion duration specified in the request. Standard snapshot copy
     * operations are completed on a best-effort basis.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>standard</code> - The snapshot copy was created with a standard snapshot copy operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>time-based</code> - The snapshot copy was created with a time-based snapshot copy operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferType} will
     * return {@link TransferType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transferTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         Only for snapshot copies.
     *         </p>
     *         </note>
     *         <p>
     *         Indicates whether the snapshot copy was created with a standard or time-based snapshot copy operation.
     *         Time-based snapshot copy operations complete within the completion duration specified in the request.
     *         Standard snapshot copy operations are completed on a best-effort basis.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>standard</code> - The snapshot copy was created with a standard snapshot copy operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>time-based</code> - The snapshot copy was created with a time-based snapshot copy operation.
     *         </p>
     *         </li>
     * @see TransferType
     */
    public final String transferTypeAsString() {
        return transferType;
    }

    /**
     * <note>
     * <p>
     * Only for snapshot copies created with time-based snapshot copy operations.
     * </p>
     * </note>
     * <p>
     * The completion duration requested for the time-based snapshot copy operation.
     * </p>
     * 
     * @return <p>
     *         Only for snapshot copies created with time-based snapshot copy operations.
     *         </p>
     *         </note>
     *         <p>
     *         The completion duration requested for the time-based snapshot copy operation.
     */
    public final Integer completionDurationMinutes() {
        return completionDurationMinutes;
    }

    /**
     * <p>
     * The time stamp when the snapshot was completed.
     * </p>
     * 
     * @return The time stamp when the snapshot was completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The full size of the snapshot, in bytes.
     * </p>
     * <important>
     * <p>
     * This is <b>not</b> the incremental size of the snapshot. This is the full snapshot size and represents the size
     * of all the blocks that were written to the source volume at the time the snapshot was created.
     * </p>
     * </important>
     * 
     * @return The full size of the snapshot, in bytes.</p> <important>
     *         <p>
     *         This is <b>not</b> the incremental size of the snapshot. This is the full snapshot size and represents
     *         the size of all the blocks that were written to the source volume at the time the snapshot was created.
     *         </p>
     */
    public final Long fullSnapshotSizeInBytes() {
        return fullSnapshotSizeInBytes;
    }

    /**
     * <p>
     * The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
     * </p>
     * 
     * @return The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a> action
     * have an arbitrary volume ID that should not be used for any purpose.
     * </p>
     * 
     * @return The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a>
     *         action have an arbitrary volume ID that should not be used for any purpose.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The snapshot state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The snapshot state.
     * @see SnapshotState
     */
    public final SnapshotState state() {
        return SnapshotState.fromValue(state);
    }

    /**
     * <p>
     * The snapshot state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The snapshot state.
     * @see SnapshotState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if the
     * proper KMS permissions are not obtained) this field displays error state details to help you diagnose why the
     * error occurred. This parameter is only returned by <a>DescribeSnapshots</a>.
     * </p>
     * 
     * @return Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for
     *         example, if the proper KMS permissions are not obtained) this field displays error state details to help
     *         you diagnose why the error occurred. This parameter is only returned by <a>DescribeSnapshots</a>.
     */
    public final String stateMessage() {
        return stateMessage;
    }

    /**
     * <p>
     * The time stamp when the snapshot was initiated.
     * </p>
     * 
     * @return The time stamp when the snapshot was initiated.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The progress of the snapshot, as a percentage.
     * </p>
     * 
     * @return The progress of the snapshot, as a percentage.
     */
    public final String progress() {
        return progress;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the EBS snapshot.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the EBS snapshot.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The description for the snapshot.
     * </p>
     * 
     * @return The description for the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * Indicates whether the snapshot is encrypted.
     * </p>
     * 
     * @return Indicates whether the snapshot is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key that was used to protect the volume encryption key for the parent
     * volume.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key that was used to protect the volume encryption key for the
     *         parent volume.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to the
     * data encryption key that was used to encrypt the original volume or snapshot copy. Because data encryption keys
     * are inherited by volumes created from snapshots, and vice versa, if snapshots share the same data encryption key
     * identifier, then they belong to the same volume/snapshot lineage. This parameter is only returned by
     * <a>DescribeSnapshots</a>.
     * </p>
     * 
     * @return The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds
     *         to the data encryption key that was used to encrypt the original volume or snapshot copy. Because data
     *         encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the
     *         same data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter
     *         is only returned by <a>DescribeSnapshots</a>.
     */
    public final String dataEncryptionKeyId() {
        return dataEncryptionKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(restoreExpiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(transferTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(completionDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(fullSnapshotSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dataEncryptionKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotResponse)) {
            return false;
        }
        CreateSnapshotResponse other = (CreateSnapshotResponse) obj;
        return Objects.equals(ownerAlias(), other.ownerAlias()) && Objects.equals(outpostArn(), other.outpostArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(storageTierAsString(), other.storageTierAsString())
                && Objects.equals(restoreExpiryTime(), other.restoreExpiryTime())
                && Objects.equals(sseTypeAsString(), other.sseTypeAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(transferTypeAsString(), other.transferTypeAsString())
                && Objects.equals(completionDurationMinutes(), other.completionDurationMinutes())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(fullSnapshotSizeInBytes(), other.fullSnapshotSizeInBytes())
                && Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateMessage(), other.stateMessage())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(progress(), other.progress())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(description(), other.description())
                && Objects.equals(volumeSize(), other.volumeSize()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dataEncryptionKeyId(), other.dataEncryptionKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSnapshotResponse").add("OwnerAlias", ownerAlias()).add("OutpostArn", outpostArn())
                .add("Tags", hasTags() ? tags() : null).add("StorageTier", storageTierAsString())
                .add("RestoreExpiryTime", restoreExpiryTime()).add("SseType", sseTypeAsString())
                .add("AvailabilityZone", availabilityZone()).add("TransferType", transferTypeAsString())
                .add("CompletionDurationMinutes", completionDurationMinutes()).add("CompletionTime", completionTime())
                .add("FullSnapshotSizeInBytes", fullSnapshotSizeInBytes()).add("SnapshotId", snapshotId())
                .add("VolumeId", volumeId()).add("State", stateAsString()).add("StateMessage", stateMessage())
                .add("StartTime", startTime()).add("Progress", progress()).add("OwnerId", ownerId())
                .add("Description", description()).add("VolumeSize", volumeSize()).add("Encrypted", encrypted())
                .add("KmsKeyId", kmsKeyId()).add("DataEncryptionKeyId", dataEncryptionKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerAlias":
            return Optional.ofNullable(clazz.cast(ownerAlias()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "StorageTier":
            return Optional.ofNullable(clazz.cast(storageTierAsString()));
        case "RestoreExpiryTime":
            return Optional.ofNullable(clazz.cast(restoreExpiryTime()));
        case "SseType":
            return Optional.ofNullable(clazz.cast(sseTypeAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "TransferType":
            return Optional.ofNullable(clazz.cast(transferTypeAsString()));
        case "CompletionDurationMinutes":
            return Optional.ofNullable(clazz.cast(completionDurationMinutes()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "FullSnapshotSizeInBytes":
            return Optional.ofNullable(clazz.cast(fullSnapshotSizeInBytes()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DataEncryptionKeyId":
            return Optional.ofNullable(clazz.cast(dataEncryptionKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerAlias", OWNER_ALIAS_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("StorageTier", STORAGE_TIER_FIELD);
        map.put("RestoreExpiryTime", RESTORE_EXPIRY_TIME_FIELD);
        map.put("SseType", SSE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("TransferType", TRANSFER_TYPE_FIELD);
        map.put("CompletionDurationMinutes", COMPLETION_DURATION_MINUTES_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("FullSnapshotSizeInBytes", FULL_SNAPSHOT_SIZE_IN_BYTES_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("Status", STATE_FIELD);
        map.put("StatusMessage", STATE_MESSAGE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("DataEncryptionKeyId", DATA_ENCRYPTION_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotResponse, T> g) {
        return obj -> g.apply((CreateSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateSnapshotResponse> {
        /**
         * <p>
         * The Amazon Web Services owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the
         * user-configured Amazon Web Services account alias set using the IAM console.
         * </p>
         * 
         * @param ownerAlias
         *        The Amazon Web Services owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not
         *        the user-configured Amazon Web Services account alias set using the IAM console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAlias(String ownerAlias);

        /**
         * <p>
         * The ARN of the Outpost on which the snapshot is stored. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local snapshots on
         * Outposts</a> in the <i>Amazon EBS User Guide</i>.
         * </p>
         * 
         * @param outpostArn
         *        The ARN of the Outpost on which the snapshot is stored. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local
         *        snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * Any tags assigned to the snapshot.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the snapshot.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the snapshot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is stored
         * in the standard snapshot storage tier and that it is ready for use. <code>archive</code> indicates that the
         * snapshot is currently archived and that it must be restored before it can be used.
         * </p>
         * 
         * @param storageTier
         *        The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is
         *        stored in the standard snapshot storage tier and that it is ready for use. <code>archive</code>
         *        indicates that the snapshot is currently archived and that it must be restored before it can be used.
         * @see StorageTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageTier
         */
        Builder storageTier(String storageTier);

        /**
         * <p>
         * The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is stored
         * in the standard snapshot storage tier and that it is ready for use. <code>archive</code> indicates that the
         * snapshot is currently archived and that it must be restored before it can be used.
         * </p>
         * 
         * @param storageTier
         *        The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is
         *        stored in the standard snapshot storage tier and that it is ready for use. <code>archive</code>
         *        indicates that the snapshot is currently archived and that it must be restored before it can be used.
         * @see StorageTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageTier
         */
        Builder storageTier(StorageTier storageTier);

        /**
         * <p>
         * Only for archived snapshots that are temporarily restored. Indicates the date and time when a temporarily
         * restored snapshot will be automatically re-archived.
         * </p>
         * 
         * @param restoreExpiryTime
         *        Only for archived snapshots that are temporarily restored. Indicates the date and time when a
         *        temporarily restored snapshot will be automatically re-archived.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreExpiryTime(Instant restoreExpiryTime);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param sseType
         *        Reserved for future use.
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(String sseType);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param sseType
         *        Reserved for future use.
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(SSEType sseType);

        /**
         * <p>
         * The Availability Zone or Local Zone of the snapshot. For example, <code>us-west-1a</code> (Availability Zone)
         * or <code>us-west-2-lax-1a</code> (Local Zone).
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone or Local Zone of the snapshot. For example, <code>us-west-1a</code>
         *        (Availability Zone) or <code>us-west-2-lax-1a</code> (Local Zone).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <note>
         * <p>
         * Only for snapshot copies.
         * </p>
         * </note>
         * <p>
         * Indicates whether the snapshot copy was created with a standard or time-based snapshot copy operation.
         * Time-based snapshot copy operations complete within the completion duration specified in the request.
         * Standard snapshot copy operations are completed on a best-effort basis.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>standard</code> - The snapshot copy was created with a standard snapshot copy operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>time-based</code> - The snapshot copy was created with a time-based snapshot copy operation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param transferType
         *        <p>
         *        Only for snapshot copies.
         *        </p>
         *        </note>
         *        <p>
         *        Indicates whether the snapshot copy was created with a standard or time-based snapshot copy operation.
         *        Time-based snapshot copy operations complete within the completion duration specified in the request.
         *        Standard snapshot copy operations are completed on a best-effort basis.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>standard</code> - The snapshot copy was created with a standard snapshot copy operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>time-based</code> - The snapshot copy was created with a time-based snapshot copy operation.
         *        </p>
         *        </li>
         * @see TransferType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransferType
         */
        Builder transferType(String transferType);

        /**
         * <note>
         * <p>
         * Only for snapshot copies.
         * </p>
         * </note>
         * <p>
         * Indicates whether the snapshot copy was created with a standard or time-based snapshot copy operation.
         * Time-based snapshot copy operations complete within the completion duration specified in the request.
         * Standard snapshot copy operations are completed on a best-effort basis.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>standard</code> - The snapshot copy was created with a standard snapshot copy operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>time-based</code> - The snapshot copy was created with a time-based snapshot copy operation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param transferType
         *        <p>
         *        Only for snapshot copies.
         *        </p>
         *        </note>
         *        <p>
         *        Indicates whether the snapshot copy was created with a standard or time-based snapshot copy operation.
         *        Time-based snapshot copy operations complete within the completion duration specified in the request.
         *        Standard snapshot copy operations are completed on a best-effort basis.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>standard</code> - The snapshot copy was created with a standard snapshot copy operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>time-based</code> - The snapshot copy was created with a time-based snapshot copy operation.
         *        </p>
         *        </li>
         * @see TransferType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransferType
         */
        Builder transferType(TransferType transferType);

        /**
         * <note>
         * <p>
         * Only for snapshot copies created with time-based snapshot copy operations.
         * </p>
         * </note>
         * <p>
         * The completion duration requested for the time-based snapshot copy operation.
         * </p>
         * 
         * @param completionDurationMinutes
         *        <p>
         *        Only for snapshot copies created with time-based snapshot copy operations.
         *        </p>
         *        </note>
         *        <p>
         *        The completion duration requested for the time-based snapshot copy operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDurationMinutes(Integer completionDurationMinutes);

        /**
         * <p>
         * The time stamp when the snapshot was completed.
         * </p>
         * 
         * @param completionTime
         *        The time stamp when the snapshot was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The full size of the snapshot, in bytes.
         * </p>
         * <important>
         * <p>
         * This is <b>not</b> the incremental size of the snapshot. This is the full snapshot size and represents the
         * size of all the blocks that were written to the source volume at the time the snapshot was created.
         * </p>
         * </important>
         * 
         * @param fullSnapshotSizeInBytes
         *        The full size of the snapshot, in bytes.</p> <important>
         *        <p>
         *        This is <b>not</b> the incremental size of the snapshot. This is the full snapshot size and represents
         *        the size of all the blocks that were written to the source volume at the time the snapshot was
         *        created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullSnapshotSizeInBytes(Long fullSnapshotSizeInBytes);

        /**
         * <p>
         * The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a>
         * action have an arbitrary volume ID that should not be used for any purpose.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that was used to create the snapshot. Snapshots created by the
         *        <a>CopySnapshot</a> action have an arbitrary volume ID that should not be used for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The snapshot state.
         * </p>
         * 
         * @param state
         *        The snapshot state.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(String state);

        /**
         * <p>
         * The snapshot state.
         * </p>
         * 
         * @param state
         *        The snapshot state.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(SnapshotState state);

        /**
         * <p>
         * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if
         * the proper KMS permissions are not obtained) this field displays error state details to help you diagnose why
         * the error occurred. This parameter is only returned by <a>DescribeSnapshots</a>.
         * </p>
         * 
         * @param stateMessage
         *        Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for
         *        example, if the proper KMS permissions are not obtained) this field displays error state details to
         *        help you diagnose why the error occurred. This parameter is only returned by <a>DescribeSnapshots</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);

        /**
         * <p>
         * The time stamp when the snapshot was initiated.
         * </p>
         * 
         * @param startTime
         *        The time stamp when the snapshot was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The progress of the snapshot, as a percentage.
         * </p>
         * 
         * @param progress
         *        The progress of the snapshot, as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the EBS snapshot.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the EBS snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The description for the snapshot.
         * </p>
         * 
         * @param description
         *        The description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * Indicates whether the snapshot is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the snapshot is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key that was used to protect the volume encryption key for the
         * parent volume.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of the KMS key that was used to protect the volume encryption key for
         *        the parent volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to
         * the data encryption key that was used to encrypt the original volume or snapshot copy. Because data
         * encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the same
         * data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter is only
         * returned by <a>DescribeSnapshots</a>.
         * </p>
         * 
         * @param dataEncryptionKeyId
         *        The data encryption key identifier for the snapshot. This value is a unique identifier that
         *        corresponds to the data encryption key that was used to encrypt the original volume or snapshot copy.
         *        Because data encryption keys are inherited by volumes created from snapshots, and vice versa, if
         *        snapshots share the same data encryption key identifier, then they belong to the same volume/snapshot
         *        lineage. This parameter is only returned by <a>DescribeSnapshots</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEncryptionKeyId(String dataEncryptionKeyId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String ownerAlias;

        private String outpostArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String storageTier;

        private Instant restoreExpiryTime;

        private String sseType;

        private String availabilityZone;

        private String transferType;

        private Integer completionDurationMinutes;

        private Instant completionTime;

        private Long fullSnapshotSizeInBytes;

        private String snapshotId;

        private String volumeId;

        private String state;

        private String stateMessage;

        private Instant startTime;

        private String progress;

        private String ownerId;

        private String description;

        private Integer volumeSize;

        private Boolean encrypted;

        private String kmsKeyId;

        private String dataEncryptionKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotResponse model) {
            super(model);
            ownerAlias(model.ownerAlias);
            outpostArn(model.outpostArn);
            tags(model.tags);
            storageTier(model.storageTier);
            restoreExpiryTime(model.restoreExpiryTime);
            sseType(model.sseType);
            availabilityZone(model.availabilityZone);
            transferType(model.transferType);
            completionDurationMinutes(model.completionDurationMinutes);
            completionTime(model.completionTime);
            fullSnapshotSizeInBytes(model.fullSnapshotSizeInBytes);
            snapshotId(model.snapshotId);
            volumeId(model.volumeId);
            state(model.state);
            stateMessage(model.stateMessage);
            startTime(model.startTime);
            progress(model.progress);
            ownerId(model.ownerId);
            description(model.description);
            volumeSize(model.volumeSize);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            dataEncryptionKeyId(model.dataEncryptionKeyId);
        }

        public final String getOwnerAlias() {
            return ownerAlias;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStorageTier() {
            return storageTier;
        }

        public final void setStorageTier(String storageTier) {
            this.storageTier = storageTier;
        }

        @Override
        public final Builder storageTier(String storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        @Override
        public final Builder storageTier(StorageTier storageTier) {
            this.storageTier(storageTier == null ? null : storageTier.toString());
            return this;
        }

        public final Instant getRestoreExpiryTime() {
            return restoreExpiryTime;
        }

        public final void setRestoreExpiryTime(Instant restoreExpiryTime) {
            this.restoreExpiryTime = restoreExpiryTime;
        }

        @Override
        public final Builder restoreExpiryTime(Instant restoreExpiryTime) {
            this.restoreExpiryTime = restoreExpiryTime;
            return this;
        }

        public final String getSseType() {
            return sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getTransferType() {
            return transferType;
        }

        public final void setTransferType(String transferType) {
            this.transferType = transferType;
        }

        @Override
        public final Builder transferType(String transferType) {
            this.transferType = transferType;
            return this;
        }

        @Override
        public final Builder transferType(TransferType transferType) {
            this.transferType(transferType == null ? null : transferType.toString());
            return this;
        }

        public final Integer getCompletionDurationMinutes() {
            return completionDurationMinutes;
        }

        public final void setCompletionDurationMinutes(Integer completionDurationMinutes) {
            this.completionDurationMinutes = completionDurationMinutes;
        }

        @Override
        public final Builder completionDurationMinutes(Integer completionDurationMinutes) {
            this.completionDurationMinutes = completionDurationMinutes;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Long getFullSnapshotSizeInBytes() {
            return fullSnapshotSizeInBytes;
        }

        public final void setFullSnapshotSizeInBytes(Long fullSnapshotSizeInBytes) {
            this.fullSnapshotSizeInBytes = fullSnapshotSizeInBytes;
        }

        @Override
        public final Builder fullSnapshotSizeInBytes(Long fullSnapshotSizeInBytes) {
            this.fullSnapshotSizeInBytes = fullSnapshotSizeInBytes;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getProgress() {
            return progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDataEncryptionKeyId() {
            return dataEncryptionKeyId;
        }

        public final void setDataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
        }

        @Override
        public final Builder dataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
            return this;
        }

        @Override
        public CreateSnapshotResponse build() {
            return new CreateSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
