/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesConfigurationListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyReservedInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyReservedInstancesRequest> {
    private static final SdkField<List<String>> RESERVED_INSTANCES_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstancesIds").getter(ModifyReservedInstancesRequest.getter(ModifyReservedInstancesRequest::reservedInstancesIds)).setter(ModifyReservedInstancesRequest.setter(Builder::reservedInstancesIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("ReservedInstancesId").build(), ListTrait.builder().memberLocationName("ReservedInstancesId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("ReservedInstancesId").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyReservedInstancesRequest.getter(ModifyReservedInstancesRequest::clientToken)).setter(ModifyReservedInstancesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<List<ReservedInstancesConfiguration>> TARGET_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetConfigurations").getter(ModifyReservedInstancesRequest.getter(ModifyReservedInstancesRequest::targetConfigurations)).setter(ModifyReservedInstancesRequest.setter(Builder::targetConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesConfigurationSetItemType").unmarshallLocationName("ReservedInstancesConfigurationSetItemType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstancesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_IDS_FIELD, CLIENT_TOKEN_FIELD, TARGET_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyReservedInstancesRequest.memberNameToFieldInitializer();
    private final List<String> reservedInstancesIds;
    private final String clientToken;
    private final List<ReservedInstancesConfiguration> targetConfigurations;

    private ModifyReservedInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.clientToken = builder.clientToken;
        this.targetConfigurations = builder.targetConfigurations;
    }

    public final boolean hasReservedInstancesIds() {
        return this.reservedInstancesIds != null && !(this.reservedInstancesIds instanceof SdkAutoConstructList);
    }

    public final List<String> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTargetConfigurations() {
        return this.targetConfigurations != null && !(this.targetConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ReservedInstancesConfiguration> targetConfigurations() {
        return this.targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstancesIds() ? this.reservedInstancesIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetConfigurations() ? this.targetConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesRequest)) {
            return false;
        }
        ModifyReservedInstancesRequest other = (ModifyReservedInstancesRequest)((Object)obj);
        return this.hasReservedInstancesIds() == other.hasReservedInstancesIds() && Objects.equals(this.reservedInstancesIds(), other.reservedInstancesIds()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTargetConfigurations() == other.hasTargetConfigurations() && Objects.equals(this.targetConfigurations(), other.targetConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyReservedInstancesRequest").add("ReservedInstancesIds", this.hasReservedInstancesIds() ? this.reservedInstancesIds() : null).add("ClientToken", (Object)this.clientToken()).add("TargetConfigurations", this.hasTargetConfigurations() ? this.targetConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstancesIds": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesIds()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "TargetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.targetConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservedInstancesId", RESERVED_INSTANCES_IDS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ReservedInstancesConfigurationSetItemType", TARGET_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyReservedInstancesRequest, T> g) {
        return obj -> g.apply((ModifyReservedInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> reservedInstancesIds = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private List<ReservedInstancesConfiguration> targetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReservedInstancesRequest model) {
            super(model);
            this.reservedInstancesIds(model.reservedInstancesIds);
            this.clientToken(model.clientToken);
            this.targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstancesIds() {
            if (this.reservedInstancesIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reservedInstancesIds;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<ReservedInstancesConfiguration.Builder> getTargetConfigurations() {
            List<ReservedInstancesConfiguration.Builder> result = ReservedInstancesConfigurationListCopier.copyToBuilder(this.targetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetConfigurations(Collection<ReservedInstancesConfiguration.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        public final Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(ReservedInstancesConfiguration ... targetConfigurations) {
            this.targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(Consumer<ReservedInstancesConfiguration.Builder> ... targetConfigurations) {
            this.targetConfigurations(Stream.of(targetConfigurations).map(c -> (ReservedInstancesConfiguration)((ReservedInstancesConfiguration.Builder)ReservedInstancesConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReservedInstancesRequest build() {
            return new ModifyReservedInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyReservedInstancesRequest> {
        public Builder reservedInstancesIds(Collection<String> var1);

        public Builder reservedInstancesIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder targetConfigurations(Collection<ReservedInstancesConfiguration> var1);

        public Builder targetConfigurations(ReservedInstancesConfiguration ... var1);

        public Builder targetConfigurations(Consumer<ReservedInstancesConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

