/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InitializationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitializationStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InitializationStatusDetails> {
    private static final SdkField<String> INITIALIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitializationType").getter(InitializationStatusDetails.getter(InitializationStatusDetails::initializationTypeAsString)).setter(InitializationStatusDetails.setter(Builder::initializationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationType").unmarshallLocationName("initializationType").build()}).build();
    private static final SdkField<Long> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Progress").getter(InitializationStatusDetails.getter(InitializationStatusDetails::progress)).setter(InitializationStatusDetails.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeToCompleteInSeconds").getter(InitializationStatusDetails.getter(InitializationStatusDetails::estimatedTimeToCompleteInSeconds)).setter(InitializationStatusDetails.setter(Builder::estimatedTimeToCompleteInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompleteInSeconds").unmarshallLocationName("estimatedTimeToCompleteInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIALIZATION_TYPE_FIELD, PROGRESS_FIELD, ESTIMATED_TIME_TO_COMPLETE_IN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InitializationStatusDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String initializationType;
    private final Long progress;
    private final Long estimatedTimeToCompleteInSeconds;

    private InitializationStatusDetails(BuilderImpl builder) {
        this.initializationType = builder.initializationType;
        this.progress = builder.progress;
        this.estimatedTimeToCompleteInSeconds = builder.estimatedTimeToCompleteInSeconds;
    }

    public final InitializationType initializationType() {
        return InitializationType.fromValue(this.initializationType);
    }

    public final String initializationTypeAsString() {
        return this.initializationType;
    }

    public final Long progress() {
        return this.progress;
    }

    public final Long estimatedTimeToCompleteInSeconds() {
        return this.estimatedTimeToCompleteInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeToCompleteInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitializationStatusDetails)) {
            return false;
        }
        InitializationStatusDetails other = (InitializationStatusDetails)obj;
        return Objects.equals(this.initializationTypeAsString(), other.initializationTypeAsString()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.estimatedTimeToCompleteInSeconds(), other.estimatedTimeToCompleteInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"InitializationStatusDetails").add("InitializationType", (Object)this.initializationTypeAsString()).add("Progress", (Object)this.progress()).add("EstimatedTimeToCompleteInSeconds", (Object)this.estimatedTimeToCompleteInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InitializationType": {
                return Optional.ofNullable(clazz.cast(this.initializationTypeAsString()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "EstimatedTimeToCompleteInSeconds": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeToCompleteInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InitializationType", INITIALIZATION_TYPE_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("EstimatedTimeToCompleteInSeconds", ESTIMATED_TIME_TO_COMPLETE_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InitializationStatusDetails, T> g) {
        return obj -> g.apply((InitializationStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String initializationType;
        private Long progress;
        private Long estimatedTimeToCompleteInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InitializationStatusDetails model) {
            this.initializationType(model.initializationType);
            this.progress(model.progress);
            this.estimatedTimeToCompleteInSeconds(model.estimatedTimeToCompleteInSeconds);
        }

        public final String getInitializationType() {
            return this.initializationType;
        }

        public final void setInitializationType(String initializationType) {
            this.initializationType = initializationType;
        }

        @Override
        public final Builder initializationType(String initializationType) {
            this.initializationType = initializationType;
            return this;
        }

        @Override
        public final Builder initializationType(InitializationType initializationType) {
            this.initializationType(initializationType == null ? null : initializationType.toString());
            return this;
        }

        public final Long getProgress() {
            return this.progress;
        }

        public final void setProgress(Long progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(Long progress) {
            this.progress = progress;
            return this;
        }

        public final Long getEstimatedTimeToCompleteInSeconds() {
            return this.estimatedTimeToCompleteInSeconds;
        }

        public final void setEstimatedTimeToCompleteInSeconds(Long estimatedTimeToCompleteInSeconds) {
            this.estimatedTimeToCompleteInSeconds = estimatedTimeToCompleteInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompleteInSeconds(Long estimatedTimeToCompleteInSeconds) {
            this.estimatedTimeToCompleteInSeconds = estimatedTimeToCompleteInSeconds;
            return this;
        }

        public InitializationStatusDetails build() {
            return new InitializationStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InitializationStatusDetails> {
        public Builder initializationType(String var1);

        public Builder initializationType(InitializationType var1);

        public Builder progress(Long var1);

        public Builder estimatedTimeToCompleteInSeconds(Long var1);
    }
}

