/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVerifiedAccessGroupPolicyResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyVerifiedAccessGroupPolicyResponse> {
    private static final SdkField<Boolean> POLICY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PolicyEnabled").getter(ModifyVerifiedAccessGroupPolicyResponse.getter(ModifyVerifiedAccessGroupPolicyResponse::policyEnabled)).setter(ModifyVerifiedAccessGroupPolicyResponse.setter(Builder::policyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyEnabled").unmarshallLocationName("policyEnabled").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(ModifyVerifiedAccessGroupPolicyResponse.getter(ModifyVerifiedAccessGroupPolicyResponse::policyDocument)).setter(ModifyVerifiedAccessGroupPolicyResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("policyDocument").build()}).build();
    private static final SdkField<VerifiedAccessSseSpecificationResponse> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseSpecification").getter(ModifyVerifiedAccessGroupPolicyResponse.getter(ModifyVerifiedAccessGroupPolicyResponse::sseSpecification)).setter(ModifyVerifiedAccessGroupPolicyResponse.setter(Builder::sseSpecification)).constructor(VerifiedAccessSseSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification").unmarshallLocationName("sseSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ENABLED_FIELD, POLICY_DOCUMENT_FIELD, SSE_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyVerifiedAccessGroupPolicyResponse.memberNameToFieldInitializer();
    private final Boolean policyEnabled;
    private final String policyDocument;
    private final VerifiedAccessSseSpecificationResponse sseSpecification;

    private ModifyVerifiedAccessGroupPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyEnabled = builder.policyEnabled;
        this.policyDocument = builder.policyDocument;
        this.sseSpecification = builder.sseSpecification;
    }

    public final Boolean policyEnabled() {
        return this.policyEnabled;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final VerifiedAccessSseSpecificationResponse sseSpecification() {
        return this.sseSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessGroupPolicyResponse)) {
            return false;
        }
        ModifyVerifiedAccessGroupPolicyResponse other = (ModifyVerifiedAccessGroupPolicyResponse)((Object)obj);
        return Objects.equals(this.policyEnabled(), other.policyEnabled()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.sseSpecification(), other.sseSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVerifiedAccessGroupPolicyResponse").add("PolicyEnabled", (Object)this.policyEnabled()).add("PolicyDocument", (Object)this.policyDocument()).add("SseSpecification", (Object)this.sseSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyEnabled": {
                return Optional.ofNullable(clazz.cast(this.policyEnabled()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "SseSpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyEnabled", POLICY_ENABLED_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        map.put("SseSpecification", SSE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessGroupPolicyResponse, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessGroupPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean policyEnabled;
        private String policyDocument;
        private VerifiedAccessSseSpecificationResponse sseSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessGroupPolicyResponse model) {
            super(model);
            this.policyEnabled(model.policyEnabled);
            this.policyDocument(model.policyDocument);
            this.sseSpecification(model.sseSpecification);
        }

        public final Boolean getPolicyEnabled() {
            return this.policyEnabled;
        }

        public final void setPolicyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
        }

        @Override
        public final Builder policyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final VerifiedAccessSseSpecificationResponse.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationResponse.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        @Override
        public ModifyVerifiedAccessGroupPolicyResponse build() {
            return new ModifyVerifiedAccessGroupPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVerifiedAccessGroupPolicyResponse> {
        public Builder policyEnabled(Boolean var1);

        public Builder policyDocument(String var1);

        public Builder sseSpecification(VerifiedAccessSseSpecificationResponse var1);

        default public Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationResponse.Builder> sseSpecification) {
            return this.sseSpecification((VerifiedAccessSseSpecificationResponse)((VerifiedAccessSseSpecificationResponse.Builder)VerifiedAccessSseSpecificationResponse.builder().applyMutation(sseSpecification)).build());
        }
    }
}

