/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about instance capacity usage for a Capacity Reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityAllocation implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityAllocation.Builder, CapacityAllocation> {
    private static final SdkField<String> ALLOCATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationType")
            .getter(getter(CapacityAllocation::allocationTypeAsString))
            .setter(setter(Builder::allocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationType")
                    .unmarshallLocationName("allocationType").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Count")
            .getter(getter(CapacityAllocation::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_TYPE_FIELD,
            COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String allocationType;

    private final Integer count;

    private CapacityAllocation(BuilderImpl builder) {
        this.allocationType = builder.allocationType;
        this.count = builder.count;
    }

    /**
     * <p>
     * The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are running in
     * the Capacity Reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allocationType}
     * will return {@link AllocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #allocationTypeAsString}.
     * </p>
     * 
     * @return The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are
     *         running in the Capacity Reservation.
     * @see AllocationType
     */
    public final AllocationType allocationType() {
        return AllocationType.fromValue(allocationType);
    }

    /**
     * <p>
     * The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are running in
     * the Capacity Reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #allocationType}
     * will return {@link AllocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #allocationTypeAsString}.
     * </p>
     * 
     * @return The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are
     *         running in the Capacity Reservation.
     * @see AllocationType
     */
    public final String allocationTypeAsString() {
        return allocationType;
    }

    /**
     * <p>
     * The amount of instance capacity associated with the usage. For example a value of <code>4</code> indicates that
     * instance capacity for 4 instances is currently in use.
     * </p>
     * 
     * @return The amount of instance capacity associated with the usage. For example a value of <code>4</code>
     *         indicates that instance capacity for 4 instances is currently in use.
     */
    public final Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityAllocation)) {
            return false;
        }
        CapacityAllocation other = (CapacityAllocation) obj;
        return Objects.equals(allocationTypeAsString(), other.allocationTypeAsString()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityAllocation").add("AllocationType", allocationTypeAsString()).add("Count", count())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationType":
            return Optional.ofNullable(clazz.cast(allocationTypeAsString()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocationType", ALLOCATION_TYPE_FIELD);
        map.put("Count", COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityAllocation, T> g) {
        return obj -> g.apply((CapacityAllocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityAllocation> {
        /**
         * <p>
         * The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are
         * running in the Capacity Reservation.
         * </p>
         * 
         * @param allocationType
         *        The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are
         *        running in the Capacity Reservation.
         * @see AllocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationType
         */
        Builder allocationType(String allocationType);

        /**
         * <p>
         * The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are
         * running in the Capacity Reservation.
         * </p>
         * 
         * @param allocationType
         *        The usage type. <code>used</code> indicates that the instance capacity is in use by instances that are
         *        running in the Capacity Reservation.
         * @see AllocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationType
         */
        Builder allocationType(AllocationType allocationType);

        /**
         * <p>
         * The amount of instance capacity associated with the usage. For example a value of <code>4</code> indicates
         * that instance capacity for 4 instances is currently in use.
         * </p>
         * 
         * @param count
         *        The amount of instance capacity associated with the usage. For example a value of <code>4</code>
         *        indicates that instance capacity for 4 instances is currently in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private String allocationType;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityAllocation model) {
            allocationType(model.allocationType);
            count(model.count);
        }

        public final String getAllocationType() {
            return allocationType;
        }

        public final void setAllocationType(String allocationType) {
            this.allocationType = allocationType;
        }

        @Override
        public final Builder allocationType(String allocationType) {
            this.allocationType = allocationType;
            return this;
        }

        @Override
        public final Builder allocationType(AllocationType allocationType) {
            this.allocationType(allocationType == null ? null : allocationType.toString());
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        @Override
        public CapacityAllocation build() {
            return new CapacityAllocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
