/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary report for the attribute across all Regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeSummary.Builder, AttributeSummary> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AttributeName")
            .getter(getter(AttributeSummary::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName")
                    .unmarshallLocationName("attributeName").build()).build();

    private static final SdkField<String> MOST_FREQUENT_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MostFrequentValue")
            .getter(getter(AttributeSummary::mostFrequentValue))
            .setter(setter(Builder::mostFrequentValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MostFrequentValue")
                    .unmarshallLocationName("mostFrequentValue").build()).build();

    private static final SdkField<Integer> NUMBER_OF_MATCHED_ACCOUNTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfMatchedAccounts")
            .getter(getter(AttributeSummary::numberOfMatchedAccounts))
            .setter(setter(Builder::numberOfMatchedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMatchedAccounts")
                    .unmarshallLocationName("numberOfMatchedAccounts").build()).build();

    private static final SdkField<Integer> NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfUnmatchedAccounts")
            .getter(getter(AttributeSummary::numberOfUnmatchedAccounts))
            .setter(setter(Builder::numberOfUnmatchedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfUnmatchedAccounts")
                    .unmarshallLocationName("numberOfUnmatchedAccounts").build()).build();

    private static final SdkField<List<RegionalSummary>> REGIONAL_SUMMARIES_FIELD = SdkField
            .<List<RegionalSummary>> builder(MarshallingType.LIST)
            .memberName("RegionalSummaries")
            .getter(getter(AttributeSummary::regionalSummaries))
            .setter(setter(Builder::regionalSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionalSummarySet")
                    .unmarshallLocationName("regionalSummarySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RegionalSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionalSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            MOST_FREQUENT_VALUE_FIELD, NUMBER_OF_MATCHED_ACCOUNTS_FIELD, NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD,
            REGIONAL_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String mostFrequentValue;

    private final Integer numberOfMatchedAccounts;

    private final Integer numberOfUnmatchedAccounts;

    private final List<RegionalSummary> regionalSummaries;

    private AttributeSummary(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.mostFrequentValue = builder.mostFrequentValue;
        this.numberOfMatchedAccounts = builder.numberOfMatchedAccounts;
        this.numberOfUnmatchedAccounts = builder.numberOfUnmatchedAccounts;
        this.regionalSummaries = builder.regionalSummaries;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * 
     * @return The name of the attribute.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The configuration value that is most frequently observed for the attribute.
     * </p>
     * 
     * @return The configuration value that is most frequently observed for the attribute.
     */
    public final String mostFrequentValue() {
        return mostFrequentValue;
    }

    /**
     * <p>
     * The number of accounts with the same configuration value for the attribute that is most frequently observed.
     * </p>
     * 
     * @return The number of accounts with the same configuration value for the attribute that is most frequently
     *         observed.
     */
    public final Integer numberOfMatchedAccounts() {
        return numberOfMatchedAccounts;
    }

    /**
     * <p>
     * The number of accounts with a configuration value different from the most frequently observed value for the
     * attribute.
     * </p>
     * 
     * @return The number of accounts with a configuration value different from the most frequently observed value for
     *         the attribute.
     */
    public final Integer numberOfUnmatchedAccounts() {
        return numberOfUnmatchedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionalSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegionalSummaries() {
        return regionalSummaries != null && !(regionalSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary report for each Region for the attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionalSummaries} method.
     * </p>
     * 
     * @return The summary report for each Region for the attribute.
     */
    public final List<RegionalSummary> regionalSummaries() {
        return regionalSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(mostFrequentValue());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMatchedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfUnmatchedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionalSummaries() ? regionalSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeSummary)) {
            return false;
        }
        AttributeSummary other = (AttributeSummary) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(mostFrequentValue(), other.mostFrequentValue())
                && Objects.equals(numberOfMatchedAccounts(), other.numberOfMatchedAccounts())
                && Objects.equals(numberOfUnmatchedAccounts(), other.numberOfUnmatchedAccounts())
                && hasRegionalSummaries() == other.hasRegionalSummaries()
                && Objects.equals(regionalSummaries(), other.regionalSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeSummary").add("AttributeName", attributeName())
                .add("MostFrequentValue", mostFrequentValue()).add("NumberOfMatchedAccounts", numberOfMatchedAccounts())
                .add("NumberOfUnmatchedAccounts", numberOfUnmatchedAccounts())
                .add("RegionalSummaries", hasRegionalSummaries() ? regionalSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "MostFrequentValue":
            return Optional.ofNullable(clazz.cast(mostFrequentValue()));
        case "NumberOfMatchedAccounts":
            return Optional.ofNullable(clazz.cast(numberOfMatchedAccounts()));
        case "NumberOfUnmatchedAccounts":
            return Optional.ofNullable(clazz.cast(numberOfUnmatchedAccounts()));
        case "RegionalSummaries":
            return Optional.ofNullable(clazz.cast(regionalSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("MostFrequentValue", MOST_FREQUENT_VALUE_FIELD);
        map.put("NumberOfMatchedAccounts", NUMBER_OF_MATCHED_ACCOUNTS_FIELD);
        map.put("NumberOfUnmatchedAccounts", NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD);
        map.put("RegionalSummarySet", REGIONAL_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeSummary, T> g) {
        return obj -> g.apply((AttributeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeSummary> {
        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The configuration value that is most frequently observed for the attribute.
         * </p>
         * 
         * @param mostFrequentValue
         *        The configuration value that is most frequently observed for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mostFrequentValue(String mostFrequentValue);

        /**
         * <p>
         * The number of accounts with the same configuration value for the attribute that is most frequently observed.
         * </p>
         * 
         * @param numberOfMatchedAccounts
         *        The number of accounts with the same configuration value for the attribute that is most frequently
         *        observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMatchedAccounts(Integer numberOfMatchedAccounts);

        /**
         * <p>
         * The number of accounts with a configuration value different from the most frequently observed value for the
         * attribute.
         * </p>
         * 
         * @param numberOfUnmatchedAccounts
         *        The number of accounts with a configuration value different from the most frequently observed value
         *        for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts);

        /**
         * <p>
         * The summary report for each Region for the attribute.
         * </p>
         * 
         * @param regionalSummaries
         *        The summary report for each Region for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalSummaries(Collection<RegionalSummary> regionalSummaries);

        /**
         * <p>
         * The summary report for each Region for the attribute.
         * </p>
         * 
         * @param regionalSummaries
         *        The summary report for each Region for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalSummaries(RegionalSummary... regionalSummaries);

        /**
         * <p>
         * The summary report for each Region for the attribute.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RegionalSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RegionalSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RegionalSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #regionalSummaries(List<RegionalSummary>)}.
         * 
         * @param regionalSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RegionalSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionalSummaries(java.util.Collection<RegionalSummary>)
         */
        Builder regionalSummaries(Consumer<RegionalSummary.Builder>... regionalSummaries);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String mostFrequentValue;

        private Integer numberOfMatchedAccounts;

        private Integer numberOfUnmatchedAccounts;

        private List<RegionalSummary> regionalSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeSummary model) {
            attributeName(model.attributeName);
            mostFrequentValue(model.mostFrequentValue);
            numberOfMatchedAccounts(model.numberOfMatchedAccounts);
            numberOfUnmatchedAccounts(model.numberOfUnmatchedAccounts);
            regionalSummaries(model.regionalSummaries);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getMostFrequentValue() {
            return mostFrequentValue;
        }

        public final void setMostFrequentValue(String mostFrequentValue) {
            this.mostFrequentValue = mostFrequentValue;
        }

        @Override
        public final Builder mostFrequentValue(String mostFrequentValue) {
            this.mostFrequentValue = mostFrequentValue;
            return this;
        }

        public final Integer getNumberOfMatchedAccounts() {
            return numberOfMatchedAccounts;
        }

        public final void setNumberOfMatchedAccounts(Integer numberOfMatchedAccounts) {
            this.numberOfMatchedAccounts = numberOfMatchedAccounts;
        }

        @Override
        public final Builder numberOfMatchedAccounts(Integer numberOfMatchedAccounts) {
            this.numberOfMatchedAccounts = numberOfMatchedAccounts;
            return this;
        }

        public final Integer getNumberOfUnmatchedAccounts() {
            return numberOfUnmatchedAccounts;
        }

        public final void setNumberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts) {
            this.numberOfUnmatchedAccounts = numberOfUnmatchedAccounts;
        }

        @Override
        public final Builder numberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts) {
            this.numberOfUnmatchedAccounts = numberOfUnmatchedAccounts;
            return this;
        }

        public final List<RegionalSummary.Builder> getRegionalSummaries() {
            List<RegionalSummary.Builder> result = RegionalSummaryListCopier.copyToBuilder(this.regionalSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionalSummaries(Collection<RegionalSummary.BuilderImpl> regionalSummaries) {
            this.regionalSummaries = RegionalSummaryListCopier.copyFromBuilder(regionalSummaries);
        }

        @Override
        public final Builder regionalSummaries(Collection<RegionalSummary> regionalSummaries) {
            this.regionalSummaries = RegionalSummaryListCopier.copy(regionalSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalSummaries(RegionalSummary... regionalSummaries) {
            regionalSummaries(Arrays.asList(regionalSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalSummaries(Consumer<RegionalSummary.Builder>... regionalSummaries) {
            regionalSummaries(Stream.of(regionalSummaries).map(c -> RegionalSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AttributeSummary build() {
            return new AttributeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
