/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import volume task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportVolumeTaskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportVolumeTaskDetails.Builder, ImportVolumeTaskDetails> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(ImportVolumeTaskDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(ImportVolumeTaskDetails::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<Long> BYTES_CONVERTED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("BytesConverted")
            .getter(getter(ImportVolumeTaskDetails::bytesConverted))
            .setter(setter(Builder::bytesConverted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesConverted")
                    .unmarshallLocationName("bytesConverted").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportVolumeTaskDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<DiskImageDescription> IMAGE_FIELD = SdkField
            .<DiskImageDescription> builder(MarshallingType.SDK_POJO)
            .memberName("Image")
            .getter(getter(ImportVolumeTaskDetails::image))
            .setter(setter(Builder::image))
            .constructor(DiskImageDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image")
                    .unmarshallLocationName("image").build()).build();

    private static final SdkField<DiskImageVolumeDescription> VOLUME_FIELD = SdkField
            .<DiskImageVolumeDescription> builder(MarshallingType.SDK_POJO)
            .memberName("Volume")
            .getter(getter(ImportVolumeTaskDetails::volume))
            .setter(setter(Builder::volume))
            .constructor(DiskImageVolumeDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volume")
                    .unmarshallLocationName("volume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, BYTES_CONVERTED_FIELD, DESCRIPTION_FIELD, IMAGE_FIELD, VOLUME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Long bytesConverted;

    private final String description;

    private final DiskImageDescription image;

    private final DiskImageVolumeDescription volume;

    private ImportVolumeTaskDetails(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.bytesConverted = builder.bytesConverted;
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    /**
     * <p>
     * The Availability Zone where the resulting volume will reside.
     * </p>
     * 
     * @return The Availability Zone where the resulting volume will reside.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the Availability Zone where the resulting volume will reside.
     * </p>
     * 
     * @return The ID of the Availability Zone where the resulting volume will reside.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The number of bytes converted so far.
     * </p>
     * 
     * @return The number of bytes converted so far.
     */
    public final Long bytesConverted() {
        return bytesConverted;
    }

    /**
     * <p>
     * The description you provided when starting the import volume task.
     * </p>
     * 
     * @return The description you provided when starting the import volume task.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The image.
     * </p>
     * 
     * @return The image.
     */
    public final DiskImageDescription image() {
        return image;
    }

    /**
     * <p>
     * The volume.
     * </p>
     * 
     * @return The volume.
     */
    public final DiskImageVolumeDescription volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(bytesConverted());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(volume());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeTaskDetails)) {
            return false;
        }
        ImportVolumeTaskDetails other = (ImportVolumeTaskDetails) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(bytesConverted(), other.bytesConverted()) && Objects.equals(description(), other.description())
                && Objects.equals(image(), other.image()) && Objects.equals(volume(), other.volume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportVolumeTaskDetails").add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("BytesConverted", bytesConverted())
                .add("Description", description()).add("Image", image()).add("Volume", volume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "BytesConverted":
            return Optional.ofNullable(clazz.cast(bytesConverted()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "Volume":
            return Optional.ofNullable(clazz.cast(volume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("BytesConverted", BYTES_CONVERTED_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("Volume", VOLUME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportVolumeTaskDetails, T> g) {
        return obj -> g.apply((ImportVolumeTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportVolumeTaskDetails> {
        /**
         * <p>
         * The Availability Zone where the resulting volume will reside.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the resulting volume will reside.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the Availability Zone where the resulting volume will reside.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone where the resulting volume will reside.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The number of bytes converted so far.
         * </p>
         * 
         * @param bytesConverted
         *        The number of bytes converted so far.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesConverted(Long bytesConverted);

        /**
         * <p>
         * The description you provided when starting the import volume task.
         * </p>
         * 
         * @param description
         *        The description you provided when starting the import volume task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The image.
         * </p>
         * 
         * @param image
         *        The image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(DiskImageDescription image);

        /**
         * <p>
         * The image.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiskImageDescription.Builder} avoiding
         * the need to create one manually via {@link DiskImageDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskImageDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #image(DiskImageDescription)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link DiskImageDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(DiskImageDescription)
         */
        default Builder image(Consumer<DiskImageDescription.Builder> image) {
            return image(DiskImageDescription.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * The volume.
         * </p>
         * 
         * @param volume
         *        The volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(DiskImageVolumeDescription volume);

        /**
         * <p>
         * The volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiskImageVolumeDescription.Builder}
         * avoiding the need to create one manually via {@link DiskImageVolumeDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskImageVolumeDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #volume(DiskImageVolumeDescription)}.
         * 
         * @param volume
         *        a consumer that will call methods on {@link DiskImageVolumeDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volume(DiskImageVolumeDescription)
         */
        default Builder volume(Consumer<DiskImageVolumeDescription.Builder> volume) {
            return volume(DiskImageVolumeDescription.builder().applyMutation(volume).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String availabilityZoneId;

        private Long bytesConverted;

        private String description;

        private DiskImageDescription image;

        private DiskImageVolumeDescription volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeTaskDetails model) {
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            bytesConverted(model.bytesConverted);
            description(model.description);
            image(model.image);
            volume(model.volume);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Long getBytesConverted() {
            return bytesConverted;
        }

        public final void setBytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
        }

        @Override
        public final Builder bytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DiskImageDescription.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(DiskImageDescription.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(DiskImageDescription image) {
            this.image = image;
            return this;
        }

        public final DiskImageVolumeDescription.Builder getVolume() {
            return volume != null ? volume.toBuilder() : null;
        }

        public final void setVolume(DiskImageVolumeDescription.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public final Builder volume(DiskImageVolumeDescription volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public ImportVolumeTaskDetails build() {
            return new ImportVolumeTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
