/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route in a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Route implements SdkPojo, Serializable, ToCopyableBuilder<Route.Builder, Route> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(Route::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("destinationCidrBlock").build()).build();

    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationIpv6CidrBlock")
            .getter(getter(Route::destinationIpv6CidrBlock))
            .setter(setter(Builder::destinationIpv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock")
                    .unmarshallLocationName("destinationIpv6CidrBlock").build()).build();

    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationPrefixListId")
            .getter(getter(Route::destinationPrefixListId))
            .setter(setter(Builder::destinationPrefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId")
                    .unmarshallLocationName("destinationPrefixListId").build()).build();

    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EgressOnlyInternetGatewayId")
            .getter(getter(Route::egressOnlyInternetGatewayId))
            .setter(setter(Builder::egressOnlyInternetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId")
                    .unmarshallLocationName("egressOnlyInternetGatewayId").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GatewayId")
            .getter(getter(Route::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId")
                    .unmarshallLocationName("gatewayId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(Route::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceOwnerId")
            .getter(getter(Route::instanceOwnerId))
            .setter(setter(Builder::instanceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwnerId")
                    .unmarshallLocationName("instanceOwnerId").build()).build();

    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NatGatewayId")
            .getter(getter(Route::natGatewayId))
            .setter(setter(Builder::natGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId")
                    .unmarshallLocationName("natGatewayId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(Route::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId")
            .getter(getter(Route::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<String> CARRIER_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CarrierGatewayId")
            .getter(getter(Route::carrierGatewayId))
            .setter(setter(Builder::carrierGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewayId")
                    .unmarshallLocationName("carrierGatewayId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(Route::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Origin")
            .getter(getter(Route::originAsString))
            .setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin")
                    .unmarshallLocationName("origin").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(Route::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId")
            .getter(getter(Route::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId")
                    .unmarshallLocationName("vpcPeeringConnectionId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkArn")
            .getter(getter(Route::coreNetworkArn))
            .setter(setter(Builder::coreNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn")
                    .unmarshallLocationName("coreNetworkArn").build()).build();

    private static final SdkField<String> ODB_NETWORK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OdbNetworkArn")
            .getter(getter(Route::odbNetworkArn))
            .setter(setter(Builder::odbNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OdbNetworkArn")
                    .unmarshallLocationName("odbNetworkArn").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddress")
            .getter(getter(Route::ipAddress))
            .setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress")
                    .unmarshallLocationName("ipAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD,
            DESTINATION_IPV6_CIDR_BLOCK_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD,
            GATEWAY_ID_FIELD, INSTANCE_ID_FIELD, INSTANCE_OWNER_ID_FIELD, NAT_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD,
            LOCAL_GATEWAY_ID_FIELD, CARRIER_GATEWAY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, ORIGIN_FIELD, STATE_FIELD,
            VPC_PEERING_CONNECTION_ID_FIELD, CORE_NETWORK_ARN_FIELD, ODB_NETWORK_ARN_FIELD, IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationCidrBlock;

    private final String destinationIpv6CidrBlock;

    private final String destinationPrefixListId;

    private final String egressOnlyInternetGatewayId;

    private final String gatewayId;

    private final String instanceId;

    private final String instanceOwnerId;

    private final String natGatewayId;

    private final String transitGatewayId;

    private final String localGatewayId;

    private final String carrierGatewayId;

    private final String networkInterfaceId;

    private final String origin;

    private final String state;

    private final String vpcPeeringConnectionId;

    private final String coreNetworkArn;

    private final String odbNetworkArn;

    private final String ipAddress;

    private Route(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.natGatewayId = builder.natGatewayId;
        this.transitGatewayId = builder.transitGatewayId;
        this.localGatewayId = builder.localGatewayId;
        this.carrierGatewayId = builder.carrierGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.origin = builder.origin;
        this.state = builder.state;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.odbNetworkArn = builder.odbNetworkArn;
        this.ipAddress = builder.ipAddress;
    }

    /**
     * <p>
     * The IPv4 CIDR block used for the destination match.
     * </p>
     * 
     * @return The IPv4 CIDR block used for the destination match.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block used for the destination match.
     * </p>
     * 
     * @return The IPv6 CIDR block used for the destination match.
     */
    public final String destinationIpv6CidrBlock() {
        return destinationIpv6CidrBlock;
    }

    /**
     * <p>
     * The prefix of the Amazon Web Services service.
     * </p>
     * 
     * @return The prefix of the Amazon Web Services service.
     */
    public final String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    /**
     * <p>
     * The ID of the egress-only internet gateway.
     * </p>
     * 
     * @return The ID of the egress-only internet gateway.
     */
    public final String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of a gateway attached to your VPC.
     * </p>
     * 
     * @return The ID of a gateway attached to your VPC.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of a NAT instance in your VPC.
     * </p>
     * 
     * @return The ID of a NAT instance in your VPC.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of Amazon Web Services account that owns the instance.
     * </p>
     * 
     * @return The ID of Amazon Web Services account that owns the instance.
     */
    public final String instanceOwnerId() {
        return instanceOwnerId;
    }

    /**
     * <p>
     * The ID of a NAT gateway.
     * </p>
     * 
     * @return The ID of a NAT gateway.
     */
    public final String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The ID of a transit gateway.
     * </p>
     * 
     * @return The ID of a transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public final String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of the carrier gateway.
     * </p>
     * 
     * @return The ID of the carrier gateway.
     */
    public final String carrierGatewayId() {
        return carrierGatewayId;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Describes how the route was created.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateRoute</code> - The route was manually added to the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link RouteOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Describes how the route was created.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateRoute</code> - The route was manually added to the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     *         </p>
     *         </li>
     * @see RouteOrigin
     */
    public final RouteOrigin origin() {
        return RouteOrigin.fromValue(origin);
    }

    /**
     * <p>
     * Describes how the route was created.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateRoute</code> - The route was manually added to the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link RouteOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Describes how the route was created.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateRoute</code> - The route was manually added to the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     *         </p>
     *         </li>
     * @see RouteOrigin
     */
    public final String originAsString() {
        return origin;
    }

    /**
     * <p>
     * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available (for
     * example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been terminated).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
     *         available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
     *         has been terminated).
     * @see RouteState
     */
    public final RouteState state() {
        return RouteState.fromValue(state);
    }

    /**
     * <p>
     * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available (for
     * example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been terminated).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
     *         available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
     *         has been terminated).
     * @see RouteState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The ID of a VPC peering connection.
     * </p>
     * 
     * @return The ID of a VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the core network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the core network.
     */
    public final String coreNetworkArn() {
        return coreNetworkArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ODB network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ODB network.
     */
    public final String odbNetworkArn() {
        return odbNetworkArn;
    }

    /**
     * <p>
     * The next hop IP address for routes propagated by VPC Route Server into VPC route tables.
     * </p>
     * 
     * @return The next hop IP address for routes propagated by VPC Route Server into VPC route tables.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(carrierGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock())
                && Objects.equals(destinationPrefixListId(), other.destinationPrefixListId())
                && Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId())
                && Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceOwnerId(), other.instanceOwnerId())
                && Objects.equals(natGatewayId(), other.natGatewayId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(localGatewayId(), other.localGatewayId())
                && Objects.equals(carrierGatewayId(), other.carrierGatewayId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(originAsString(), other.originAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId())
                && Objects.equals(coreNetworkArn(), other.coreNetworkArn())
                && Objects.equals(odbNetworkArn(), other.odbNetworkArn()) && Objects.equals(ipAddress(), other.ipAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Route").add("DestinationCidrBlock", destinationCidrBlock())
                .add("DestinationIpv6CidrBlock", destinationIpv6CidrBlock())
                .add("DestinationPrefixListId", destinationPrefixListId())
                .add("EgressOnlyInternetGatewayId", egressOnlyInternetGatewayId()).add("GatewayId", gatewayId())
                .add("InstanceId", instanceId()).add("InstanceOwnerId", instanceOwnerId()).add("NatGatewayId", natGatewayId())
                .add("TransitGatewayId", transitGatewayId()).add("LocalGatewayId", localGatewayId())
                .add("CarrierGatewayId", carrierGatewayId()).add("NetworkInterfaceId", networkInterfaceId())
                .add("Origin", originAsString()).add("State", stateAsString())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).add("CoreNetworkArn", coreNetworkArn())
                .add("OdbNetworkArn", odbNetworkArn()).add("IpAddress", ipAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "DestinationIpv6CidrBlock":
            return Optional.ofNullable(clazz.cast(destinationIpv6CidrBlock()));
        case "DestinationPrefixListId":
            return Optional.ofNullable(clazz.cast(destinationPrefixListId()));
        case "EgressOnlyInternetGatewayId":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGatewayId()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceOwnerId":
            return Optional.ofNullable(clazz.cast(instanceOwnerId()));
        case "NatGatewayId":
            return Optional.ofNullable(clazz.cast(natGatewayId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "CarrierGatewayId":
            return Optional.ofNullable(clazz.cast(carrierGatewayId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        case "CoreNetworkArn":
            return Optional.ofNullable(clazz.cast(coreNetworkArn()));
        case "OdbNetworkArn":
            return Optional.ofNullable(clazz.cast(odbNetworkArn()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("DestinationIpv6CidrBlock", DESTINATION_IPV6_CIDR_BLOCK_FIELD);
        map.put("DestinationPrefixListId", DESTINATION_PREFIX_LIST_ID_FIELD);
        map.put("EgressOnlyInternetGatewayId", EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD);
        map.put("GatewayId", GATEWAY_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceOwnerId", INSTANCE_OWNER_ID_FIELD);
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("LocalGatewayId", LOCAL_GATEWAY_ID_FIELD);
        map.put("CarrierGatewayId", CARRIER_GATEWAY_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("VpcPeeringConnectionId", VPC_PEERING_CONNECTION_ID_FIELD);
        map.put("CoreNetworkArn", CORE_NETWORK_ARN_FIELD);
        map.put("OdbNetworkArn", ODB_NETWORK_ARN_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route, T> g) {
        return obj -> g.apply((Route) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Route> {
        /**
         * <p>
         * The IPv4 CIDR block used for the destination match.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The IPv4 CIDR block used for the destination match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The IPv6 CIDR block used for the destination match.
         * </p>
         * 
         * @param destinationIpv6CidrBlock
         *        The IPv6 CIDR block used for the destination match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock);

        /**
         * <p>
         * The prefix of the Amazon Web Services service.
         * </p>
         * 
         * @param destinationPrefixListId
         *        The prefix of the Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        /**
         * <p>
         * The ID of the egress-only internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of the egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The ID of a gateway attached to your VPC.
         * </p>
         * 
         * @param gatewayId
         *        The ID of a gateway attached to your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of a NAT instance in your VPC.
         * </p>
         * 
         * @param instanceId
         *        The ID of a NAT instance in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of Amazon Web Services account that owns the instance.
         * </p>
         * 
         * @param instanceOwnerId
         *        The ID of Amazon Web Services account that owns the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOwnerId(String instanceOwnerId);

        /**
         * <p>
         * The ID of a NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The ID of a transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of a transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of the carrier gateway.
         * </p>
         * 
         * @param carrierGatewayId
         *        The ID of the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierGatewayId(String carrierGatewayId);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Describes how the route was created.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateRoute</code> - The route was manually added to the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        Describes how the route was created.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateRoute</code> - The route was manually added to the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         *        </p>
         *        </li>
         * @see RouteOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteOrigin
         */
        Builder origin(String origin);

        /**
         * <p>
         * Describes how the route was created.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateRoute</code> - The route was manually added to the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        Describes how the route was created.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateRoute</code> - The route was manually added to the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         *        </p>
         *        </li>
         * @see RouteOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteOrigin
         */
        Builder origin(RouteOrigin origin);

        /**
         * <p>
         * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available
         * (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been
         * terminated).
         * </p>
         * 
         * @param state
         *        The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
         *        available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
         *        has been terminated).
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available
         * (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been
         * terminated).
         * </p>
         * 
         * @param state
         *        The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
         *        available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
         *        has been terminated).
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(RouteState state);

        /**
         * <p>
         * The ID of a VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of a VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the core network.
         * </p>
         * 
         * @param coreNetworkArn
         *        The Amazon Resource Name (ARN) of the core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkArn(String coreNetworkArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ODB network.
         * </p>
         * 
         * @param odbNetworkArn
         *        The Amazon Resource Name (ARN) of the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkArn(String odbNetworkArn);

        /**
         * <p>
         * The next hop IP address for routes propagated by VPC Route Server into VPC route tables.
         * </p>
         * 
         * @param ipAddress
         *        The next hop IP address for routes propagated by VPC Route Server into VPC route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String destinationIpv6CidrBlock;

        private String destinationPrefixListId;

        private String egressOnlyInternetGatewayId;

        private String gatewayId;

        private String instanceId;

        private String instanceOwnerId;

        private String natGatewayId;

        private String transitGatewayId;

        private String localGatewayId;

        private String carrierGatewayId;

        private String networkInterfaceId;

        private String origin;

        private String state;

        private String vpcPeeringConnectionId;

        private String coreNetworkArn;

        private String odbNetworkArn;

        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            destinationCidrBlock(model.destinationCidrBlock);
            destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            destinationPrefixListId(model.destinationPrefixListId);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            gatewayId(model.gatewayId);
            instanceId(model.instanceId);
            instanceOwnerId(model.instanceOwnerId);
            natGatewayId(model.natGatewayId);
            transitGatewayId(model.transitGatewayId);
            localGatewayId(model.localGatewayId);
            carrierGatewayId(model.carrierGatewayId);
            networkInterfaceId(model.networkInterfaceId);
            origin(model.origin);
            state(model.state);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            coreNetworkArn(model.coreNetworkArn);
            odbNetworkArn(model.odbNetworkArn);
            ipAddress(model.ipAddress);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationIpv6CidrBlock() {
            return destinationIpv6CidrBlock;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceOwnerId() {
            return instanceOwnerId;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getCarrierGatewayId() {
            return carrierGatewayId;
        }

        public final void setCarrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
        }

        @Override
        public final Builder carrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(RouteOrigin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getOdbNetworkArn() {
            return odbNetworkArn;
        }

        public final void setOdbNetworkArn(String odbNetworkArn) {
            this.odbNetworkArn = odbNetworkArn;
        }

        @Override
        public final Builder odbNetworkArn(String odbNetworkArn) {
            this.odbNetworkArn = odbNetworkArn;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        public Route build() {
            return new Route(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
