/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration and status of an image usage report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageUsageReport implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageUsageReport.Builder, ImageUsageReport> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ImageUsageReport::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> REPORT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReportId")
            .getter(getter(ImageUsageReport::reportId))
            .setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId")
                    .unmarshallLocationName("reportId").build()).build();

    private static final SdkField<List<ImageUsageResourceType>> RESOURCE_TYPES_FIELD = SdkField
            .<List<ImageUsageResourceType>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(ImageUsageReport::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeSet")
                    .unmarshallLocationName("resourceTypeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImageUsageResourceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageUsageResourceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(ImageUsageReport::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIdSet")
                    .unmarshallLocationName("accountIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(ImageUsageReport::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateReason")
            .getter(getter(ImageUsageReport::stateReason))
            .setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(ImageUsageReport::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTime")
            .getter(getter(ImageUsageReport::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime")
                    .unmarshallLocationName("expirationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImageUsageReport::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD,
            REPORT_ID_FIELD, RESOURCE_TYPES_FIELD, ACCOUNT_IDS_FIELD, STATE_FIELD, STATE_REASON_FIELD, CREATION_TIME_FIELD,
            EXPIRATION_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageId;

    private final String reportId;

    private final List<ImageUsageResourceType> resourceTypes;

    private final List<String> accountIds;

    private final String state;

    private final String stateReason;

    private final Instant creationTime;

    private final Instant expirationTime;

    private final List<Tag> tags;

    private ImageUsageReport(BuilderImpl builder) {
        this.imageId = builder.imageId;
        this.reportId = builder.reportId;
        this.resourceTypes = builder.resourceTypes;
        this.accountIds = builder.accountIds;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the image that was specified when the report was created.
     * </p>
     * 
     * @return The ID of the image that was specified when the report was created.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the report.
     * </p>
     * 
     * @return The ID of the report.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource types that were specified when the report was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The resource types that were specified when the report was created.
     */
    public final List<ImageUsageResourceType> resourceTypes() {
        return resourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Amazon Web Services accounts that were specified when the report was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The IDs of the Amazon Web Services accounts that were specified when the report was created.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * The current state of the report. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>available</code> - The report is available to view.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The report is being created and not available to view.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error</code> - The report could not be created.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current state of the report. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>available</code> - The report is available to view.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The report is being created and not available to view.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error</code> - The report could not be created.
     *         </p>
     *         </li>
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * Provides additional details when the report is in an <code>error</code> state.
     * </p>
     * 
     * @return Provides additional details when the report is in an <code>error</code> state.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The date and time when the report was created.
     * </p>
     * 
     * @return The date and time when the report was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time when Amazon EC2 will delete the report (30 days after the report was created).
     * </p>
     * 
     * @return The date and time when Amazon EC2 will delete the report (30 days after the report was created).
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the report.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageUsageReport)) {
            return false;
        }
        ImageUsageReport other = (ImageUsageReport) obj;
        return Objects.equals(imageId(), other.imageId()) && Objects.equals(reportId(), other.reportId())
                && hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(state(), other.state()) && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(expirationTime(), other.expirationTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageUsageReport").add("ImageId", imageId()).add("ReportId", reportId())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null)
                .add("AccountIds", hasAccountIds() ? accountIds() : null).add("State", state()).add("StateReason", stateReason())
                .add("CreationTime", creationTime()).add("ExpirationTime", expirationTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ReportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ReportId", REPORT_ID_FIELD);
        map.put("ResourceTypeSet", RESOURCE_TYPES_FIELD);
        map.put("AccountIdSet", ACCOUNT_IDS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageUsageReport, T> g) {
        return obj -> g.apply((ImageUsageReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageUsageReport> {
        /**
         * <p>
         * The ID of the image that was specified when the report was created.
         * </p>
         * 
         * @param imageId
         *        The ID of the image that was specified when the report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the report.
         * </p>
         * 
         * @param reportId
         *        The ID of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * The resource types that were specified when the report was created.
         * </p>
         * 
         * @param resourceTypes
         *        The resource types that were specified when the report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ImageUsageResourceType> resourceTypes);

        /**
         * <p>
         * The resource types that were specified when the report was created.
         * </p>
         * 
         * @param resourceTypes
         *        The resource types that were specified when the report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ImageUsageResourceType... resourceTypes);

        /**
         * <p>
         * The resource types that were specified when the report was created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ImageUsageResourceType.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.ImageUsageResourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ImageUsageResourceType.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceTypes(List<ImageUsageResourceType>)}.
         * 
         * @param resourceTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ImageUsageResourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTypes(java.util.Collection<ImageUsageResourceType>)
         */
        Builder resourceTypes(Consumer<ImageUsageResourceType.Builder>... resourceTypes);

        /**
         * <p>
         * The IDs of the Amazon Web Services accounts that were specified when the report was created.
         * </p>
         * 
         * @param accountIds
         *        The IDs of the Amazon Web Services accounts that were specified when the report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The IDs of the Amazon Web Services accounts that were specified when the report was created.
         * </p>
         * 
         * @param accountIds
         *        The IDs of the Amazon Web Services accounts that were specified when the report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The current state of the report. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>available</code> - The report is available to view.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The report is being created and not available to view.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error</code> - The report could not be created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the report. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>available</code> - The report is available to view.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The report is being created and not available to view.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error</code> - The report could not be created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * Provides additional details when the report is in an <code>error</code> state.
         * </p>
         * 
         * @param stateReason
         *        Provides additional details when the report is in an <code>error</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The date and time when the report was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time when the report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time when Amazon EC2 will delete the report (30 days after the report was created).
         * </p>
         * 
         * @param expirationTime
         *        The date and time when Amazon EC2 will delete the report (30 days after the report was created).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * Any tags assigned to the report.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the report.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String imageId;

        private String reportId;

        private List<ImageUsageResourceType> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private String stateReason;

        private Instant creationTime;

        private Instant expirationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageUsageReport model) {
            imageId(model.imageId);
            reportId(model.reportId);
            resourceTypes(model.resourceTypes);
            accountIds(model.accountIds);
            state(model.state);
            stateReason(model.stateReason);
            creationTime(model.creationTime);
            expirationTime(model.expirationTime);
            tags(model.tags);
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final List<ImageUsageResourceType.Builder> getResourceTypes() {
            List<ImageUsageResourceType.Builder> result = ImageUsageResourceTypeListCopier.copyToBuilder(this.resourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTypes(Collection<ImageUsageResourceType.BuilderImpl> resourceTypes) {
            this.resourceTypes = ImageUsageResourceTypeListCopier.copyFromBuilder(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<ImageUsageResourceType> resourceTypes) {
            this.resourceTypes = ImageUsageResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ImageUsageResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(Consumer<ImageUsageResourceType.Builder>... resourceTypes) {
            resourceTypes(Stream.of(resourceTypes).map(c -> ImageUsageResourceType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = UserIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = UserIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ImageUsageReport build() {
            return new ImageUsageReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
