/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageReferenceResourceType {
    EC2_INSTANCE("ec2:Instance"),
    EC2_LAUNCH_TEMPLATE("ec2:LaunchTemplate"),
    SSM_PARAMETER("ssm:Parameter"),
    IMAGEBUILDER_IMAGE_RECIPE("imagebuilder:ImageRecipe"),
    IMAGEBUILDER_CONTAINER_RECIPE("imagebuilder:ContainerRecipe"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageReferenceResourceType> VALUE_MAP;
    private final String value;

    private ImageReferenceResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageReferenceResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageReferenceResourceType> knownValues() {
        EnumSet<ImageReferenceResourceType> knownValues = EnumSet.allOf(ImageReferenceResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageReferenceResourceType.class, ImageReferenceResourceType::toString);
    }
}

