/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableAllowedImagesSettingsResponse extends Ec2Response implements
        ToCopyableBuilder<EnableAllowedImagesSettingsResponse.Builder, EnableAllowedImagesSettingsResponse> {
    private static final SdkField<String> ALLOWED_IMAGES_SETTINGS_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllowedImagesSettingsState")
            .getter(getter(EnableAllowedImagesSettingsResponse::allowedImagesSettingsStateAsString))
            .setter(setter(Builder::allowedImagesSettingsState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedImagesSettingsState")
                    .unmarshallLocationName("allowedImagesSettingsState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALLOWED_IMAGES_SETTINGS_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String allowedImagesSettingsState;

    private EnableAllowedImagesSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.allowedImagesSettingsState = builder.allowedImagesSettingsState;
    }

    /**
     * <p>
     * Returns <code>enabled</code> or <code>audit-mode</code> if the request succeeds; otherwise, it returns an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allowedImagesSettingsState} will return {@link AllowedImagesSettingsEnabledState#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #allowedImagesSettingsStateAsString}.
     * </p>
     * 
     * @return Returns <code>enabled</code> or <code>audit-mode</code> if the request succeeds; otherwise, it returns an
     *         error.
     * @see AllowedImagesSettingsEnabledState
     */
    public final AllowedImagesSettingsEnabledState allowedImagesSettingsState() {
        return AllowedImagesSettingsEnabledState.fromValue(allowedImagesSettingsState);
    }

    /**
     * <p>
     * Returns <code>enabled</code> or <code>audit-mode</code> if the request succeeds; otherwise, it returns an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allowedImagesSettingsState} will return {@link AllowedImagesSettingsEnabledState#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #allowedImagesSettingsStateAsString}.
     * </p>
     * 
     * @return Returns <code>enabled</code> or <code>audit-mode</code> if the request succeeds; otherwise, it returns an
     *         error.
     * @see AllowedImagesSettingsEnabledState
     */
    public final String allowedImagesSettingsStateAsString() {
        return allowedImagesSettingsState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allowedImagesSettingsStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAllowedImagesSettingsResponse)) {
            return false;
        }
        EnableAllowedImagesSettingsResponse other = (EnableAllowedImagesSettingsResponse) obj;
        return Objects.equals(allowedImagesSettingsStateAsString(), other.allowedImagesSettingsStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableAllowedImagesSettingsResponse")
                .add("AllowedImagesSettingsState", allowedImagesSettingsStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedImagesSettingsState":
            return Optional.ofNullable(clazz.cast(allowedImagesSettingsStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllowedImagesSettingsState", ALLOWED_IMAGES_SETTINGS_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableAllowedImagesSettingsResponse, T> g) {
        return obj -> g.apply((EnableAllowedImagesSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, EnableAllowedImagesSettingsResponse> {
        /**
         * <p>
         * Returns <code>enabled</code> or <code>audit-mode</code> if the request succeeds; otherwise, it returns an
         * error.
         * </p>
         * 
         * @param allowedImagesSettingsState
         *        Returns <code>enabled</code> or <code>audit-mode</code> if the request succeeds; otherwise, it returns
         *        an error.
         * @see AllowedImagesSettingsEnabledState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedImagesSettingsEnabledState
         */
        Builder allowedImagesSettingsState(String allowedImagesSettingsState);

        /**
         * <p>
         * Returns <code>enabled</code> or <code>audit-mode</code> if the request succeeds; otherwise, it returns an
         * error.
         * </p>
         * 
         * @param allowedImagesSettingsState
         *        Returns <code>enabled</code> or <code>audit-mode</code> if the request succeeds; otherwise, it returns
         *        an error.
         * @see AllowedImagesSettingsEnabledState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowedImagesSettingsEnabledState
         */
        Builder allowedImagesSettingsState(AllowedImagesSettingsEnabledState allowedImagesSettingsState);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String allowedImagesSettingsState;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAllowedImagesSettingsResponse model) {
            super(model);
            allowedImagesSettingsState(model.allowedImagesSettingsState);
        }

        public final String getAllowedImagesSettingsState() {
            return allowedImagesSettingsState;
        }

        public final void setAllowedImagesSettingsState(String allowedImagesSettingsState) {
            this.allowedImagesSettingsState = allowedImagesSettingsState;
        }

        @Override
        public final Builder allowedImagesSettingsState(String allowedImagesSettingsState) {
            this.allowedImagesSettingsState = allowedImagesSettingsState;
            return this;
        }

        @Override
        public final Builder allowedImagesSettingsState(AllowedImagesSettingsEnabledState allowedImagesSettingsState) {
            this.allowedImagesSettingsState(allowedImagesSettingsState == null ? null : allowedImagesSettingsState.toString());
            return this;
        }

        @Override
        public EnableAllowedImagesSettingsResponse build() {
            return new EnableAllowedImagesSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
