/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource used to provision CIDRs to a resource planning pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamPoolSourceResource implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamPoolSourceResource.Builder, IpamPoolSourceResource> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(IpamPoolSourceResource::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(IpamPoolSourceResource::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceRegion")
            .getter(getter(IpamPoolSourceResource::resourceRegion))
            .setter(setter(Builder::resourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion")
                    .unmarshallLocationName("resourceRegion").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwner")
            .getter(getter(IpamPoolSourceResource::resourceOwner))
            .setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner")
                    .unmarshallLocationName("resourceOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_REGION_FIELD, RESOURCE_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String resourceType;

    private final String resourceRegion;

    private final String resourceOwner;

    private IpamPoolSourceResource(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceRegion = builder.resourceRegion;
        this.resourceOwner = builder.resourceOwner;
    }

    /**
     * <p>
     * The source resource ID.
     * </p>
     * 
     * @return The source resource ID.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The source resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamPoolSourceResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The source resource type.
     * @see IpamPoolSourceResourceType
     */
    public final IpamPoolSourceResourceType resourceType() {
        return IpamPoolSourceResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The source resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamPoolSourceResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The source resource type.
     * @see IpamPoolSourceResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The source resource Region.
     * </p>
     * 
     * @return The source resource Region.
     */
    public final String resourceRegion() {
        return resourceRegion;
    }

    /**
     * <p>
     * The source resource owner.
     * </p>
     * 
     * @return The source resource owner.
     */
    public final String resourceOwner() {
        return resourceOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPoolSourceResource)) {
            return false;
        }
        IpamPoolSourceResource other = (IpamPoolSourceResource) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceRegion(), other.resourceRegion())
                && Objects.equals(resourceOwner(), other.resourceOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamPoolSourceResource").add("ResourceId", resourceId())
                .add("ResourceType", resourceTypeAsString()).add("ResourceRegion", resourceRegion())
                .add("ResourceOwner", resourceOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceRegion":
            return Optional.ofNullable(clazz.cast(resourceRegion()));
        case "ResourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceRegion", RESOURCE_REGION_FIELD);
        map.put("ResourceOwner", RESOURCE_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPoolSourceResource, T> g) {
        return obj -> g.apply((IpamPoolSourceResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamPoolSourceResource> {
        /**
         * <p>
         * The source resource ID.
         * </p>
         * 
         * @param resourceId
         *        The source resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The source resource type.
         * </p>
         * 
         * @param resourceType
         *        The source resource type.
         * @see IpamPoolSourceResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPoolSourceResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The source resource type.
         * </p>
         * 
         * @param resourceType
         *        The source resource type.
         * @see IpamPoolSourceResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPoolSourceResourceType
         */
        Builder resourceType(IpamPoolSourceResourceType resourceType);

        /**
         * <p>
         * The source resource Region.
         * </p>
         * 
         * @param resourceRegion
         *        The source resource Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRegion(String resourceRegion);

        /**
         * <p>
         * The source resource owner.
         * </p>
         * 
         * @param resourceOwner
         *        The source resource owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwner(String resourceOwner);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private String resourceRegion;

        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPoolSourceResource model) {
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            resourceRegion(model.resourceRegion);
            resourceOwner(model.resourceOwner);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamPoolSourceResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceRegion() {
            return resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public IpamPoolSourceResource build() {
            return new IpamPoolSourceResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
